#include "GasModel.h"

GasModel::GasModel(Unit* m, int i) {
	unitsAssigned = 90; // just needs to be high
	element = m;
	startingResources = i;
}

void GasModel::assignUnit() {
	unitsAssigned++;
}

	int GasModel::getStartingResources() {
		return startingResources;
	}

int GasModel::assignedUnits() {
	return unitsAssigned;
}

void GasModel::assignUnitCount(int c) {
	unitsAssigned = c;
}

bool GasModel::isEmpty() {
	return element->getResources() <= 0;
}

bool GasModel::hasRefinery() {
	return element->getType().isRefinery() && element->isCompleted();
}


Unit* GasModel::getUnit() {
	return element;
}

bool GasModel::canBeMined() {
	std::set<Unit*> gatherers = Broodwar->getUnitsInRadius(element->getPosition(), 350);
	int count = 0;
	for(std::set<Unit*>::const_iterator it = gatherers.begin(); it!=gatherers.end();it++) {
		Unit* worker = *it;
		if(worker->getPlayer() == Broodwar->self() && worker->getType().isWorker()) {
			if(worker->isGatheringGas() || worker->isCarryingGas()) {
				count++;
			}
		}
	}
	return count < 3 && element->getResources() > 0;
}