#include "ExecutionCommanderAgent.h"
#include "OffensiveTactics_GoalGeneratorHeaders.h"
#include "SquadReccomender.h"
ExecutionCommanderAgent::ExecutionCommanderAgent(AgentPool* p) {
	agentPool = p;
}

void ExecutionCommanderAgent::execute(std::vector<GoalDescriptor*> goals) {
	ConstructionAgent* c = (ConstructionAgent*)agentPool->getAgent("C");
	ResourceManagerAgent* r = (ResourceManagerAgent*)agentPool->getAgent("R");
	TrainingManagerAgent* t = (TrainingManagerAgent*)agentPool->getAgent("T");
	SquadManagerAgent* s = (SquadManagerAgent*)agentPool->getAgent("SQ");
	ResearchManagerAgent* rm = (ResearchManagerAgent*)agentPool->getAgent("RE");
	InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
	InformationManagerAgent* eim = (InformationManagerAgent*)agentPool->getAgent("EI");
	BaseDefenseManagerAgent* b = (BaseDefenseManagerAgent*)agentPool->getAgent("BD");
	MilitaryProductionManagerAgent* mp =  (MilitaryProductionManagerAgent*)agentPool->getAgent("MP");

	for(unsigned int i = 0; i < goals.size(); i++) {
		GoalDescriptor* g = goals.at(i);

		if(!g->isExecuting() && !g->isFinished() && !g->accepted() && g->getInhibitionStatus() == false) {
			switch(g->getGoalType()) {
			case DEFENSE_BUILDAIRDEFENSE: 
				{
					

					
					if(c->canBeConstructed(UnitTypes::Terran_Missile_Turret) && g->canExpendResources()) {
						
						BaseModel* targetBase = b->findWeakestBaseAirDefense();
						if(targetBase != NULL) {
						Unit* worker = c->findAvailableWorkerNear(targetBase->getPosition(), 750);
						if(worker != NULL) {
						worker = c->buildStructureAround(UnitTypes::Terran_Missile_Turret, worker, (TilePosition)targetBase->getPosition());
						if(worker != NULL) {
							
							g->setMonitorTarget(worker);
							g->execute();
							agentPool->getSquads()->getSquadByName("workers")->removeUnit(worker);
						}
						}
					}
					}
				}
				break;

			case DEFENSE_BUILDGROUNDDEFENSE: 
				{
					if(c->canBeConstructed(UnitTypes::Terran_Bunker) && g->canExpendResources()) {
						BaseModel* targetBase = b->findWeakestBaseGroundDefense();
						
						Unit* worker = c->findAvailableWorkerNear(targetBase->getPosition(), 750);
						
							if(worker != NULL) {

								std::set<Chokepoint*> cp = BWTA::getNearestBaseLocation(targetBase->getPosition())->getRegion()->getChokepoints();
								Chokepoint* bestCP = NULL;
								int bestFitness = 0;
								for(std::set<Chokepoint*>::const_iterator p = cp.begin(); p != cp.end(); p++) {
										
										int fitness = (15000-(*p)->getWidth()) + (5000-(*p)->getCenter().getDistance(targetBase->getPosition()));

										if(!eim->getKnownBuildings().empty()) {
											fitness+=(5000-(*p)->getCenter().getDistance(eim->getKnownBuildings().at(0)->getLastKnownPosition()));
										}

										std::set<Unit*> surroundingUnits = Broodwar->getUnitsInRadius((*p)->getCenter(), 500);
										for(std::set<Unit*>::const_iterator k = surroundingUnits.begin(); k != surroundingUnits.end(); k++) {
											if((*k)->getType().isNeutral() || !(*k)->getType().isMineralField() || (*k)->getType().isSpecialBuilding()){
												fitness -= 10000;
											}
										}
										//if((*p)->getWidth() > bestCP->getWidth() && (*p)->getCenter().getDistance(targetBase->getPosition()) < 400) {
											if(bestCP == NULL) {
												bestCP = *p;
											} else {
										if(fitness > bestFitness) {
											bestCP = *p;
											bestFitness = fitness;
										}
											}

									
								}

								//if(rand()%100 < 50 && bestCP != NULL){ 
									worker = c->buildStructureAround(UnitTypes::Terran_Bunker, worker, (TilePosition)bestCP->getCenter());
								//} else {
								//	worker = c->buildStructureAround(UnitTypes::Terran_Bunker, worker, (TilePosition)targetBase->getPosition());
								//}
						if(worker != NULL) {
					
							g->setMonitorTarget(worker);
							g->execute();
							agentPool->getSquads()->getSquadByName("workers")->removeUnit(worker);
						}
							}
					}
				}
				break;

			case RESOURCE_CLEAROBSTRUCTIONS:
				{
					
					std::vector<Unit*> o = im->findLocalObstructions();
				if(!o.empty()) {
					Unit* worker = c->findAvailableWorker();
					if(worker != NULL && !o.at(0)->isBeingGathered()) {
						agentPool->getSquads()->getSquadByName("workers")->removeUnit(worker);
						worker->stop();
						worker->gather(o.at(0));
						
						g->setMonitorTarget(worker);
						g->execute();
						
					}
				}
				}
				break;

			case RESOURCE_TRAINWORKER:
				{
					
					if(t->canBeTrained(UnitTypes::Terran_SCV) && g->canExpendResources()) {
						Position target = Position(-1,-1);
						
						for (unsigned int i = im->getBases().size(); i-- > 0; ) {
								
							BaseModel* currentBase = im->getBases().at(i);
							if(currentBase->isActive() && r->getNumWorkersMining(currentBase) <= currentBase->getLocalMinerals().size()*2) {
									
								target = currentBase->getPosition();
								
								break;
							}
						}
						if(target.x() != -1) {
						
						
						Unit* worker = t->trainUnit(UnitTypes::Terran_SCV, target);
						
						if(worker != NULL) {
								
							g->setMonitorTarget(worker);
								
							g->execute();
							
						}
					}
					}
				}
				break;
			case RESOURCE_BUILDSUPPLY:
				{
					if(c->canBeConstructed(Broodwar->self()->getRace().getSupplyProvider()) && g->canExpendResources()) {
						Unit* worker = c->findAvailableWorker();
						
						if(worker != NULL) {
							worker = c->buildStructure(Broodwar->self()->getRace().getSupplyProvider(), worker);
						if(worker != NULL) {
							g->setMonitorTarget(worker);
							g->execute();
							agentPool->getSquads()->getSquadByName("workers")->removeUnit(worker);
						}
						}
					}
				}
				break;
			case MILITARY_BUILDSCIENCEFACILITY:
				{
					

					if(c->canBeConstructed(UnitTypes::Terran_Science_Facility) && g->canExpendResources()) {
						Unit* worker = c->findAvailableWorker();
							if(worker != NULL) {
						worker = c->buildStructure(UnitTypes::Terran_Science_Facility, worker);
						if(worker != NULL) {
							
							g->setMonitorTarget(worker);
							g->execute();
							agentPool->getSquads()->getSquadByName("workers")->removeUnit(worker);
						}
							}
					}
				}
				break;

			case RESOURCE_BUILDEXPANSION:
				

				
				if(c->canBeConstructed(UnitTypes::Terran_Command_Center) && g->canExpendResources()) {
					Unit* worker = c->findAvailableWorkerNear(im->getBases().at(im->getBases().size()-1)->getPosition(), 500);
					if(worker != NULL) {
						
						BaseBuildingSCVTactics* b = new BaseBuildingSCVTactics(worker, agentPool);
						BaseLocation* p = im->findClosestExpansionPoint();
						if(p != NULL) {
						agentPool->getSquads()->getSquadByName("workers")->removeUnit(worker);
						worker->stop();
						b->move(p);
					
							g->setTacticsMonitorTarget(b);
							g->execute();
						}
						
					}

				}
				break;
			case RESOURCE_BUILDREFINERY:
				{
					

					if(c->canBeConstructed(UnitTypes::Terran_Refinery) && g->canExpendResources()) {
						
						Unit* worker = c->findAvailableWorker();
						if(worker != NULL) {
						
						Unit* freeGas = r->getFreeGas();
						if(freeGas != NULL) {
						worker = c->buildStructure(UnitTypes::Terran_Refinery, freeGas->getTilePosition(), worker);
						
						if(worker != NULL) {
							
							g->setMonitorTarget(worker);
							g->execute();

							agentPool->getSquads()->getSquadByName("workers")->removeUnit(worker);
						}
						}
					}
					}
				}
				break;

			case MILITARY_BUILDBARRACKS:
				{
					

					if(c->canBeConstructed(BWAPI::UnitTypes::Terran_Barracks) && g->canExpendResources()) {
						Unit* worker = c->findAvailableWorker();
							if(worker != NULL) {
						worker = c->buildStructure(BWAPI::UnitTypes::Terran_Barracks, worker);
						if(worker != NULL) {
							g->setMonitorTarget(worker);
							g->execute();
							agentPool->getSquads()->getSquadByName("workers")->removeUnit(worker);
						}
							}
					}
				}
				break;

			case MILITARY_BUILDACADEMY:
				{
					

					if(c->canBeConstructed(BWAPI::UnitTypes::Terran_Academy) && g->canExpendResources()) {
						Unit* worker = c->findAvailableWorker();
						
						worker = c->buildStructure(BWAPI::UnitTypes::Terran_Academy, worker);
						if(worker != NULL) {
							g->setMonitorTarget(worker);

							g->execute();
							agentPool->getSquads()->getSquadByName("workers")->removeUnit(worker);
						}
					}
				}
				break;
			case MILITARY_BUILDFACTORY:
				{
					

					if(c->canBeConstructed(BWAPI::UnitTypes::Terran_Factory) && g->canExpendResources()) {
						
						Unit* worker = c->findAvailableWorker();
						if(worker != NULL) {
						worker = c->buildStructure(BWAPI::UnitTypes::Terran_Factory, worker);
							if(worker != NULL) {
								
								g->setMonitorTarget(worker);
								g->execute();
								agentPool->getSquads()->getSquadByName("workers")->removeUnit(worker);
							}
						}
					}
				}
				break;

			case MILITARY_BUILDARMORY:
				
				if(c->canBeConstructed(BWAPI::UnitTypes::Terran_Armory) && g->canExpendResources()) {
					Unit* worker = c->findAvailableWorker();
						if(worker != NULL) {
					worker = c->buildStructure(BWAPI::UnitTypes::Terran_Armory, worker);
					if(worker != NULL) {
						g->setMonitorTarget(worker);
						g->execute();
						agentPool->getSquads()->getSquadByName("workers")->removeUnit(worker);
					}
						}
				}
				break;

			case MILITARY_BUILDSTARPORT:
				
				if(c->canBeConstructed(BWAPI::UnitTypes::Terran_Starport) && g->canExpendResources()) {
					Unit* worker = c->findAvailableWorker();
						if(worker != NULL) {
					worker = c->buildStructure(BWAPI::UnitTypes::Terran_Starport, worker);
					if(worker != NULL) {
						g->setMonitorTarget(worker);
						g->execute();
						agentPool->getSquads()->getSquadByName("workers")->removeUnit(worker);
					}
						}
				}
				break;

			case MILITARY_BUILDENGINEERINGBAY:
				
				if(c->canBeConstructed(BWAPI::UnitTypes::Terran_Engineering_Bay) && g->canExpendResources()) {
					Unit* worker = c->findAvailableWorker();
						if(worker != NULL) {
					worker = c->buildStructure(BWAPI::UnitTypes::Terran_Engineering_Bay, worker);
					if(worker != NULL) {
						g->setMonitorTarget(worker);
						g->execute();
						agentPool->getSquads()->getSquadByName("workers")->removeUnit(worker);
					}
						}
				}
				break;

			case MILITARY_TRAINFIREBAT:
				
				if(t->canBeTrained(BWAPI::UnitTypes::Terran_Firebat) && g->canExpendResources()) {
					
					g->setMonitorTarget(t->trainUnit(BWAPI::UnitTypes::Terran_Firebat));
					g->execute();
				}
				break;
			case MILITARY_TRAINMARINE:
				
				if(t->canBeTrained(BWAPI::UnitTypes::Terran_Marine) && g->canExpendResources()) {
					
					g->setMonitorTarget(t->trainUnit(BWAPI::UnitTypes::Terran_Marine));
					g->execute();
				}
				break;

			case MILITARY_TRAINMEDIC:
				
				if(t->canBeTrained(BWAPI::UnitTypes::Terran_Medic) && g->canExpendResources()) {
					g->setMonitorTarget(t->trainUnit(BWAPI::UnitTypes::Terran_Medic));
					g->execute();
				}
				break;

			case MILITARY_TRAINTANK:
				{
					//////agentPool->writeDebugMessage("seeing if i can train a tank...");
					if(t->canBeTrained(BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode) && g->canExpendResources()) {
						//////agentPool->writeDebugMessage("i can!");
						Unit* ut = t->trainUnit(BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode);
						if(ut != NULL) {
							{
									//////agentPool->writeDebugMessage("training begun!");
								g->setMonitorTarget(ut);
								g->execute();
							}
						}
					} else {
								//////agentPool->writeDebugMessage("enope cant do itd");
					}
				break;

			case MILITARY_TRAINVULTURE:
				
				{
					if(t->canBeTrained(BWAPI::UnitTypes::Terran_Vulture) && g->canExpendResources()) {
						////Broodwar->sendText("TRAINING VULTURE!!!!");
						Unit* ut = t->trainUnit(BWAPI::UnitTypes::Terran_Vulture);
						if(ut != NULL) {
							{
								
								g->setMonitorTarget(ut);
								g->execute();
							}
						}
					}
					}
				break;

			case MILITARY_TRAINGOLIATH:
				{
					
					if(t->canBeTrained(BWAPI::UnitTypes::Terran_Goliath) && g->canExpendResources()) {
						Unit* ut = t->trainUnit(BWAPI::UnitTypes::Terran_Goliath);
						if(ut!= NULL) {
							g->setMonitorTarget(ut);
							g->execute();
						}
					}
				}

				break;

			case MILITARY_TRAINBATTLECRUISER:
				{
					
					if(t->canBeTrained(BWAPI::UnitTypes::Terran_Battlecruiser) && g->canExpendResources()) {
						Unit* ut = t->trainUnit(BWAPI::UnitTypes::Terran_Battlecruiser);
						if(ut != NULL)
						{
							g->setMonitorTarget(ut);
							g->execute();
						}
					}
				}
				break;

			case MILITARY_TRAINSCIENCEVESSEL:
				
				if(t->canBeTrained(BWAPI::UnitTypes::Terran_Science_Vessel) && g->canExpendResources()) {
					g->setMonitorTarget(t->trainUnit(BWAPI::UnitTypes::Terran_Science_Vessel));
					g->execute();
				}
				break;
			case MILITARY_TRAINFLYER:
				{
					
					UnitType best = im->getReccomendedFlyerType();
					
					
					if(t->canBeTrained(best) && g->canExpendResources()) {
						
						Unit* ut = t->trainUnit(best);
						if(ut != NULL)
						{
							g->setMonitorTarget(ut);
							g->execute();
						}
					}
				}
				break;

				case MILITARY_TRAINDROPSHIP:
				{
					if(t->canBeTrained(UnitTypes::Terran_Dropship) && g->canExpendResources()) {
						g->setMonitorTarget(t->trainUnit(UnitTypes::Terran_Dropship));
						g->execute();
					}
				}
				break;
			case RESEARCH_BIOWEAPONS:
				
				
				break;

			case RESEARCH_BIOATTACK:
				//////agentPool->writeDebugMessage("execute research infantry weapons");
				if(rm->canBeUpgraded(UpgradeTypes::Terran_Infantry_Weapons) && g->canExpendResources()) {
					Unit* mon = rm->upgradeTech(UpgradeTypes::Terran_Infantry_Weapons);
					if(mon != NULL) {
								//////agentPool->writeDebugMessage("running");
						g->setMonitorTarget(mon);
						g->execute();
					}
				}
				break;

			case RESEARCH_BIODEFENSE:
				//////agentPool->writeDebugMessage("execute research infantry armor");
				if(rm->canBeUpgraded(UpgradeTypes::Terran_Infantry_Armor) && g->canExpendResources()) {
					Unit* mon = rm->upgradeTech(UpgradeTypes::Terran_Infantry_Armor);
					if(mon != NULL) {
						//////agentPool->writeDebugMessage("running");
						g->setMonitorTarget(mon);
						g->execute();
					}
				}
				break;

			case RESEARCH_MECHATTACK:
				
				if(rm->canBeUpgraded(UpgradeTypes::Terran_Vehicle_Weapons) && g->canExpendResources()) {
					g->setMonitorTarget(rm->upgradeTech(UpgradeTypes::Terran_Vehicle_Weapons));
					g->execute();
				}
				break;

			case RESEARCH_MECHDEFENSE:
				
				if(rm->canBeUpgraded(UpgradeTypes::Terran_Vehicle_Plating) && g->canExpendResources()) {
					g->setMonitorTarget(rm->upgradeTech(UpgradeTypes::Terran_Vehicle_Plating));
					g->execute();
				}
				break;
			case RESEARCH_IRRIDATE:
				if(rm->canBeResearched(TechTypes::Irradiate) && g->canExpendResources()) {
					g->setMonitorTarget(rm->researchTech(TechTypes::Irradiate));
					g->execute();
				}
				break;

			case RESEARCH_EMP:
				if(rm->canBeResearched(TechTypes::EMP_Shockwave) && g->canExpendResources()) {
					g->setMonitorTarget(rm->researchTech(TechTypes::EMP_Shockwave));
					g->execute();
				}
				break;
			case RESEARCH_BIOWEAPONS_STIMPACKS:
				
				if(rm->canBeResearched(TechTypes::Stim_Packs) && g->canExpendResources()) {
					g->setMonitorTarget(rm->researchTech(TechTypes::Stim_Packs));
					g->execute();
				}
				break;
			case RESEARCH_WRAITHCLOAK:
				
				if(rm->canBeResearched(TechTypes::Cloaking_Field) && g->canExpendResources()) {
					g->setMonitorTarget(rm->researchTech(TechTypes::Cloaking_Field));
					g->execute();
				}
				break;

			case RESEARCH_BIOWEAPONS_MARINERANGE:
				
				if(rm->canBeUpgraded(UpgradeTypes::U_238_Shells) && g->canExpendResources()) {
					g->setMonitorTarget(rm->upgradeTech(UpgradeTypes::U_238_Shells));
					g->execute();
				}
				break;

			case RESEARCH_MECHUTIL_SIEGEMODE:
				
				if(rm->canBeResearched(TechTypes::Tank_Siege_Mode) && g->canExpendResources()) {
					Unit* r = rm->researchTech(TechTypes::Tank_Siege_Mode);
					if(r != NULL) {
						g->setMonitorTarget(r);
						g->execute();
					}
				}
				break;

			case RESEARCH_MECHUTIL_IONTHRUSTERS:

				{

					if(rm->canBeUpgraded(UpgradeTypes::Ion_Thrusters) && g->canExpendResources()) {
						Unit* r = rm->upgradeTech(UpgradeTypes::Ion_Thrusters);
						if(r != NULL) {
							g->setMonitorTarget(r);
							g->execute();
						}
					}
				}
				break;

			case RESEARCH_MECHUTIL_CHARONBOOSTERS:

				{

					if(rm->canBeUpgraded(UpgradeTypes::Charon_Boosters) && g->canExpendResources()) {
						Unit* r = rm->upgradeTech(UpgradeTypes::Charon_Boosters);
						if(r != NULL) {
							g->setMonitorTarget(r);
							g->execute();
						}
					}
				}
				break;

			case UPGRADE_SCIENCEFACILITY: 
				{
					
					if(g->canExpendResources()) {
						
						std::vector<Unit*> facilities = im->getBuildingsOfType(UnitTypes::Terran_Science_Facility);
						if(!facilities.empty()) {
							
							if(!facilities.at(0)->isTraining() && !facilities.at(0)->isConstructing()) {
								
								if(c->canBeConstructed(BWAPI::UnitTypes::Terran_Physics_Lab, facilities.at((0)))) {
									
									Unit* worker = facilities.at(0);
									
									bool w = worker->buildAddon(BWAPI::UnitTypes::Terran_Physics_Lab);
									if(w) {
										g->setMonitorTarget(worker);
										
										g->execute();
									}
								}
							}
						} else {
							
						}
					}
				}

				break;
			case UPGRADE_COMMANDCENTRE:
				{
					
				}
				break;

			case UPGRADE_COMMANDCENTRE_COMSAT:
				{
					
					if(g->canExpendResources()) {
						
						std::vector<Unit*> commandCentres = im->getBuildingsOfType(UnitTypes::Terran_Command_Center);
						if(!commandCentres.empty()) {
							
							for(unsigned int i = 0; i < commandCentres.size(); i++) {
								if(!commandCentres.at(i)->isTraining() && commandCentres.at(i)->getAddon() == NULL) {
									
								
										
										bool s =  commandCentres.at(i)->buildAddon(Terran_Comsat_Station);
										
										if(s == true) {
											
											g->setMonitorTarget(commandCentres.at(i));
											g->execute();
											break;
										}
									
								}
							}
						}
					}
				}
				break;

			case UPGRADE_STARPORT:
					{
						
						if(g->canExpendResources()) {
							
							std::vector<Unit*> starports = im->getBuildingsOfType(UnitTypes::Terran_Starport);
							if(!starports.empty()) {

								
								for(unsigned int i = 0; i < starports.size(); i++) {
								if(!starports.at(i)->isTraining() && !starports.at(i)->isConstructing()) {
									
									if(c->canBeConstructed(BWAPI::UnitTypes::Terran_Control_Tower, starports.at((i)))) {
										
										Unit* worker = starports.at(i);
										
										bool w = worker->buildAddon(UnitTypes::Terran_Control_Tower);
										if(w) {
											g->setMonitorTarget(worker);
											
											g->execute();
										}
									}
								}
								}
							}
						}
					}
				break;
			case UPGRADE_FACTORY:
				{
					
					if(g->canExpendResources()) {
						
						std::vector<Unit*> factories = im->getBuildingsOfType(UnitTypes::Terran_Factory);
						if(!factories.empty()) {
							
								for(unsigned int i = 0; i < factories.size(); i++) {
							if(!factories.at(i)->isTraining() && !factories.at(i)->isConstructing()) {
								
								if(c->canBeConstructed(BWAPI::UnitTypes::Terran_Machine_Shop, factories.at((i)))) {
									
									Unit* worker = factories.at(i);
									
									bool w = worker->buildAddon(UnitTypes::Terran_Machine_Shop);
									if(w) {
										g->setMonitorTarget(worker);
										
										g->execute();
									}
								}
							}
						}

						} else {
							
						}
					}
				}
				break;

			case OFFENSE_GASSTEAL: 
				{
					
					
					std::pair<Unit*, Unit*> targetDetails = g->getTargetInformation();
					

					if(targetDetails.first != NULL) {
						Unit* reporter = targetDetails.first;
						Unit* target = targetDetails.second;
						if(reporter != NULL && target != NULL) {
							if(g->getCustomFlag() == false) {
								
								reporter->move(target->getPosition());
								g->setCustomFlag(true);
							} else {
								if(!reporter->isConstructing()) {
									if(reporter->getDistance(target) < reporter->getType().sightRange()/2) {
										if(c->canBeConstructed(UnitTypes::Terran_Refinery, reporter, target->getTilePosition()) && g->canExpendResources()) {
											if(c->buildStructure(UnitTypes::Terran_Refinery, target->getTilePosition(), reporter) != NULL) {
												g->execute();
											}
										}
									}
								} else {
									reporter->move(target->getPosition());
								}
							}
						}
					}

				}
				break;
			case OFFENSE_SCANPOI: 
				{
					
					if(im->canPerformScannerSweep(eim)) {
						
						im->scanPointsOfInterest(eim);
						g->execute();
					}

				}
				break;
			case OFFENSE_LANDATTACK: 
				{
					SquadReccomender* sqr = agentPool->getSquadReccomender();
					SquadTacticsModel* sq = s->recruitSquad(sqr->reccomendGroundSquad()); 
					if(sq != NULL) {
						
						mp->advanceProductionProcess();
						
						g->setMonitorTarget(sq);
						g->execute();
						s->activateSquad(sq);
						
						
					} else {
						
					}
				}
				break;

			}
		}
	}
}
}