#include "DummyGroup.h"
#include "Squad.h"
#include "AgentPool.h"
#include "MicroTacticsModel.h"
#include "WraithHunterKillerTactics.h"

DummyGroup::DummyGroup(Squad* m, AgentPool* p) {
	dead = false;
	element = m;
	agentPool = p;
	for(unsigned int i = 0; i < element->getUnits().size(); i++) {
		assignUnit(element->getUnitAt(i));
	}
	m->attachTacticsImplementation(this);
}

void DummyGroup::assignUnit(Unit* u) {

}


void DummyGroup::receiveAlert(Unit* t) {
	assignUnit(t);
}

std::vector<MicroTacticsModel*> DummyGroup::getSubTeam(UnitType t) {
	std::vector<MicroTacticsModel*> subSquad;
	for(unsigned int i = 0; i < unitTactics.size(); i++) {
		MicroTacticsModel* u = unitTactics.at(i);
		if(u->getUnit()->getType() == t) {
			subSquad.push_back(u);
		}	
	}
	return subSquad;
}

bool DummyGroup::execute() {
	
	return true;
}

void DummyGroup::removeUnit( Unit* u )
{

}
