#ifndef DROPSHIPMICROTACTICS_H
#define DROPSHIPMICROTACTICS_H
#include "MicroTacticsModel.h"
#include "UnitModel.h"
#include "DropShipAerialSquadron.h"
#include "InformationManagerAgent.h"
#include "TacticsImplementations.h"
#include "CrawlingBallAttack.h"
#include "Squad.h"
#include "BWAPI.h"

using namespace BWAPI;

class DropShipMicroTactics : public MicroTacticsModel {

public:
	DropShipMicroTactics::DropShipMicroTactics(Unit* u);
	DropShipMicroTactics::DropShipMicroTactics(Unit* u, DropShipAerialSquadron* p, InformationManagerAgent* a);
	DropShipMicroTactics::DropShipMicroTactics(Unit* u, int movementLag);
	virtual bool MicroTacticsModel::executeTactics();
	virtual Unit* getUnit();
	virtual void setMovementLag(int l);
	void DropShipMicroTactics::requestJob(CrawlingBallAttack* movementTarget, std::vector<Unit*> cargo);
	void setTarget(CrawlingBallAttack* p);
	void clearTarget();
	void declareTarget();
	virtual void move(Position p);
	void attachIntelligenceModule(InformationManagerAgent* a);
	void setDesiredCargo(std::vector<Unit*> units);
	bool isNotBusy();
		virtual UnitType getKnownType();
		Position findDropLocation(Position p);
private:
	Unit* element;
	Unit* squadTarget;
	Unit* myTarget;
	int myTargetFitness;
	Position nextPoint;
	DropShipAerialSquadron* parent;
	TargetFitnessCalculator* fitnessCalculator;
	Position targetLoc;
	int initialMovementLag;
	int movementLagTimer;
	Unit* followTarget;
	InformationManagerAgent* intelligenceModule;
	bool repairMode;
	bool pickupMode;
	bool dropOffMode;
	bool returnMode;
	bool unloading;
	//Position currentTarget;
	std::vector<Unit*> cargoManifest;
		UnitType knownType;
		TacticsImplementation* tacticsTarget;
		CrawlingBallAttack* movementTarget;


};


#endif