#include "DropShipMicroTactics.h"
#include <cmath>
#include <ctime> 
#include "CrawlingBallAttack.h"
#include "SquadManagerAgent.h"

DropShipMicroTactics::DropShipMicroTactics(Unit* u) {
	element = u;
	squadTarget = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	movementLagTimer = 0;
	initialMovementLag = 0;
	followTarget = NULL;
	myTarget = NULL;
	myTargetFitness = 0;
	repairMode = false;
	//currentTarget = Position(-1,-1);
	repairMode = false;
	pickupMode = false;
	dropOffMode = false;
	returnMode = false;
	unloading = false;
	knownType = u->getType();
	movementTarget = NULL;
}



DropShipMicroTactics::DropShipMicroTactics(Unit* u, DropShipAerialSquadron* p, InformationManagerAgent* a) {
	element = u;
	intelligenceModule = a;
	squadTarget = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	movementLagTimer = 0;
	initialMovementLag = 0;
	followTarget = NULL;
	myTarget = NULL;
	parent = p;
	myTargetFitness = 0;
	repairMode = false;
	//currentTarget = Position(-1,-1);
	repairMode = false;
	pickupMode = false;
	dropOffMode = false;
	returnMode = false;
	unloading = false;
		knownType = u->getType();
			movementTarget = NULL;
}

UnitType DropShipMicroTactics::getKnownType() {
	return knownType;
}


DropShipMicroTactics::DropShipMicroTactics(Unit* u, int movementLag) {
	element = u;
	squadTarget = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	movementLagTimer = movementLag;
	initialMovementLag = movementLag;
	followTarget = NULL;
	myTarget = NULL;
	myTargetFitness = false;
	repairMode = false;
	pickupMode = false;
	dropOffMode = false;
	returnMode = false;
	unloading = false;
	movementTarget = NULL;
}


void DropShipMicroTactics::setMovementLag(int l) {
	initialMovementLag = l;
}

void DropShipMicroTactics::declareTarget() {
	//parent->receiveTarget(myTarget->getUnit(), myTargetFitness);
}

void DropShipMicroTactics::move(Position p) {

	// INSTEAD of moving to p, move to the best location you can see from here to p
	int initPopSize = 64;
	int initPopVariance = 128;
	std::vector<Position> population;
	std::vector<Position> solution;

	// generate population
	for(int i = 0; i < initPopSize; i++) {
		Position newPosition = p;
		int newX = rand()%initPopVariance;
		int newY = rand()%initPopVariance;
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;
		newPosition = Position(p.x()+newX, p.y()+newY);
		population.push_back(newPosition);
	}
		std::set<Unit*> stuffInRange = element->getUnitsInRadius(element->getType().sightRange());

	// find the best member
	Position bestPosition = population.at(0);
	int bestFitness = 900000;
	for(int i = 0; i < initPopSize; i++) {
		Position n = population.at(i);
		int threatAtPoint = 0;
		for (std::set<BWAPI::Unit*>::const_iterator it = stuffInRange.begin(); it != stuffInRange.end(); ++it){
				Unit* target = *it;
				if(target->getPlayer() != Broodwar->self() && !target->getType().isNeutral()) {
					if(target->isInWeaponRange(element)) {
					if(target->getType().canAttack() && target->getType().airWeapon() != WeaponTypes::None)
					threatAtPoint = threatAtPoint + 15;
					}
				}
		}
		int fitness = n.getApproxDistance(p)+threatAtPoint;

		if((fitness < bestFitness)) {
			bestFitness = fitness;
		}
	}



	element->move(bestPosition);
}

void DropShipMicroTactics::setTarget(CrawlingBallAttack* p) {
	movementTarget = p;
}

void DropShipMicroTactics::requestJob(CrawlingBallAttack* movementTarget, std::vector<Unit*> cargo) {
	setTarget(movementTarget);
	setDesiredCargo(cargo);
	pickupMode = true;
}

void DropShipMicroTactics::setDesiredCargo(std::vector<Unit*> units) {
	cargoManifest = units;
}


void DropShipMicroTactics::clearTarget() {
	squadTarget = NULL;
}

bool DropShipMicroTactics::isNotBusy() {
	return (pickupMode == false && dropOffMode == false && returnMode == false && unloading == false);
}

bool DropShipMicroTactics::executeTactics() {
	if(!element->isCompleted()) {
		return true;
	}
	if(movementTarget != NULL) {
	if(!movementTarget->isAlive()) {
		//////Broodwar->sendText("TIME TO BAIL!");
		if(!element->isMoving() && !unloading) {
			move((Position)Broodwar->self()->getStartLocation());
		}
		if(element->getDistance((Position)Broodwar->self()->getStartLocation()) < 200 && !unloading) {
			unloading = true;
			element->stop();
		}
		if(unloading && element->getLoadedUnits().size() > 0) {
			if(element->getOrder() != Orders::Unload && element->getOrder() != Orders::MoveUnload) {
					element->unloadAll(findDropLocation(element->getPosition()));
					SquadManagerAgent* sm = (SquadManagerAgent*)intelligenceModule->agentPool->getAgent("SQ");

					for(unsigned int k = 0; k < cargoManifest.size(); k++) {
						sm->getActiveSquad(9000)->getSquad()->removeUnit(cargoManifest.at(k));
					}
			}
		}
		if(unloading && element->getLoadedUnits().empty()) {
			repairMode = false;
			pickupMode = false;
			dropOffMode = false;
			returnMode = false;
			unloading = false;
			movementTarget = NULL;
		}

		return true;
	}
	}
	if(element->getHitPoints() <= element->getType().maxHitPoints()*0.4 && !repairMode) {
		move(intelligenceModule->findHighestConcentrationOf(UnitTypes::Terran_SCV));
		repairMode = true;
		return true;
	}

	if(repairMode) {
		if(element->getHitPoints() == element->getType().maxHitPoints()) {
			repairMode = false;
		}
	}

	if(returnMode) {
		//////Broodwar->sendText("return mode");
	if(element->getDistance((Position)Broodwar->self()->getStartLocation()) < 500) {
		repairMode = false;
		pickupMode = false;
		dropOffMode = false;
		returnMode = false;
		unloading = false;
		movementTarget = NULL;
	}

	if(!element->isMoving()) {
		move((Position)Broodwar->self()->getStartLocation());
	}
	}

	if(movementTarget != NULL) {
		if(dropOffMode && !returnMode && !pickupMode) {
			//////Broodwar->sendText("drop off mode");
			////////Broodwar->sendText("drop off mode");
			if(!element->isMoving() && !unloading) {
				move(movementTarget->getSquad()->getMostCentralElement());
			}
			if(element->getDistance(movementTarget->getSquad()->getMostCentralElement()) < 200 && !unloading) {
				unloading = true;
				element->stop();
			}
			if(unloading && element->getLoadedUnits().size() > 0) {
				if(element->getOrder() != Orders::Unload && element->getOrder() != Orders::MoveUnload) {
						element->unloadAll(findDropLocation(element->getPosition()));
				}
			}
			if(unloading && element->getLoadedUnits().empty()) {
				unloading = false;
				dropOffMode = false;
				returnMode = true;
			}

			return true;
		}

		if(returnMode && !dropOffMode && !pickupMode) {
				//////////Broodwar->sendText("return mode");
				if(!cargoManifest.empty() && movementTarget != NULL) {
					////////Broodwar->sendText("attaching tactics");
					SquadManagerAgent* sm = (SquadManagerAgent*)intelligenceModule->agentPool->getAgent("SQ");
						
					for(unsigned int k = 0; k < cargoManifest.size(); k++) {
						//////Broodwar->sendText(movementTarget->getSquad()->name().c_str());
						movementTarget->receiveAlert(cargoManifest.at(k));
						movementTarget->eraseDead();
						sm->getActiveSquad(9000)->getSquad()->removeUnit(cargoManifest.at(k));
					}
			//	////////Broodwar->sendText("done!");
				cargoManifest.clear();
				movementTarget = NULL;
				unloading = false;
				}
			return true;
		}

		if(pickupMode && !returnMode && !dropOffMode) {
			//////Broodwar->sendText("pick up mode");
			////////Broodwar->sendText("pick up mode");
			if(!cargoManifest.empty()) {
				std::set<Unit*> currentCargo = element->getLoadedUnits();
			
					for(unsigned int k = 0; k < cargoManifest.size(); k++) {
							Broodwar->drawCircle(CoordinateType::Map, cargoManifest.at(k)->getPosition().x(), cargoManifest.at(k)->getPosition().y(), 16, Colors::Green, true);
							if(!element->isMoving() && !cargoManifest.at(k)->isMoving() && !cargoManifest.at(k)->isLoaded()) {
								element->load(cargoManifest.at(k));
								cargoManifest.at(k)->rightClick(element);
								break;
							}
					}
					int numMatched = 0;
					for(std::set<Unit*>::const_iterator i = currentCargo.begin(); i != currentCargo.end(); i++) {
						for(unsigned int k = 0; k < cargoManifest.size(); k++) {
							if((*i)->getID() == cargoManifest.at(k)->getID()) {
								numMatched++;
							}
						}
					}
					

				//	////////Broodwar->sendText("i need: %d", cargoManifest.size());
					//////////Broodwar->sendText("i have: %d", numMatched);

					if(numMatched == cargoManifest.size()) {
						pickupMode = false;
						dropOffMode = true;
					}
				
			return true;
			} else {
				//////Broodwar->sendText("somethingis wrong");
			}
			
		}
	}
	return false;
}

Unit* DropShipMicroTactics::getUnit() {
	return element;
}

void DropShipMicroTactics::attachIntelligenceModule(InformationManagerAgent* a) {
	intelligenceModule = a;
}


Position DropShipMicroTactics::findDropLocation(Position p) {
	int initPopSize = 256;
	int initPopVariance = 64;
	std::vector<Position> population;
	std::vector<Position> solution;

	for(int i = 0; i < initPopSize; i++) {
		Position newPosition = p;
		int newX = rand()%initPopVariance;
		int newY = rand()%initPopVariance;
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;
		newPosition = Position(p.x()+newX, p.y()+newY);
		population.push_back(newPosition);
	}

	// find the best member
	Position bestPosition = population.at(0);
	for(int i = 0; i < initPopSize; i++) {
		Position n = population.at(i);
		if((Broodwar->getUnitsInRadius(n,64).empty() && Broodwar->isWalkable((((TilePosition)n).x())*4,(((TilePosition)n).y())*4))) {
			bestPosition = n;
		}
	}

	return bestPosition;
}