#include "DropShipAerialSquadron.h"
#include "Squad.h"
#include "AgentPool.h"
#include "MicroTacticsModel.h"
#include "DropShipMicroTactics.h"
#include "SquadManagerAgent.h"

DropShipAerialSquadron::DropShipAerialSquadron(Squad* m, AgentPool* p) {
	//////////agentPool->writeDebugMessage("initializing dropship squad");
	dead = false;
	element = m;
	agentPool = p;
	if(!element->getUnits().empty()) {
	for(unsigned int i = 0; i < element->getUnits().size(); i++) {
		assignUnit(element->getUnitAt(i));
	}
	}
	m->attachTacticsImplementation(this);
			//////////agentPool->writeDebugMessage("we know about...");
			//////////agentPool->writeDebugMessage((int)dropShipSet.size());
			//////////agentPool->writeDebugMessage("dropships");

	intelligenceModule = (InformationManagerAgent*)agentPool->getAgent("EI");
			//////////agentPool->writeDebugMessage("dropship squad initialized");
}

void DropShipAerialSquadron::assignUnit(Unit* u) {
	//////////agentPool->writeDebugMessage("candidate unit type: ");
	//////////agentPool->writeDebugMessage(u->getType().getName());
	if(u->getType() == BWAPI::UnitTypes::Terran_Dropship) {
		//////////agentPool->writeDebugMessage("we know about...");
		//////////agentPool->writeDebugMessage((int)dropShipSet.size());
		//////////agentPool->writeDebugMessage("dropships");
		//////////agentPool->writeDebugMessage("pushed back a new dropship model");
		dropShipSet.insert(new DropShipMicroTactics(u, this, (InformationManagerAgent*)agentPool->getAgent("EI")));
		//////////agentPool->writeDebugMessage("dobne!");
		////////Broodwar->sendText("dropship tactics attached");
		//////////agentPool->writeDebugMessage("we know about...");
		//////////agentPool->writeDebugMessage((int)dropShipSet.size());
		//////////agentPool->writeDebugMessage("dropships");
		////////Broodwar->sendText("i have %d dropships", dropShipSet.size());
	}	
}


void DropShipAerialSquadron::receiveAlert(Unit* t) {
	//////////agentPool->writeDebugMessage("new dropship model acquired!");
	assignUnit(t);
	//element->addUnit(t);
}

std::vector<MicroTacticsModel*> DropShipAerialSquadron::getSubTeam(UnitType t) {
	std::vector<MicroTacticsModel*> subSquad;
	//for(unsigned int i = 0; i < dropShipSet.size(); i++) {
	//	MicroTacticsModel* u = dropShipSet.at(i);
	//	if(u->getUnit()->getType() == t) {
	//		subSquad.push_back(u);
	//	}	
	//}
	return subSquad;
}

bool DropShipAerialSquadron::requestJob(CrawlingBallAttack* p, std::vector<Unit*> cargo) {
	//////////agentPool->writeDebugMessage("requesting dropship job");
	bool foundFreeDropShip = false;
	//////////agentPool->writeDebugMessage("we know about...");
	//////////agentPool->writeDebugMessage((int)dropShipSet.size());
	//////////agentPool->writeDebugMessage("dropships");
	if(dropShipSet.empty()){
			//////////agentPool->writeDebugMessage("empty?!");
		return false;
	}
	DropShipMicroTactics* targetDropShip = NULL;

	for(std::set<DropShipMicroTactics*>::const_iterator it = dropShipSet.begin(); it != dropShipSet.end(); it++) {
		//////////agentPool->writeDebugMessage("begin");
		DropShipMicroTactics* m = (*it);
		//////////agentPool->writeDebugMessage("ok");
		if(m != NULL) {
		if(m->getUnit()->isCompleted()) {
			//////////agentPool->writeDebugMessage("looking at a...");
			//////////agentPool->writeDebugMessage(m->getKnownType().getName().c_str());
			//////////agentPool->writeDebugMessage("considering a dropship");
			if(m->getUnit()->getHitPoints() > 0) {
			if(m->isNotBusy() == true) {
				foundFreeDropShip = true;
				targetDropShip = m;
				//////////agentPool->writeDebugMessage("found a free dropship");
				break;
			} else {
				//////////agentPool->writeDebugMessage("this guy is busy");
			}
			} else {
					//////////agentPool->writeDebugMessage("this guy is dead");
			}

		}
		} else {
			//////////agentPool->writeDebugMessage("what in the name of god");
		}
	}
	if(foundFreeDropShip) {
		//////////agentPool->writeDebugMessage("job requested");
		targetDropShip->requestJob(p,cargo);
		SquadManagerAgent* sm = (SquadManagerAgent*)agentPool->getAgent("SQ");
		for(unsigned int i = 0; i < cargo.size(); i++){
			sm->getActiveSquad(9000)->getSquad()->forceUnit(cargo.at(i));
			//if(cargo.at(i)->isLoaded()) {
			//	cargo.at(i)->getTransport()->unload(cargo.at(i));
			//}
			//targetDropShip->getUnit()->load(cargo.at(i));
		}
		//////////agentPool->writeDebugMessage("done!");
		return true;
	}
		//////////agentPool->writeDebugMessage("couldn't find anything to use!");
	return false;
}

bool DropShipAerialSquadron::execute() {
	// since this squad can have units that haven't yet finished training, we
	// need to ignore those
	//////////agentPool->writeDebugMessage("executing dropship squadron tactics");


	bool microTacticsExecuted = false;
	for(std::set<DropShipMicroTactics*>::const_iterator it = dropShipSet.begin(); it != dropShipSet.end(); it++) {
			//////////agentPool->writeDebugMessage("looking at a dropship");
		DropShipMicroTactics* m = (*it);

		// ignore units under construction 
		if(!m->getUnit()->isCompleted()) {
			//////////agentPool->writeDebugMessage("not finished");
			continue;
		}

		// firstly, if this guy is dead, get rid of him
		if(m->getUnit()->getHitPoints() <= 0) {
			//////////agentPool->writeDebugMessage("dead");
			continue;
		}
		//////////agentPool->writeDebugMessage("attempting to execute micro tactics");
		if(m->executeTactics() == true) {
			//////////agentPool->writeDebugMessage("executed micro tactics");
			microTacticsExecuted = true;
			continue;
		} else {
			//////////agentPool->writeDebugMessage("failed");
		}
	}


	return true;
}

void DropShipAerialSquadron::removeUnit( Unit* u )
{

}
