#ifndef CHOKEPOINTCRAWL_H
#define CHOKEPOINTCRAWL_H
#include "TacticsImplementations.h"
#include "ThreatAwarePathfinder.h"
#include "BWTA.h"
#include "SquadTacticsModel.h"
#include "UnitModel.h"

using namespace BWTA;

class CrawlingBallAttack : public TacticsImplementation {
public:
	CrawlingBallAttack(Squad* m, AgentPool* p, SquadTacticsModel* sm);
	virtual bool execute();
		virtual std::vector<MicroTacticsModel*> getSubTeam(UnitType t);
		virtual void receiveAlert(Unit* t);
		virtual void assignUnit(Unit* u);
		virtual void removeUnit(Unit* u);
		Squad* getSquad();
		void eraseDead();
		bool isAlive();
		void calculateNextTarget();
		std::vector<TilePosition> bubble_sort(std::vector<TilePosition> input);
		std::vector<MicroTacticsModel*> getDeadUnits(UnitType t);std::string test;
		void calcPoint(TilePosition t);
		TilePosition evalPoints(std::vector<TilePosition> f);
			
private:
	std::vector<MicroTacticsModel*> unitTactics;
	std::vector<TilePosition> path;
	AgentPool* agentPool;
	Squad* element;
	Position goal;
	TilePosition subgoal;
	BWTA::Region* targetRegion;
	UnitModel* targetUnit;
	bool atChokePoint;
	bool dead;
	MicroTacticsModel* pointMarine;
	int wait;
	int stepSize;
	ThreatAwarePathFinder* pf;
	SquadTacticsModel* tacticsModel;
	std::map<Unit*,Position> assignments;
	std::map<Unit*,int> teleporterClicks;
	std::map<Unit*,Unit*> teleporterAssignments;
	std::vector<UnitModel*> attackList;
	std::vector<TilePosition> v;
	unsigned int cur;
	bool atGoal;
	int initialsize;
	int movementTimer;
	bool teleportersOnMap;
	bool finished;
};

#endif