#include "CrawlingBallAttack.h"
#include "Squad.h"
#include "AgentPool.h"
#include "MicroTacticsModel.h"
#include "SiegeTankMicroTactics.h"
#include "CombatSCVMicroTactics.h"
#include "ScienceVesselMicroTactics.h"
#include "SquadManagerAgent.h"
#include "WraithAerialSquadron.h"
#include "VultureMicroTactics.h"


CrawlingBallAttack::CrawlingBallAttack(Squad* m, AgentPool* p, SquadTacticsModel* s) {
	dead = false;
	element = m;
	atGoal = false;
	atChokePoint = false;
	finished = false;
	pointMarine = NULL;
	targetUnit = NULL;
	wait = 15;
	stepSize = 25;
	cur = 0;
	agentPool = p;
	movementTimer = 0;
	tacticsModel = s;
	for(unsigned int i = 0; i < element->getUnits().size(); i++) {
		assignUnit(element->getUnits().at(i));	
	}
	InformationManagerAgent* pim = (InformationManagerAgent*)(agentPool->getAgent("PI")) ;
	InformationManagerAgent* im = (InformationManagerAgent*)(agentPool->getAgent("EI")) ;
	if(!im->getKnownBuildings().empty()) {
		goal = im->getKnownBuildings().at(0)->getLastKnownPosition();
	}
	calculateNextTarget();
	initialsize = unitTactics.size();

}


void CrawlingBallAttack::calculateNextTarget() {
	v.clear();
	atGoal = false;
	InformationManagerAgent* eim = (InformationManagerAgent*)agentPool->getAgent("EI");
	TilePosition target = eim->locateWeakestPerceivedBase();

	if(target.x() == 0 && target.y() == 0) {
		finished = true;
		return;
	}

	TilePosition start;
	int ax = 0;
	int ay = 0;
	int units = 0;
	for(int i = 0; i < unitTactics.size(); i++) {
		if(unitTactics.at(i)->getUnit()->getHitPoints() > 0){
			ax += unitTactics.at(i)->getUnit()->getTilePosition().x();
			ay += unitTactics.at(i)->getUnit()->getTilePosition().y();
			units++;
		}
	}
	if(units != 0) {
		ax /= units;
		ay /= units;
	}
	start = TilePosition(ax,ay);
	while(!Broodwar->isBuildable(start)) {
		int newX = rand()%6;
		int newY = rand()%6;
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;
		TilePosition tf = TilePosition(start.x()+newX, start.y()+newY);
		if(Broodwar->isWalkable(tf.x()*4, tf.y()*4)) {
			start = tf;
		}
	}

	/// now figure out how to get there!
	std::set<TilePosition> endPoints;
	for(int i = 0; i < 16; i++) {
		int newX = rand()%6;
		int newY = rand()%6;
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;
		TilePosition tf = TilePosition(target.x()+newX, target.y()+newY);
		if(Broodwar->isWalkable(tf.x()*4, tf.y()*4)) {
			endPoints.insert(tf);
		}
	}

	//v = BWTA::getShortestPath((TilePosition)Broodwar->self()->getStartLocation(), TilePosition(Broodwar->mapWidth()/2,Broodwar->mapHeight()/2));
	v = BWTA::getShortestPath(start, endPoints);

	if(v.size() > 30) {
	for(unsigned int p = 0; p < 15; p++) {
			////agentPool->writeDebugMessage("path");
		v.erase(v.begin()+p);
	}	
	}
	////////////agentPool->writeDebugMessage("path after trim:");
	////////////agentPool->writeDebugMessage((int)v.size());
	int control = 0;
	if(v.size() > 10) {
	for(unsigned int l = 0; l < v.size(); l++) {
		if(control < 4) {
				////agentPool->writeDebugMessage("initial path point cull");
			v.erase(v.begin()+l);
			control++;
		} else {
			control = 0;
		}
	}
	}
	for(unsigned int m = 0; m < v.size(); m++) {
		if(!Broodwar->isBuildable(v.at(m)), true) {
				////agentPool->writeDebugMessage("buildable tile");
			v.erase(v.begin()+m);
		}
	}
	for(unsigned int n = 0; n < v.size(); n++) {
		TilePosition tp = v.at(n);
		// evaluate the neighbours of this guy
		int initPopSize = 32;
		int initPopVariance = 3;
		std::vector<TilePosition> mutations;
		for(int i = 0; i < initPopSize; i++) {
			int newX = rand()%initPopVariance;
			int newY = rand()%initPopVariance;
			if(rand()%100 >= 50) newX = -newX;
			if(rand()%100 >= 50) newY = -newY;
			TilePosition tf = TilePosition(tp.x()+newX, tp.y()+newY);
			//if(Broodwar->isBuildable(tf)) {
			mutations.push_back(tf);
			//}
		}

		int rootScore = 0;
		TilePosition left = TilePosition(tp.x()-1,tp.y());
		TilePosition right = TilePosition(tp.x()+1,tp.y());
		TilePosition up = TilePosition(tp.x(),tp.y()-1);
		TilePosition down = TilePosition(tp.x(),tp.y()+1);
		if(Broodwar->isBuildable(left)) {
			rootScore++;
		}
		if(Broodwar->isBuildable(right)) {
			rootScore++;
		}
		if(Broodwar->isBuildable(up)) {
			rootScore++;
		}
		if(Broodwar->isBuildable(down)) {
			rootScore++;
		}


		int bestScore = 0;
		TilePosition best = tp;
		for(unsigned int k = 0; k < mutations.size(); k++) {
			TilePosition ktp = mutations.at(k);
			TilePosition left = TilePosition(ktp.x()-1,ktp.y());
			TilePosition right = TilePosition(ktp.x()+1,ktp.y());
			TilePosition up = TilePosition(ktp.x(),ktp.y()-1);
			TilePosition down = TilePosition(ktp.x(),ktp.y()+1);
			int score = 0;
			if(Broodwar->isBuildable(left)) {
				score++;
			}
			if(Broodwar->isBuildable(right)) {
				score++;
			}
			if(Broodwar->isBuildable(up)) {
				score++;
			}
			if(Broodwar->isBuildable(down)) {
				score++;
			}
			if(score > bestScore) {
				bestScore = score;
				best = mutations.at(k);
			} else {
					////agentPool->writeDebugMessage("mutation");
				mutations.erase(mutations.begin()+k);
			}
		}
		if(bestScore > rootScore) {
			v.at(n) = best;
		}
	}
	cur = 0;
	subgoal = v.at(cur);
	calcPoint(subgoal);
}

Squad* CrawlingBallAttack::getSquad() {
	return element;
}

std::vector<MicroTacticsModel*> CrawlingBallAttack::getSubTeam(UnitType t) {
	std::vector<MicroTacticsModel*> subSquad;
	for(unsigned int i = 0; i < unitTactics.size(); i++) {
		MicroTacticsModel* u = unitTactics.at(i);
		if(u->getUnit()->getHitPoints() > 0) {
			//firstly, if we're looking for tanks, just pick any tank regardles of its state
			if(t = UnitTypes::Terran_Siege_Tank_Siege_Mode || UnitTypes::Terran_Siege_Tank_Tank_Mode) {
				if(u->getUnit()->getOrder() == Orders::Sieging || u->getUnit()->getType() == UnitTypes::Terran_Siege_Tank_Siege_Mode || u->getUnit()->getType() == UnitTypes::Terran_Siege_Tank_Tank_Mode) {
					subSquad.push_back(u);
					continue;
				}	
			}
			if(u->getUnit()->getType() == t) {
				subSquad.push_back(u);
			}	
		}


	}
	return subSquad;
}

void CrawlingBallAttack::assignUnit(Unit* u) {
	//////////////////agentPool->writeDebugMessage("assigning a new unit");
	if(u->getType() == BWAPI::UnitTypes::Terran_Marine) {
		unitTactics.push_back(new MarineMicroTactics(u, this));
	}
	if(u->getType() == BWAPI::UnitTypes::Terran_Goliath) {
		unitTactics.push_back(new MarineMicroTactics(u, this));
	}
	if(u->getType() == BWAPI::UnitTypes::Terran_Firebat) {
		unitTactics.push_back(new MarineMicroTactics(u, this));
	}
	if(u->getType() == BWAPI::UnitTypes::Terran_Medic) {
		unitTactics.push_back(new MedicMicroTactics(u, this));
	}	
	if(u->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode) {
		unitTactics.push_back(new SiegeTankMicroTactics(u, this));
	}	
	if(u->getType() == BWAPI::UnitTypes::Terran_Science_Vessel) {
		unitTactics.push_back(new ScienceVesselMicroTactics(u, (InformationManagerAgent*)(agentPool->getAgent("PI"))));
	}	
	if(u->getType() == BWAPI::UnitTypes::Terran_SCV) {
		unitTactics.push_back(new CombatSCVMicroTactics(u, agentPool, this));
	}	
	if(u->getType() == BWAPI::UnitTypes::Terran_Vulture) {
		unitTactics.push_back(new VultureMicroTactics(u, this));
	}	
	if(u->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode) {
		unitTactics.push_back(new SiegeTankMicroTactics(u, this));
		if(u->isSieged()) {
			u->unsiege();
		}
	}
}

void CrawlingBallAttack::receiveAlert(Unit* t) {
	assignUnit(t);
	element->forceUnit(t);
}

std::vector<MicroTacticsModel*> CrawlingBallAttack::getDeadUnits(UnitType t) {
	std::vector<MicroTacticsModel*> dead;
	for(unsigned int i = 0; i < unitTactics.size(); i++) {
		MicroTacticsModel* m = unitTactics.at(i);
		if(m->getUnit()->getHitPoints() <= 0) {
			if(m->getKnownType() == t) {
				dead.push_back(m);
			}
		}
	}
	return dead;
}

void CrawlingBallAttack::eraseDead() {
	for(unsigned int i = 0; i < unitTactics.size(); i++) {
		MicroTacticsModel* m = unitTactics.at(i);
		if(m->getUnit()->getHitPoints() <= 0) {
			//element->removeUnit(unitTactics.at(i)->getUnit());
				////agentPool->writeDebugMessage("erasing dead");
			unitTactics.erase(unitTactics.begin()+i);
			break;
		}
	}


}

bool CrawlingBallAttack::execute() {
			//////agentPool->writeDebugMessage("CPC.");
	for(std::vector<TilePosition>::const_iterator i = v.begin(); i != v.end(); i++) {
		TilePosition q = (*i);
		Broodwar->drawBox(CoordinateType::Map,q.x()*32,q.y()*32,q.x()*32+4*8,q.y()*32+2*8,Colors::Green,true);
	}


		Broodwar->drawBox(CoordinateType::Map,v.at(v.size()-1).x()*32,v.at(v.size()-1).y()*32,v.at(v.size()-1).x()*32+8*8,v.at(v.size()-1).y()*32+4*8,Colors::Red,true);


	if(!isAlive()) {
		//////agentPool->writeDebugMessage("releasing the squad");
		///for(unsigned int i = 0; i < unitTactics.size(); i++) {
			//MicroTacticsModel* m = unitTactics.at(i);
			//if(m->getUnit()->getHitPoints() <= 0) {
			////////agentPool->writeDebugMessage("removing a...");
			////////agentPool->writeDebugMessage(m->getKnownType().getName().c_str());
			//	element->removeUnit(unitTactics.at(i)->getUnit());
			//	unitTactics.erase(unitTactics.begin()+i);
			//}
		//	m->getUnit()->move((Position)Broodwar->self()->getStartLocation());
		//}	
		//element->getUnits().clear();
		//unitTactics.clear();
		return true;
	}



	int deadUnits = 0;
	int aliveUnits = 0;
	for(unsigned int i = 0; i < unitTactics.size(); i++) {
		MicroTacticsModel* m = unitTactics.at(i);

		if(m->getUnit()->getHitPoints() <= 0) {
			//////////////agentPool->writeDebugMessage("got a dead guy");
			deadUnits++;
			//element->removeUnit(unitTactics.at(i)->getUnit());
			//unitTactics.erase(unitTactics.begin()+i);
		} else {
			aliveUnits++;
		}
	}

	if(deadUnits == unitTactics.size()) {
		dead = true;
		////////Broodwar->sendText("squad wiped out");
		//////////////////agentPool->writeDebugMessage("squad is dead");
		return false;
	}
	////////////agentPool->writeDebugMessage("looking for dead guys...");
	////////////agentPool->writeDebugMessage("registered");
	////////////agentPool->writeDebugMessage((int)deadUnits);
	////////////agentPool->writeDebugMessage("of");
	////////////agentPool->writeDebugMessage((int)unitTactics.size());
	if(deadUnits > 3) {
		////////////agentPool->writeDebugMessage("registered");
		////////////agentPool->writeDebugMessage((int)deadUnits);
		////////////agentPool->writeDebugMessage("dead units");
		tacticsModel->orderReinforcements();
	}
	////////////agentPool->writeDebugMessage("squad is alive");
	std::vector<int> toBeErased;
	bool microTacticsExecuted = false;
	bool unitDead = false;



	int numAtPoint = 0;
	for(unsigned int i = 0; i < unitTactics.size(); i++) {
		if(unitTactics.at(i)->getUnit()->getHitPoints() > 0) {
			int mod = 0;
			if(BWTA::getNearestChokepoint((Position)subgoal)->getCenter().getDistance((Position)subgoal) < 200) {
				mod = 100;
			}
			if(unitTactics.at(i)->getUnit()->getPosition().getDistance((Position)subgoal) < mod+130+(4*unitTactics.size())) {
				numAtPoint++;
			}
		}
	}

	if(numAtPoint >= aliveUnits*0.7 && !atGoal) {
		cur++;
		if(cur < v.size()) {
			subgoal = v.at(cur);
		}
		calcPoint(subgoal);
		if(cur >= v.size()){
			atGoal = true;
		}
	} else {
		if(movementTimer > 0){
			movementTimer--;
		} else {
			////Broodwar->sendText("stuck");

			movementTimer = 1500;
		}
	}
	if(Broodwar->getFrameCount()%256==0) {
		InformationManagerAgent* eim = (InformationManagerAgent*)agentPool->getAgent("EI");
		attackList.clear();
		//std::set<Unit*> perceivedUnits = Broodwar->getUnitsInRadius((Position)subgoal, 800);
		std::vector<UnitModel*> perceivedUnits = eim->getKnownBuildingsAroundPoint((Position)v.at(v.size()-1), 1500);

	for(std::vector<UnitModel*>::const_iterator i = perceivedUnits.begin(); i!= perceivedUnits.end();i++) {
			if((*i)->isAlive()) {
					attackList.push_back((*i));
			}
		}
	//agentPool->writeDebugMessage("attack list size: ");
	//agentPool->writeDebugMessage((int)attackList.size());

	}

	//for(int i = 0; i < attackList.size(); i++) {
	//	Broodwar->drawCircle(CoordinateType::Map, attackList.at(i)->getLastKnownPosition().x(), attackList.at(i)->getLastKnownPosition().y(), 32, Colors::Blue);
	//}


	if(atGoal == true) {
		
	//	//Broodwar->sendText("razed buildings: %d", rb.size());
		if(attackList.empty()) {
			finished = true;
	for(unsigned int i = 0; i < unitTactics.size(); i++) {
		MicroTacticsModel* m = unitTactics.at(i);
		m->getUnit()->attack(agentPool->getCurrentPrimaryBase());
			}
		}
	}
	if(finished){
		return false;
	}



	for(unsigned int i = 0; i < unitTactics.size(); i++) {
		MicroTacticsModel* m = unitTactics.at(i);
	//	Position c = element->getMostCentralElement(m->getUnit());
		//Broodwar->drawCircle(CoordinateType::Map, c.x(), c.y(), 16, Colors::Green, true);
		// firstly, if this guy is dead, get rid of him
		if(m->getUnit()->getHitPoints() <= 0) {
			continue;
		}


		if(m->executeTactics() == true) {
			// if the micro tactic did something, we're cool
			//agentPool->writeDebugMessage("micro tactics executed!");
			microTacticsExecuted = true;
			continue;
		} else {
			if(Broodwar->getFrameCount()%16==0) { // was 32
				//////agentPool->writeDebugMessage("macro tactics!");
				if(!atGoal){
					if(m->getUnit()->getType() != UnitTypes::Terran_Science_Vessel) { 
					m->getUnit()->attack(assignments[m->getUnit()]);
					} else {
						m->getUnit()->move(element->getMostCentralElement());
					}
				} else {
					if(!attackList.empty()) {
						for(int i = 0; i < attackList.size(); i++) {
							if(attackList.at(i)->getUnit()->isVisible()) {
								m->getUnit()->move(attackList.at(i)->getLastKnownPosition());
								break;
							}
						}
					
						TilePosition newPosition = m->getUnit()->getTilePosition(); 
							int newX = rand()%6;
							int newY = rand()%6;
							if(rand()%100 >= 50) newX = -newX;
							if(rand()%100 >= 50) newY = -newY;
							newPosition = TilePosition(newPosition.x()+newX, newPosition.y()+newY).makeValid();
							m->getUnit()->attack((Position)newPosition);


						
					}

				} 



			}
	



		}

	}
	if(Broodwar->getFrameCount()%8==0)	{
		// wake up units that might be hanging around doing nothing while others
		// are engaged in combat
		Unit* wakeUpTarget = NULL;
		std::set<Unit*> squadPerception;
		////////agentPool->writeDebugMessage("looking...");
		for(unsigned int i = 0; i < unitTactics.size(); i++) {
			MicroTacticsModel* m = unitTactics.at(i);
			if(m->getUnit()->getHitPoints() > 0){
				std::set<Unit*> p = m->getUnit()->getUnitsInRadius(m->getUnit()->getType().sightRange());
				if(!p.empty()) {
					squadPerception.insert(p.begin(),p.end());
				}
				if(m->getUnit()->getOrderTarget() != NULL && (m->getUnit()->isAttacking() || m->getUnit()->isUnderAttack()) && wakeUpTarget == NULL  && m->getUnit()->getType() != UnitTypes::Terran_Medic ) {
					if(m->getUnit()->isUnderAttack() && !m->getUnit()->isAttacking()) { //medics
						wakeUpTarget = m->getUnit();
					} else {
						wakeUpTarget = m->getUnit()->getOrderTarget();
					}
					break;
				}
			}
		}

		for(unsigned int i = 0; i < unitTactics.size(); i++) {
			MicroTacticsModel* m = unitTactics.at(i);
			if(m->getUnit()->getHitPoints() > 0){
				if(wakeUpTarget != NULL && m->getUnit()->getType() != UnitTypes::Terran_Medic && m->getUnit()->getOrderTarget() == NULL) {
					////Broodwar->sendText("assisting...");
					if(wakeUpTarget->getOrderTarget() == NULL || wakeUpTarget->getOrderTarget()->getPlayer() == Broodwar->self()){
						m->getUnit()->attack(wakeUpTarget);
						wakeUpTarget->move(m->getUnit()->getPosition());
					} else {
						m->getUnit()->rightClick(wakeUpTarget);
					}
					

				}
			}
		}

			if(Broodwar->getFrameCount()%16==0)	{
				////////agentPool->writeDebugMessage("vongolmerating epereception");
				// broadcast requests for air support if we see any good targets
				std::vector<Unit*> bestTargets;
				for(std::set<Unit*>::const_iterator n = squadPerception.begin(); n != squadPerception.end(); n++) {
					Unit* cur = *n;
					if(cur->getPlayer() != Broodwar->self() && !cur->getType().isNeutral()) {

						// so what are we interested in?
						if(cur->getType() == UnitTypes::Terran_Siege_Tank_Siege_Mode || cur->getType() == UnitTypes::Terran_Siege_Tank_Tank_Mode) {
							bestTargets.push_back(cur);
						}

						if(cur->getType() == UnitTypes::Zerg_Sunken_Colony) {
							bestTargets.push_back(cur);
						}

						if(cur->getType() == UnitTypes::Terran_Refinery) {
							bestTargets.push_back(cur);
						}
						if(cur->getType() == UnitTypes::Protoss_Assimilator) {
							bestTargets.push_back(cur);
						}
						if(cur->getType() == UnitTypes::Zerg_Extractor) {
							bestTargets.push_back(cur);
						}
						if(cur->getType() == UnitTypes::Zerg_Ultralisk) {
							bestTargets.push_back(cur);
						}

						if(cur->getType() == UnitTypes::Protoss_Arbiter) {
							bestTargets.push_back(cur);
						}
						if(cur->getType() == UnitTypes::Protoss_Carrier) {
							bestTargets.push_back(cur);
						}			
						if(cur->getType() == UnitTypes::Protoss_Corsair) {
							bestTargets.push_back(cur);
						}	
						if(cur->getType() == UnitTypes::Protoss_Reaver) {
							bestTargets.push_back(cur);
						}		
						if(cur->getType() == UnitTypes::Protoss_High_Templar) {
							bestTargets.push_back(cur);
						}

						if(cur->getType() == UnitTypes::Zerg_Guardian) {
							bestTargets.push_back(cur);
						}

						if(cur->getType() == UnitTypes::Zerg_Mutalisk) {
							bestTargets.push_back(cur);
						}

						if(cur->getType() == UnitTypes::Zerg_Overlord) {
							bestTargets.push_back(cur);
						}

						if(cur->getType() == UnitTypes::Protoss_Zealot) {
							bestTargets.push_back(cur);
						}

						if(cur->getType() == UnitTypes::Protoss_Dark_Templar) {
							bestTargets.push_back(cur);
						}

					}
				}

				if(!bestTargets.empty()) {
					////////agentPool->writeDebugMessage("getting sqm");
					SquadManagerAgent* sq = (SquadManagerAgent*)agentPool->getAgent("SQ");
					////////agentPool->writeDebugMessage("getting wraiths");
					WraithAerialSquadron* ws = (WraithAerialSquadron*)sq->getActiveSquad(1)->getSquad()->getTacticsImplementation();
					////////agentPool->writeDebugMessage("getting fitness calt");
					TargetFitnessCalculator* tf = new TargetFitnessCalculator();
					////////agentPool->writeDebugMessage("iterating...");
					for(unsigned int k = 0; k < bestTargets.size(); k++) {
						////////agentPool->writeDebugMessage("sending target: ");
						////////agentPool->writeDebugMessage(bestTargets.at(k)->getType().getName());

						ws->receiveTarget(bestTargets.at(k), tf->calculateAirFitness(bestTargets.at(k)));
					}


				}
			}
		}

		return true;
	}

	bool CrawlingBallAttack::isAlive() {
		int alive = 0;
		if(unitTactics.empty() || finished) return false;
		for(unsigned int i = 0; i < unitTactics.size(); i++) {
			MicroTacticsModel* m = unitTactics.at(i);
			if(m->getUnit()->getHitPoints() > 0 && (m->getKnownType() == UnitTypes::Terran_Siege_Tank_Siege_Mode || m->getKnownType() == UnitTypes::Terran_Siege_Tank_Tank_Mode || m->getKnownType() == UnitTypes::Terran_Marine || m->getKnownType() == UnitTypes::Terran_Goliath || m->getKnownType() == UnitTypes::Terran_Firebat|| m->getKnownType() == UnitTypes::Terran_Vulture || m->getKnownType() == UnitTypes::Terran_Battlecruiser)) {
				alive++;
			}
		}
		////////agentPool->writeDebugMessage("seeing if its alive");
		if(initialsize > 1) {
			//	//////agentPool->writeDebugMessage("ooooh");
			return alive > 3;
		} else {
			//	//////agentPool->writeDebugMessage("saaah");
			return alive > 0;
		}
	}


	TilePosition CrawlingBallAttack::evalPoints(std::vector<TilePosition> f) {
		TilePosition best = f.at(0);
		int id = 0;
		for(unsigned int i = 0; i < f.size(); i++){
			if(f.at(i).getDistance(v.at(v.size()-1)) > subgoal.getDistance(v.at(v.size()-1))) {
				best = f.at(i);
				f.erase(f.begin()+i);
				return best;
			}
		}

		return TilePosition(0,0);
	}

	void CrawlingBallAttack::calcPoint(TilePosition t){
		////////////agentPool->writeDebugMessage("maign piint");

		int initPopSize = unitTactics.size()*2;
		int initPopVariance = 3; 
		std::vector<TilePosition> population;

		for(int i = 0; i < initPopSize; i++) {
			TilePosition newPosition = t; 
			int newX = rand()%initPopVariance;
			int newY = rand()%initPopVariance;
			if(rand()%100 >= 50) newX = -newX;
			if(rand()%100 >= 50) newY = -newY;
			newPosition = TilePosition(t.x()+newX, t.y()+newY).makeValid();
			population.push_back(newPosition);
		}
		////////////agentPool->writeDebugMessage("done");
		////////////agentPool->writeDebugMessage((int)population.size());



		// assign all the medics
		for(unsigned int k = 0; k < unitTactics.size(); k++) {
			if(unitTactics.at(k)->getUnit()->getType() == UnitTypes::Terran_Medic) {
				assignments[unitTactics.at(k)->getUnit()] = (Position)evalPoints(population);
			}
		}
		for(unsigned int k = 0; k < unitTactics.size(); k++) {
			if(unitTactics.at(k)->getUnit()->getType() != UnitTypes::Terran_Medic) {
				assignments[unitTactics.at(k)->getUnit()] = (Position)population.at(k);
			}
		}
	}

	void CrawlingBallAttack::removeUnit( Unit* u )
	{

	}
