#ifndef CONAGENT_H
#define CONAGENT_H
#include "AgentBase.h"
#include "BWAPI.h"
#include "BuildingPlacer.h"
#include <vector>

using namespace BWAPI;

class AgentPool;

class ConstructionAgent : public AgentBase {
public:
	ConstructionAgent::ConstructionAgent(AgentPool* p);
	virtual void updateDrives();
	virtual Arbitrator* getArbitrator() { return NULL; };
	bool ConstructionAgent::canBeConstructed(BWAPI::UnitType req);
	bool ConstructionAgent::canBeConstructed(BWAPI::UnitType req, BWAPI::Unit* worker);
	bool ConstructionAgent::canBeConstructed(BWAPI::UnitType req, BWAPI::Unit* worker, TilePosition t);
	Unit* ConstructionAgent::buildStructure(BWAPI::UnitType req);
	Unit* ConstructionAgent::buildStructure(BWAPI::UnitType req, BWAPI::TilePosition here);
	Unit* ConstructionAgent::buildStructure(BWAPI::UnitType req, BWAPI::TilePosition here, BWAPI::Unit* worker);
	Unit* ConstructionAgent::buildStructure(BWAPI::UnitType original, BWAPI::UnitType req, BWAPI::TilePosition nearhere, int minDistance, BWAPI::Unit* worker);
	Unit* ConstructionAgent::buildStructure(BWAPI::UnitType req, BWAPI::Unit* worker);
	Unit* ConstructionAgent::buildStructureAround(BWAPI::UnitType req, BWAPI::Unit* worker, BWAPI::TilePosition nearhere);
	Unit* ConstructionAgent::findAvailableWorker();
	Unit* ConstructionAgent::findAvailableWorkerNear(Position p, int radius);
	BuildingPlacer* ConstructionAgent::getBuildingPlacer();
private:
	AgentPool* agentPool;
	BuildingPlacer* buildingPlacer;
	std::vector<BWAPI::Unit*> availableWorkers;
	int unitsAssigned;
	std::map<Unit*,Unit*> constructionMap;

};
#endif