#include "ConstructionAgent.h"
#include "AgentPool.h"
#include "InformationManagerAgent.h"

ConstructionAgent::ConstructionAgent(AgentPool* p) {
	agentPool = p;
	buildingPlacer = new BuildingPlacer();
}


	BuildingPlacer* ConstructionAgent::getBuildingPlacer() {
		return buildingPlacer;
	}

/*
	Suggested improvement: Pick the worker closest to the construction site
*/
Unit* ConstructionAgent::findAvailableWorker() {
	////////////////////////agentPool->writeDebugMessage("looking for a worker!");
	std::vector<Unit*> workers = agentPool->getSquads()->getSquadByName("workers")->getLivingUnits();
	for(unsigned int i = 0; i < workers.size(); i++)
    {
		Unit* candidate = workers.at(i);
		if(candidate->isCompleted() && !candidate->isMoving() && candidate->getHitPoints() > 0) {
			if (!candidate->isUnderAttack() && ((candidate->isIdle()) || (!candidate->isConstructing() && !candidate->isGatheringMinerals() && !candidate->isCarryingGas() && !candidate->isCarryingMinerals())))
		{

		  return candidate;
		}
		}
	} 
	if(workers.empty()) {
		return NULL;
	} else {
		random_shuffle(workers.begin(), workers.end());
		return workers.at(0);
	}
}

Unit* ConstructionAgent::findAvailableWorkerNear(Position p, int radius) {
	////////////////////////agentPool->writeDebugMessage("looking for a worker!");
	std::vector<Unit*> workers = agentPool->getSquads()->getSquadByName("workers")->getLivingUnits();
	for(unsigned int i = 0; i < workers.size(); i++)
	{
		Unit* candidate = workers.at(i);
		if(candidate->isCompleted() && !candidate->isMoving() && candidate->getHitPoints() > 0) {
			if (!candidate->isUnderAttack() && ((candidate->isIdle()) || (!candidate->isConstructing() && !candidate->isGatheringMinerals() && !candidate->isCarryingGas() && !candidate->isCarryingMinerals())))
			{
				if(candidate->getDistance(p) < radius) {
				return candidate;
				}
			}
		}
	} 
	if(workers.empty()) {
		return NULL;
	} else {
	random_shuffle(workers.begin(), workers.end());
	return workers.at(0);
	}
}


void ConstructionAgent::updateDrives() {
	if(Broodwar->getFrameCount()%128 ==0) {
		std::set<Unit*> u = Broodwar->self()->getUnits();
		for(std::set<Unit*>::const_iterator i = u.begin(); i != u.end(); i++) {
			Unit* cur = *i;
			if(cur->getType().isBuilding() && cur->getBuildUnit() == NULL) {
				if(constructionMap[cur] == NULL) {
					Unit* worker = findAvailableWorkerNear(cur->getPosition(), 300);
					if(worker != NULL) {
						worker->rightClick(cur);
						constructionMap[cur] = worker;
					}
				}
			}
		}
	}
}


bool ConstructionAgent::canBeConstructed(BWAPI::UnitType req) {
	
	Unit* worker = findAvailableWorker();
	if(worker == NULL) {
	
		return false;
	} else {
	if(Broodwar->canMake(worker, req)) {

		return true;
	} else {
	return false;
	}
}
}

bool ConstructionAgent::canBeConstructed(BWAPI::UnitType req, BWAPI::Unit* worker) {
	return Broodwar->canMake(worker, req);
}

bool ConstructionAgent::canBeConstructed(BWAPI::UnitType req, BWAPI::Unit* worker, TilePosition t) {
	return Broodwar->canMake(worker, req) && buildingPlacer->canBuildHere(t, req);
}

Unit* ConstructionAgent::buildStructure(BWAPI::UnitType req) {
		//////////////////////////agentPool->writeDebugMessage("Looking for somewhere to build!");
		TilePosition t = buildingPlacer->getBuildLocationNear(agentPool->getCurrentPrimaryBase()->getTilePosition(), req);
		//buildingPlacer->reserveTiles(t, req.tileHeight(), req.tileWidth());

		Unit* worker = findAvailableWorker();
		InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
		BaseModel* nearestBase = im->getBase(t);
		if(nearestBase != NULL) {
			if(nearestBase->isUnderAttack()) {
				return NULL;
			}
		}

		if(!worker->build(t,req)) {
			////////////////////////agentPool->writeDebugMessage("can't build!!");
		} else {
			////////////////////////agentPool->writeDebugMessage("building!!");
		}
				//////////////////////////agentPool->writeDebugMessage("command sent");
		return worker;
}

Unit* ConstructionAgent::buildStructure(BWAPI::UnitType req, BWAPI::Unit* worker) {
	TilePosition t;
	if(worker == NULL) {
		return NULL;
	}
	if(req == BWAPI::UnitTypes::Terran_Factory) {
		t = buildingPlacer->getBuildLocationNear(agentPool->getCurrentPrimaryBase()->getTilePosition(), req);
	} else if(req == BWAPI::UnitTypes::Terran_Bunker) {

		std::set<BWTA::Chokepoint*> s = BWTA::getNearestBaseLocation(worker->getPosition())->getRegion()->getChokepoints();
		std::set<BWTA::Chokepoint*>::const_iterator it(s.begin());
		std::advance(it,rand()%s.size());
		BWTA::Chokepoint* target = *it;

		t = buildingPlacer->getBuildLocationNear((TilePosition)target->getCenter(), req, 1);

	} else if (req == UnitTypes::Terran_Missile_Turret) {
		//buildingPlacer->setBuildDistance(1);
		t = buildingPlacer->getBuildLocationNear(agentPool->getCurrentPrimaryBase()->getTilePosition(), req);
		//buildingPlacer->setBuildDistance(2);
	} else if (req == UnitTypes::Terran_Supply_Depot) {
		
		//InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
		//std::vector<Unit*> v = i->getUnitsOfType(UnitTypes::Terran_Supply_Depot);
		//if(!v.empty()) {
		//	random_shuffle(v.begin(), v.end());
		//	t = buildingPlacer->getBuildLocationNear(v.at(0)->getTilePosition(), req);
		//} else {
			t = buildingPlacer->getBuildLocationNear(agentPool->getCurrentPrimaryBase()->getTilePosition(), req);	
		//}
	} else {
		 t = buildingPlacer->getBuildLocationNear(agentPool->getCurrentPrimaryBase()->getTilePosition(), req);
	}
	
	InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
	BaseModel* nearestBase = im->getBase(t);
	if(nearestBase != NULL) {
		if(nearestBase->isUnderAttack()) {
			return NULL;
		}
	}

		bool build = worker->build(t,req);
		if(build) {
			//buildingPlacer->reserveTiles(t, req.tileHeight(), req.tileWidth());
			return worker;
		}
		
		return NULL;
}

Unit* ConstructionAgent::buildStructureAround(BWAPI::UnitType req, BWAPI::Unit* worker, BWAPI::TilePosition nearhere) {
		//buildingPlacer->setBuildDistance(1);
		TilePosition t;
			InformationManagerAgent* ei = (InformationManagerAgent*)agentPool->getAgent("EI");
			InformationManagerAgent* pi = (InformationManagerAgent*)agentPool->getAgent("PI");
			Position target;
		if(req == BWAPI::UnitTypes::Terran_Bunker) {
			/*
			if(Broodwar->self()->getStartLocation().getDistance(nearhere) <= 8) {
				std::set<BWTA::Chokepoint*> c = BWTA::getNearestBaseLocation(nearhere)->getRegion()->getChokepoints();
				std::vector<Chokepoint*> safeChokes;
				for(std::set<BWTA::Chokepoint*>::const_iterator i = c.begin(); i != c.end(); i++) {
					Chokepoint* cur = *i;
					std::set<BWAPI::Unit*> nbrs = Broodwar->getUnitsInRadius(cur->getCenter(), 128);
					bool obstructed = false;
					for (std::set<BWAPI::Unit*>::const_iterator it = nbrs.begin(); it != nbrs.end(); ++it) {
						if((*it)->getType().isResourceContainer()) {
							if((*it)->getResources() == 0) {
								obstructed = true;
							}
						}
					}
				
				if(!obstructed) {
					safeChokes.push_back(cur);
				}
			}
					std::vector<Position> population;
			if(!safeChokes.empty()) {
				for(unsigned int i = 0; i < 256; i++) {
					Position newPosition = safeChokes.at(0)->getCenter();
					int newX = rand()%128;
					int newY = rand()%128;
					if(rand()%100 >= 50) newX = -newX;
					if(rand()%100 >= 50) newY = -newY;
					newPosition = Position(newPosition.x()+newX, newPosition.y()+newY);

					population.push_back(newPosition);

				}
				Position best = population.at(0);
				for(unsigned int k = 0; k < 256; k++) {
					if(population.at(k).getDistance((Position)nearhere) < best.getDistance((Position)nearhere)) {
						best = population.at(k);
					}
				}
					target = best;
					t = buildingPlacer->getBuildLocationNear((TilePosition)target, req,1);

				} else {
					target = (Position)nearhere;
					t = buildingPlacer->getBuildLocationNear((TilePosition)target, req,1);
				}


			} else {
				target = (Position)nearhere;
				t = buildingPlacer->getBuildLocationNear((TilePosition)target, req,1);
			}
			*/
			t = buildingPlacer->getBuildLocationNear(nearhere, req,1);
		} else {

		if(buildingPlacer->canBuildHere(nearhere, req)) {
			t = nearhere;
		} else {
			t = buildingPlacer->getBuildLocationNear(nearhere, req);
		}
		}
		InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
		BaseModel* nearestBase = im->getBase(t);
		if(nearestBase != NULL) {
			if(nearestBase->isUnderAttack()) {
				return NULL;
			}
		}

		bool build = worker->build(t,req);
	//	////Broodwar->sendText(Broodwar->getLastError().toString().c_str());
		if(build == true) {
			//buildingPlacer->reserveTiles(t, req.tileHeight(), req.tileWidth());
			return worker;
		}
		return NULL;
}

Unit* ConstructionAgent::buildStructure(BWAPI::UnitType req, BWAPI::TilePosition here) {

		
		Unit* worker = findAvailableWorker();
		if(worker != NULL) {
		
		//worker->move((Position)here);
		bool s = worker->build(here,req);
		if(s) { 
			//buildingPlacer->reserveTiles(here, req.tileHeight(), req.tileWidth());
		}
		}
		return worker;
}

// used for expanding buildings, ie. building comsat and nuke expansions
Unit* ConstructionAgent::buildStructure(BWAPI::UnitType original, BWAPI::UnitType req, BWAPI::TilePosition nearhere, int minDistance, BWAPI::Unit* worker) {
		
	////////////////////////agentPool->writeDebugMessage("looking for a good place to build");	
	bool s = false;

	// top left corner of the original
	s = worker->buildAddon(req);
	////////////////////////agentPool->writeDebugMessage("command sent");
	


	if(s) {
		////////////////////////agentPool->writeDebugMessage("success");
		//buildingPlacer->reserveTiles(nearhere, original.tileHeight(), original.tileWidth());
		return worker;
	} else {
		////////////////////////agentPool->writeDebugMessage("failiure!");
		////////////////////////agentPool->writeDebugMessage(Broodwar->getLastError().toString());
		////////////////////////agentPool->writeDebugMessage(worker->getOrder().getName());
		return NULL;
	}
}


Unit* ConstructionAgent::buildStructure(BWAPI::UnitType req, BWAPI::TilePosition here, BWAPI::Unit* worker) {
	if(req == UnitTypes::Terran_Refinery) {
		////////////////////////agentPool->writeDebugMessage("ok trying to build refinery");	
	}
	////////////////////////agentPool->writeDebugMessage("sending reserve command");	
	
		////////////////////////agentPool->writeDebugMessage("sending build command");	
//	worker->move((Position)here);
	bool s = worker->build(here,req);
	InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
	BaseModel* nearestBase = im->getBase(here);
	if(nearestBase != NULL) {
		if(nearestBase->isUnderAttack()) {
			return NULL;
		}
	}

	if(s) {
		////////////////////////agentPool->writeDebugMessage("success");
		//buildingPlacer->reserveTiles(here, req.tileHeight(), req.tileWidth());
		return worker;
	} else {
		////////////////////////agentPool->writeDebugMessage("failiure!");
		////////////////////////agentPool->writeDebugMessage(Broodwar->getLastError().toString());
		////////////////////////agentPool->writeDebugMessage(worker->getOrder().getName());
		return NULL;
	}
	

		return worker;
}