#ifndef COMBATSCVMICRO_H
#define COMBATSCVMICRO_H
#include "MicroTacticsModel.h"
#include "BWTA.h"
#include "CrawlingBallAttack.h"

using namespace BWTA;
class AgentPool;

class CombatSCVMicroTactics : public MicroTacticsModel {

public:
	CombatSCVMicroTactics::CombatSCVMicroTactics(Unit* u, AgentPool* p, CrawlingBallAttack* c);
	CombatSCVMicroTactics::CombatSCVMicroTactics(Unit* u, int movementLag);
	virtual bool MicroTacticsModel::executeTactics();
	virtual Unit* getUnit();
	virtual void setMovementLag(int l);
	virtual void move(Position p);
		virtual UnitType getKnownType();
private:
	Unit* element;
	Unit* closestEnemy;
	Position targetLoc;
	AgentPool* agentPool;
	int wait;
	int initialMovementLag;
	int movementLagTimer;
	Unit* followTarget;
	Chokepoint* cpTarget;
	BaseLocation* bTarget;
	bool inPosition;
	CrawlingBallAttack* squadTactics;
	UnitType knownType;
};


#endif