#include "CombatSCVMicroTactics.h"
#include <cmath>
#include "AgentPool.h"

CombatSCVMicroTactics::CombatSCVMicroTactics(Unit* u, AgentPool* p, CrawlingBallAttack* c) {
	element = u;
	closestEnemy = NULL;
	wait = 0;
	movementLagTimer = 0;
	initialMovementLag = 0;
	cpTarget = NULL;
	bTarget = NULL;
	inPosition = false;
	agentPool = p;
	squadTactics = c;
	knownType = u->getType();
}

CombatSCVMicroTactics::CombatSCVMicroTactics(Unit* u, int movementLag) {
	element = u;
	closestEnemy = NULL;
	wait = 0;
	movementLagTimer = movementLag;
	initialMovementLag = movementLag;
	cpTarget = NULL;
	bTarget = NULL;
	inPosition = false;
	knownType = u->getType();
}

UnitType CombatSCVMicroTactics::getKnownType() {
	return knownType;
}
void CombatSCVMicroTactics::move(Position p) {
	// INSTEAD of moving to p, move to the best location you can see from here to p
	int initPopSize = 256;
	int initPopVariance = 96;
	std::vector<Position> population;
	std::vector<Position> solution;

	// generate population
	for(int i = 0; i < initPopSize; i++) {
		Position newPosition = p;
		int newX = rand()%initPopVariance;
		int newY = rand()%initPopVariance;
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;
		newPosition = Position(p.x()+newX, p.y()+newY);
		population.push_back(newPosition);
	}

	// find the best member
	Position bestPosition = population.at(0);
	for(int i = 0; i < initPopSize; i++) {
		Position n = population.at(i);
		if((n.getApproxDistance(p) < bestPosition.getApproxDistance(p)) && element->hasPath(n)) {
			bestPosition = n;
		}
	}

	element->move(bestPosition);

}

void CombatSCVMicroTactics::setMovementLag(int l) {
	initialMovementLag = l;
	movementLagTimer = l;
}

bool CombatSCVMicroTactics::executeTactics() {
	Unit* bestTarget = NULL;
	std::set<Unit*> stuffInRange = element->getUnitsInRadius(element->getType().sightRange());

	for (std::set<BWAPI::Unit*>::const_iterator it = stuffInRange.begin(); it != stuffInRange.end(); ++it)
	{
		if((*it)->getPlayer() == Broodwar->self() && ((*it)->getType().isMechanical() || (*it)->getType().isRobotic()) && (*it)->getHitPoints() < (*it)->getType().maxHitPoints()) {
				if(bestTarget == NULL) {
					bestTarget = *it;
				} else {
					if(bestTarget->getHitPoints() < (*it)->getHitPoints()) {
						bestTarget = *it;
					}
				}
		}
	}
	if(!element->isRepairing() && bestTarget != NULL) {
		element->repair(bestTarget);
	//	bestTarget->move(element->getPosition());
		if(!bestTarget->isAttacking() && !bestTarget->isHoldingPosition()) {
		bestTarget->holdPosition();
		}
		return true;
	}
	std::vector<MicroTacticsModel*> tanks = squadTactics->getSubTeam(UnitTypes::Terran_Siege_Tank_Siege_Mode);
	if(!tanks.empty()) {
		Position tankLine;

		int avgX = 0;
		int avgY = 0;
		int siegedTanks = 0;
		// find where the tanks are
		for(unsigned int i = 0; i < tanks.size(); i++) {
			if(tanks.at(i)->getUnit()->isSieged()) {
				avgX = avgX + tanks.at(i)->getUnit()->getPosition().x();
				avgY = avgY + tanks.at(i)->getUnit()->getPosition().y();
				siegedTanks++;
			}
		}
		//if(siegedTanks == 0) {

		//} else {
		// find the average position
		if(siegedTanks != 0) {
			avgX = avgX/siegedTanks;
			avgY = avgY/siegedTanks;
			tankLine = Position(avgX, avgY);

			// now... we might already be AT the tank line
			// in which case, we just want to shoot stuff...
			// but if we're far away, lets move towards it
			if(element->getPosition().getDistance(tankLine) > 250) {


				// move there
				//if(!element->isMoving()) {
				////////Broodwar->sendText("moving to tanks");
				if(element->isAttacking()) {
					element->stop();
				}
				move(tankLine);
				//}
				return true;
			} else {
				////////Broodwar->sendText("i'm at the tank line!");

				if(!element->isRepairing() && bestTarget != NULL) {
						element->repair(bestTarget);
						return true;
				} else {
					if(element->getPosition().getDistance(Position(tankLine)) > 100) {
						move(tankLine);
					}
				}
				return true;
			}
		}

		//}
	}



	return false;
}

Unit* CombatSCVMicroTactics::getUnit() {
	return element;
}


