#ifndef BIDMANAGER_H
#define BIDMANAGER_H
#include "BWAPI.h"


using namespace BWAPI;
class AgentPool;
class GoalDescriptor;

struct reservation {
	int priority;
	int gas;
	int minerals;
	int lifetime;
	int goalDescriptor;
};

class BidManager {


public:
	BidManager(AgentPool* p);
	void reserve(int minamount, int gasamount, int priority, int g);
	bool canWithdraw(int minamount, int gasamount, int priority);
	bool canCashIn(int minamount, int gasamount, int priority);
	void relinquish(int minamount, int gasamount, int priority, int g);
	int getReservedMinerals();
	int getReservedGas();
	void writeReservedMinerals();
	void updateDrives();
	AgentPool* agentPool;
private:
	//AgentPool* agentPool;
	int numMinerals;
	int numGas;
	
	std::pair<int,int> reservedResources[64];
	std::vector<reservation> temporalData;



};


#endif