#include "BidManager.h"
#include "AgentPool.h"
#include "GoalDescriptor.h"

BidManager::BidManager(AgentPool* p) {
	agentPool = p;
	numMinerals = BWAPI::Broodwar->self()->minerals();
	numGas =  BWAPI::Broodwar->self()->gas();
	for(unsigned int i = 0; i < 64; i++) {
		reservedResources[i].first = 0;
		reservedResources[i].second = 0;
	}
}
bool BidManager::canCashIn(int mineralAmount, int gasAmount, int priority) {
	////////////////////agentPool->writeDebugMessage("", "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage("", "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage("---performing bid management---", "C:\\quorumdebugger\\bidmanager.txt");

	////////////////////agentPool->writeDebugMessage("a process of priority: ", "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage(priority, "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage("wishes to reserve minerals: ", "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage(mineralAmount, "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage("and gas: ", "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage(gasAmount, "C:\\quorumdebugger\\bidmanager.txt");


	numMinerals = BWAPI::Broodwar->self()->minerals();
	numGas =  BWAPI::Broodwar->self()->gas();

	int minSumReserved = 0;
	int gasSumReserved = 0;
	// trying 0 here, was priority+1
//	for(unsigned int i = priority; i < 64; i++) {
//	minSumReserved = getReservedMinerals();
//	gasSumReserved = getReservedGas();
	//}
	////////////////////agentPool->writeDebugMessage("starting off at priority", "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage(priority-1, "C:\\quorumdebugger\\bidmanager.txt");
	for(unsigned int i = priority; i < 64; i++) {

	minSumReserved = minSumReserved+reservedResources[i].first;
	gasSumReserved = gasSumReserved+reservedResources[i].second;

	}

	////////////////////agentPool->writeDebugMessage("minerals reserved at or above this priority: ", "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage(minSumReserved, "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage("gas reserved: ", "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage(gasSumReserved, "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage("minerals to hand: ", "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage(numMinerals, "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage("gas to hand: ", "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage(numGas, "C:\\quorumdebugger\\bidmanager.txt");



	if(minSumReserved == 0 && (gasSumReserved == 0 || gasAmount == 0)) {
			////////////////////agentPool->writeDebugMessage("nothing reserved, so we return true", "C:\\quorumdebugger\\bidmanager.txt");
		return true;
	}
	if((numMinerals-minSumReserved) >= mineralAmount && (numGas-gasSumReserved) >= gasAmount) {
		////////////////////agentPool->writeDebugMessage("so we return true", "C:\\quorumdebugger\\bidmanager.txt");
		return true;
	}
	////////////////////agentPool->writeDebugMessage("so we return false", "C:\\quorumdebugger\\bidmanager.txt");
	return false;

}

void BidManager::writeReservedMinerals() {

}

bool BidManager::canWithdraw(int mineralAmount, int gasAmount, int priority) {
	numMinerals = BWAPI::Broodwar->self()->minerals();
	numGas =  BWAPI::Broodwar->self()->gas();

	int minSumReserved = 0;
	int gasSumReserved = 0;

	// trying 0 here, was priority+1
	for(unsigned int i = 0; i < 64; i++) {
		minSumReserved += reservedResources[i].first;
		gasSumReserved += reservedResources[i].second;
	}

	//return ((numMinerals-minSumReserved) >= 0 && (numMinerals-minSumReserved) <= mineralAmount) && ((numGas-gasSumReserved) >= 0 && (numGas-gasSumReserved) <= gasAmount);
	return numMinerals-(minSumReserved+mineralAmount) >= 0 && numGas-(gasSumReserved+gasAmount) >= 0;

	//return ((minSumReserved) <= mineralAmount+numMinerals) && ((gasSumReserved) <= gasAmount+numGas);
	

	//return ((minSumReserved + mineralAmount) <= numMinerals) && ((gasSumReserved + gasAmount) <= numGas);
		

	//return (minSumReserved <= (numMinerals-minSumReserved)) && (numMinerals-minSumReserved) >= 0 && (gasSumReserved <= (numGas-gasSumReserved)) && (numGas-gasSumReserved) >= 0;
}

int BidManager::getReservedMinerals() {
	int sumReserved = 0;
	for(unsigned int i = 0; i < 64; i++) {
		sumReserved += reservedResources[i].first;
	}
	return sumReserved;
}

int BidManager::getReservedGas() {
	int sumReserved = 0;
	for(unsigned int i = 0; i < 64; i++) {
		sumReserved += reservedResources[i].second;
	}
	return sumReserved;
}

void BidManager::updateDrives() {
	//////////////agentPool->writeDebugMessage("scanning temporal data ");
	for(unsigned int i = 0; i < temporalData.size(); i++) {
		if(temporalData.at(i).lifetime > 0 && temporalData.at(i).lifetime <= 2000) {
			//////////////agentPool->writeDebugMessage("decrementing ");
			//////////////////agentPool->writeDebugMessage(temporalData.at(i).lifetime);
			temporalData.at(i).lifetime = temporalData.at(i).lifetime - 1;
		} 
		if(temporalData.at(i).lifetime <= 0) {
		//	////////Broodwar->sendText("forcibly relinquishing resources for %d", temporalData.at(i).goalDescriptor);
				//////////////agentPool->writeDebugMessage("relinquishing by force ");
			relinquish(temporalData.at(i).minerals, temporalData.at(i).gas, temporalData.at(i).priority, temporalData.at(i).goalDescriptor);
			//////////////agentPool->writeDebugMessage("done ");
		}
	}
		//////////////agentPool->writeDebugMessage("done!");
}


void BidManager::reserve(int minamount, int gasamount, int priority, int g) {
		//////////////agentPool->writeDebugMessage("attempting to reserve: ");
	reservedResources[priority].first+=minamount;
	reservedResources[priority].second+=gasamount;
	if(g>50) {
		//////////////agentPool->writeDebugMessage("HOLY BALLS");

	}
	reservation r;
	r.gas = gasamount;
	r.minerals = minamount;
	r.priority = priority;
	r.lifetime = 1250;
	r.goalDescriptor = g;

	temporalData.push_back(r);

	//if(priority == 5) {
	//////////////agentPool->writeDebugMessage("a process of priority: ", "C:\\quorumdebugger\\bidmanager.txt");
	//////////////agentPool->writeDebugMessage(priority, "C:\\quorumdebugger\\bidmanager.txt");
	//////////////agentPool->writeDebugMessage("has reserved minerals: : ", "C:\\quorumdebugger\\bidmanager.txt");
	//////////////agentPool->writeDebugMessage(minamount, "C:\\quorumdebugger\\bidmanager.txt");
	//////////////agentPool->writeDebugMessage("and gas: ", "C:\\quorumdebugger\\bidmanager.txt");
	//////////////agentPool->writeDebugMessage(gasamount, "C:\\quorumdebugger\\bidmanager.txt");
	//////////////agentPool->writeDebugMessage("and ID: ", "C:\\quorumdebugger\\bidmanager.txt");
	//////////////agentPool->writeDebugMessage(g, "C:\\quorumdebugger\\bidmanager.txt");
	//}
}

void BidManager::relinquish(int minamount, int gasamount,int priority, int g)  {
	//////////////agentPool->writeDebugMessage("trying to remove...");
	//////////////agentPool->writeDebugMessage(minamount);
	//////////////agentPool->writeDebugMessage(gasamount);
	//////////////agentPool->writeDebugMessage("for...");
	//////////////agentPool->writeDebugMessage(g);
	if(reservedResources[priority].first-minamount >= 0 && reservedResources[priority].second-gasamount >= 0) {
	reservedResources[priority].first-=minamount;
	reservedResources[priority].second-=gasamount;
	//////////////agentPool->writeDebugMessage("done here");
	} else {
		//////////////agentPool->writeDebugMessage("couldnt");
	}
	//////////////agentPool->writeDebugMessage("trying to delete temporal reference");
	for(unsigned int i = 0; i < temporalData.size(); i++) {
		if(temporalData.at(i).goalDescriptor == g) {
			//////////////agentPool->writeDebugMessage("trying to kill");
				////agentPool->writeDebugMessage("te,proal data");
			temporalData.erase(temporalData.begin()+i);
				//////////////agentPool->writeDebugMessage("and done here");
			break;
		}
	}
		//////////////agentPool->writeDebugMessage("finishede");
	////////////////////agentPool->writeDebugMessage("a process of priority: ", "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage(priority, "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage("has relinquished minerals: : ", "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage(minamount, "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage("and gas: ", "C:\\quorumdebugger\\bidmanager.txt");
	////////////////////agentPool->writeDebugMessage(gasamount, "C:\\quorumdebugger\\bidmanager.txt");

}