#include "BaseModel.h"
#include "AgentPool.h"
#include "ConstructionAgent.h"

BaseModel::BaseModel(AgentPool* ap, Unit* c) {
	baseLocaton = c->getTilePosition();
	agentPool = ap;
	baseCentre = c;
}

Unit* BaseModel::getCentre() {

	return baseCentre;
}

bool BaseModel::isUnderAttack() {
	if(baseCentre != NULL) {
		if(baseCentre->isCompleted()) {
			std::set<Unit*> units = Broodwar->getUnitsInRadius(baseCentre->getPosition(), 600);
			for(std::set<Unit*>::const_iterator i = units.begin(); i != units.end(); i++) {
				Unit* cur = *i;
				if(cur->getPlayer() == Broodwar->self()){
					if(cur->isUnderAttack()) {
						return true;
					}
				}
			}
		}
	}
	return false;
}

Unit* BaseModel::getAttackTarget() {
	if(baseCentre != NULL) {
		if(baseCentre->isCompleted()) {
			std::set<Unit*> units = Broodwar->getUnitsInRadius(baseCentre->getPosition(),750);
			for(std::set<Unit*>::const_iterator i = units.begin(); i != units.end(); i++) {
				Unit* cur = *i;
				if(cur->getPlayer() == Broodwar->self()){
					if(cur->isUnderAttack()) {
						return cur;
					}
				}
			}
		}
	}
	return false;
}

bool BaseModel::isActive() {
	if(baseCentre != NULL) {
		if(baseCentre->exists()) {

			if(baseCentre->isCompleted()) {
				return true;
			} else {
				return false;
			}

		} else {
			return false;
		}
	}
	return false;
}

std::vector<GasModel*> BaseModel::getLocalGas() {
	std::vector<GasModel*> output;
	//////////////agentPool->writeDebugMessage("\t\t\t looking for minerals");
	for(unsigned int i = 0; i < localGas.size(); i++) {
		if(!localGas.at(i)->isEmpty()) {
			//////////////agentPool->writeDebugMessage("\t\t\t found a mineral deposit");
			output.push_back(localGas.at(i));
		}
	}
	return output;
}

std::vector<MineralModel*> BaseModel::getLocalMinerals() {
	std::vector<MineralModel*> output;
	//////////////agentPool->writeDebugMessage("\t\t\t looking for minerals");
	for(unsigned int i = 0; i < localMinerals.size(); i++) {
		if(!localMinerals.at(i)->isEmpty()) {
			//////////////agentPool->writeDebugMessage("\t\t\t found a mineral deposit");
			output.push_back(localMinerals.at(i));
		}
	}
	return output;
}

Position BaseModel::getPosition() {
	return (Position)baseLocaton;
}

void BaseModel::initialize() {
	// to initialize, look at all of the minerals and gas 
	// around the base location, and add them to the model
	////////////////////////agentPool->writeDebugMessage("initializing new base");
	// record the gas geysers
	std::set<Unit*> geysers = BWTA::getNearestBaseLocation(baseLocaton)->getGeysers();
	for(std::set<Unit*>::iterator m=geysers.begin();m!=geysers.end();m++) {
		//if(baseLocaton.getDistance((*m)->getPosition()) < 550) {
		////////////////////////agentPool->writeDebugMessage("\t\t found a gas deposit");
		localGas.push_back(new GasModel(*m, (*m)->getResources()));
		//}
	}

	// record all the minerals at our start location 
	// skip using bwta, since it occasionally misses out a few mineral patches
	// for some reason?
	//std::set<Unit*> mins = Broodwar->getMinerals();
	std::set<Unit*> mins = BWTA::getNearestBaseLocation(baseLocaton)->getMinerals();
	for(std::set<Unit*>::iterator k=mins.begin();k!=mins.end();k++) {
		//if(baseLocaton.getDistance((*k)->getPosition()) < 750) {

		if((*k)->getResources() != 0 && (*k)->getResources() != 249 ) { // skip any trick patches
			localMinerals.push_back(new MineralModel(*k));
		}
		//}
	}


	////////////////////////agentPool->writeDebugMessage("all done, added...");
	////////////////////////agentPool->writeDebugMessage((int)localMinerals.size());

	////////////////////////agentPool->writeDebugMessage("minerals, and");
}