#ifndef BDEF_GOALHEADERS_H
#define BDEF_GOALHEADERS_H
#include "GoalGeneratorBase.h"
#include "GoalTypes.h"

class BaseDefenseManagerAgent;

// worker training goal
class BaseDefense_BuildAirDefenseGoalGenerator : public GoalGeneratorBase {
public:
	BaseDefense_BuildAirDefenseGoalGenerator(AgentPool* a, BaseDefenseManagerAgent* parent);

	// generic stuff
	virtual void inhibit();
	virtual bool instantiateGoal();
	virtual void updateDrives();
	virtual void initialize();
	virtual int getdrive();
	virtual int getthresh();
		

private:

	// generic stuff
	bool inhibited;
	AgentPool* agentPool;
	int drive;
	int thresh;
	int priority;
	BaseDefenseManagerAgent* parent;
	GoalDescriptor* goal;
	int temporalFactor;
	// implementation-specific stuff, if needed


};



class BaseDefense_BuildGroundDefenseGoalGenerator : public GoalGeneratorBase {
public:
	BaseDefense_BuildGroundDefenseGoalGenerator(AgentPool* a, BaseDefenseManagerAgent* parent);

	// generic stuff
	virtual void inhibit();
	virtual bool instantiateGoal();
	virtual void updateDrives();
	virtual void initialize();
	virtual int getdrive();
	virtual int getthresh();
	


private:

	// generic stuff
	bool inhibited;
	AgentPool* agentPool;
	int drive;
	int thresh;
	int priority;
	BaseDefenseManagerAgent* parent;
	GoalDescriptor* goal;
	int temporalFactor;
	// implementation-specific stuff, if needed


};

#endif