#include "BaseDefense_GoalHeaders.h"
#include "BaseDefenseManagerAgent.h"
#include "MilitaryProductionManagerAgent.h"


BaseDefense_BuildGroundDefenseGoalGenerator::BaseDefense_BuildGroundDefenseGoalGenerator(AgentPool* a, BaseDefenseManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	temporalFactor = 0;
	priority = 9; // remember this
	thresh = 45;
	parent = par;
	goal = new GoalDescriptor(DEFENSE_BUILDGROUNDDEFENSE, priority, 150, 0, agentPool->getArbitrator()->getBidManager());
}

bool BaseDefense_BuildGroundDefenseGoalGenerator::instantiateGoal() {
	return agentPool->getArbitrator()->declareIntention(goal);
	return false;
}

void BaseDefense_BuildGroundDefenseGoalGenerator::inhibit() {

}

void BaseDefense_BuildGroundDefenseGoalGenerator::initialize() {

}

void BaseDefense_BuildGroundDefenseGoalGenerator::updateDrives() {
BWAPI::Unit* worker = goal->getMonitorTarget();
if(goal->isExecuting()) {

	Broodwar->drawCircle(CoordinateType::Map, worker->getPosition().x(), worker->getPosition().y(), 10, Colors::Red, true);

		temporalFactor++;
		if(temporalFactor > 1700) {
			goal->relinquishResources();
			goal->finish();
			temporalFactor = 0;
			drive = 0;
			agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
			return;
		}
		
			if(worker->getBuildUnit() != NULL) { 
				goal->relinquishResources();
				int remainingBuildTime = worker->getBuildUnit()->getRemainingBuildTime();
				if(worker->getBuildUnit()->isCompleted() || remainingBuildTime < 30) {
					//Broodwar->sendText("finished bunker");
					
					temporalFactor = 0;
					
					
					goal->modifyPriority(goal->getGoalPriority()+1);
					goal->finish();
					agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
					drive = 0;
					MilitaryProductionManagerAgent* mp = (MilitaryProductionManagerAgent*)agentPool->getAgent("MP");
					std::pair<UnitType, int> order;
						order.first = UnitTypes::Terran_Marine;
						order.second = 2+(rand()%3);
					UnitOrder* u = new UnitOrder(order);
					
					mp->registerProductionOrder(order);
				}
			}  else {
				if(worker != NULL) {
					if(!worker->isConstructing() && !worker->isMoving() && worker->getOrder() != Orders::ResetCollision) {
						goal->relinquishResources();
						goal->retry();
						agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
						temporalFactor = 0;
					}
				}
			}
	}


	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			//////////////////////////agentPool->writeDebugMessage("i'd like to build an factory!!");
			if(instantiateGoal()) {
				//////////////////////////agentPool->writeDebugMessage("it's queued!");
				drive = 0;
					temporalFactor = 0;
			}
		} else {
			InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
			if(i->hasUnit(UnitTypes::Terran_Barracks) && (i->countUnitType(UnitTypes::Terran_Bunker) < i->getBases().size())) {
				if(drive < thresh) {
					drive++;
				}
			}
		}
	}
}

int BaseDefense_BuildGroundDefenseGoalGenerator::getthresh() {
	return thresh;
}

int BaseDefense_BuildGroundDefenseGoalGenerator::getdrive() {
	return drive;
}

/*

Implementation-specific functions.

*/

