#include "BaseDefense_GoalHeaders.h"
#include "BaseDefenseManagerAgent.h"


BaseDefense_BuildAirDefenseGoalGenerator::BaseDefense_BuildAirDefenseGoalGenerator(AgentPool* a, BaseDefenseManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	temporalFactor = 0;
	priority = 8; // remember this
	thresh = 50;
	parent = par;
	goal = new GoalDescriptor(DEFENSE_BUILDAIRDEFENSE, priority, 75, 0, agentPool->getArbitrator()->getBidManager());
}

bool BaseDefense_BuildAirDefenseGoalGenerator::instantiateGoal() {
	return agentPool->getArbitrator()->declareIntention(goal);
	return false;
}

void BaseDefense_BuildAirDefenseGoalGenerator::inhibit() {

}

void BaseDefense_BuildAirDefenseGoalGenerator::initialize() {

}

void BaseDefense_BuildAirDefenseGoalGenerator::updateDrives() {
BWAPI::Unit* worker = goal->getMonitorTarget();	
if(goal->isExecuting()) {
		temporalFactor++;
		if(temporalFactor > 1300) {	
			worker->move((Position)Broodwar->self()->getStartLocation());
			goal->relinquishResources();
			goal->finish();
			temporalFactor = 0;
						drive = 0;
					
			agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
			return;
		}
		
			if(worker->getBuildUnit() != NULL) { 
				goal->relinquishResources();
				int remainingBuildTime = worker->getBuildUnit()->getRemainingBuildTime();
				if(remainingBuildTime < 40) {
					goal->relinquishResources();
					goal->finish();
					temporalFactor = 0;
					agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
					drive = 0;
				}
			//}
		} else {
			if(worker != NULL) {
				if(!worker->isConstructing() && !worker->isMoving() && worker->getOrder() != Orders::ResetCollision) {
					goal->relinquishResources();
					goal->retry();
					agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
								temporalFactor = 0;
					drive = 0;
						temporalFactor = 0;
				}
			}
		}
	}


	if(!goal->accepted() && !goal->isExecuting()) {
		InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");

		if(drive >= thresh) {
			if(i->getReccomendedFlyerType() == UnitTypes::Terran_Valkyrie && priority == 9) {
				goal->modifyPriority(12);
				thresh = 35;
			}
			if(instantiateGoal()) {
				//////////////////////////agentPool->writeDebugMessage("it's queued!");
				drive = 0;
					temporalFactor = 0;
			}
		} else {
			//if(i->hasUnit(UnitTypes::Terran_Barracks)) {
				if(drive < thresh) {
					drive++;
				}

			//}
		}
	}
}

int BaseDefense_BuildAirDefenseGoalGenerator::getthresh() {
	return thresh;
}

int BaseDefense_BuildAirDefenseGoalGenerator::getdrive() {
	return drive;
}

/*

Implementation-specific functions.

*/

