#ifndef BASEDEFMANAGERAGENT_H
#define BASEDEFMANAGERAGENT_H
#include "GoalDescriptor.h"
#include "AgentPool.h"
#include "GoalTypes.h"
#include "UnitModel.h"
#include "BaseModel.h"
#include "BWTA.h"
#include "BaseDefense_GoalHeaders.h"
#include <vector>
#include <stack>

using namespace BWTA;


class BaseDefenseManagerAgent : public AgentBase {
public:

	BaseDefenseManagerAgent(AgentPool* p);
	void requisitionIdleMarines();
	void requisitionIdleTanks();
	void requisitionIdleMechs();
	void repairBrokenStuff();
	void monitorBunkers();
	void monitorBases();
	void monitorChokePoints();
	BaseModel* findWeakestBaseAirDefense();
	BaseModel* findWeakestBaseGroundDefense();
	virtual void updateDrives();
	virtual Arbitrator* getArbitrator() { return NULL; };

private:
	AgentPool* agentPool;
	BaseDefense_BuildAirDefenseGoalGenerator* buildAirDefenseGoalGenerator;
	BaseDefense_BuildGroundDefenseGoalGenerator* buildGroundDefenseGoalGenerator;
	std::vector<Unit*> assignedTanks;
	std::vector<Unit*> bunkers;
	std::vector<std::pair<Unit*, Position>> defendingWorkers;
	int defenseTimer;
	std::map<Unit*, Position> rubberBand;
	std::map<Unit*, int> chokeMonitor;
};


#endif
