#include "BaseDefenseManagerAgent.h"
#include "AgentPool.h"
#include "SquadManagerAgent.h"
#include "ConstructionAgent.h"
#include "BaseModel.h"

BaseDefenseManagerAgent::BaseDefenseManagerAgent(AgentPool* p) {
	agentPool = p;
	buildAirDefenseGoalGenerator = new BaseDefense_BuildAirDefenseGoalGenerator(agentPool, this);
	buildGroundDefenseGoalGenerator = new BaseDefense_BuildGroundDefenseGoalGenerator(agentPool, this);
	defenseTimer = 0;
}

void BaseDefenseManagerAgent::updateDrives() {

	repairBrokenStuff();
	monitorBunkers();
	monitorBases();
	if(Broodwar->getFrameCount()%32==0) { // was 32
		//agentPool->writeDebugMessage("marines..");
		requisitionIdleMarines();
		//agentPool->writeDebugMessage("mechs..");
		requisitionIdleMechs();
		//agentPool->writeDebugMessage("tanks..");
		requisitionIdleTanks();
		//agentPool->writeDebugMessage("cps..");
		//agentPool->writeDebugMessage("done");
	}
	if(Broodwar->getFrameCount()%64==0) { // was 32
			monitorChokePoints();
	}
	buildAirDefenseGoalGenerator->updateDrives();
	buildGroundDefenseGoalGenerator->updateDrives();
}

void BaseDefenseManagerAgent::monitorBases() {
	InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
	for(int i = 0; i < defendingWorkers.size(); i++) {
		std::pair<Unit*, Position> p = defendingWorkers.at(i);
		if(p.first->getDistance(p.second) > 1000 || !p.first->isAttacking() || !p.first->isMoving() || p.first->isIdle()) {
			p.first->move(p.second);
			////agentPool->writeDebugMessage("defending workers");
			defendingWorkers.erase(defendingWorkers.begin()+i);
		}
	}


	for(int i = 0; i < im->getBases().size(); i++) {
		if(im->getBases().at(i)->isUnderAttack()) {
			// find all the free defenders in the area
			std::set<Unit*> defenders = Broodwar->getUnitsInRadius(im->getBases().at(i)->getPosition(), 850);
			for(std::set<Unit*>::const_iterator it = defenders.begin(); it!=defenders.end();it++) {
				if((*it)->getPlayer() == Broodwar->self() && (*it)->getType() != UnitTypes::Terran_SCV && (*it)->getType() != UnitTypes::Terran_Science_Vessel && (*it)->getType() != UnitTypes::Terran_Siege_Tank_Siege_Mode){
					if(!(*it)->isAttacking() && !(*it)->isMoving()) {
						Position point = im->getBases().at(i)->getAttackTarget()->getPosition();
						for(std::set<Unit*>::const_iterator iit = defenders.begin(); iit!=defenders.end();iit++) {
							Unit* target = *iit;

							if((*it)->getType().isFlyer()) {

							
								if((*it)->getType() == Terran_Valkyrie) {
									if(target->getType().isFlyer()) {
										if(target->getPlayer() == Broodwar->enemy() && target->getType() != Zerg_Scourge) {
											(*it)->rightClick(target);
											break;
										}
									}
								} else if ((*it)->getType() == UnitTypes::Terran_Wraith) {
									if(target->getPlayer() == Broodwar->enemy() && target->getType() != Zerg_Scourge && target->getType() != Terran_Valkyrie) {
										(*it)->rightClick(target);
										break;
									}
								}


							} else {
								if(target->getPlayer() == Broodwar->enemy()) {
									(*it)->attack(target->getPosition());
									rubberBand[*it] = (*it)->getPosition();
									break;
								}
							}

						}
						// also maybe alert air units?
					}
				}
				}
			}
		

		// if there is an enemy worker in our base, kill it
		std::set<Unit*> attackers = Broodwar->getUnitsInRadius(im->getBases().at(i)->getPosition(), 550);
		for(std::set<Unit*>::const_iterator it = attackers.begin(); it!=attackers.end();it++) {
			Unit* cur = *it;
			bool attackOrderComplete = false;
			if(cur->getPlayer() == Broodwar->enemy() && cur->getType().isWorker()) {
				std::set<Unit*> workers = Broodwar->getUnitsInRadius(cur->getPosition(), 500);

				int attackingWorkers = defendingWorkers.size();
				for(std::set<Unit*>::const_iterator itt = workers.begin(); itt!=workers.end();itt++) {
					Unit* worker = *itt;
					if(worker->getType().isWorker() && worker->isCompleted()) {
						if(!worker->isAttacking() && !worker->isMoving()) {


							if(attackingWorkers < 5) {	
								std::pair<Unit*,Position> w;
								w.first = worker;
								w.second = worker->getPosition();

								defendingWorkers.push_back(w);
								worker->attack(cur);
								attackingWorkers++;
							} else {
								attackOrderComplete = true;
							}
						}
					}

				}
			}
			if(attackOrderComplete) {
				break;
			}
		}
	}





	}


BaseModel* BaseDefenseManagerAgent::findWeakestBaseAirDefense() {
	InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
	if(!im->getBases().empty()) {
		std::vector<BaseModel*> bases = im->getBases();
		BaseModel* worstBaseSoFar = bases.at(0);
		int leastTurretsSoFar = 9000;

		for(unsigned int i = 0; i < bases.size(); i++) {
			BaseModel* currentBase = bases.at(i);

			std::set<Unit*> airDefenses = Broodwar->getUnitsInRadius(currentBase->getPosition(), 450);
			int curTurrets = 0;
			for(std::set<Unit*>::const_iterator it = airDefenses.begin(); it!=airDefenses.end();it++) {
				if((*it)->getPlayer() == Broodwar->self() && (*it)->getType() == UnitTypes::Terran_Missile_Turret){
					curTurrets++;
				}
			}
			if(curTurrets < leastTurretsSoFar) {
				worstBaseSoFar = currentBase;
				leastTurretsSoFar = curTurrets;
			}
		}

		return worstBaseSoFar;
	}
	return NULL;

}


BaseModel* BaseDefenseManagerAgent::findWeakestBaseGroundDefense() {
	//////////agentPool->writeDebugMessage("looking for weakest ground base");
	InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
	if(!im->getBases().empty()) {
		std::vector<BaseModel*> bases = im->getBases();
		BaseModel* worstBaseSoFar = bases.at(0);
		int leastBunkersSoFar = 9000;
		//////////agentPool->writeDebugMessage("a");
		for(unsigned int i = 0; i < bases.size(); i++) {
			BaseModel* currentBase = bases.at(i);

			std::set<Unit*> groundDefenses = Broodwar->getUnitsInRadius(currentBase->getPosition(), 550);
			int curBunkers = 0;
			for(std::set<Unit*>::const_iterator it = groundDefenses.begin(); it!=groundDefenses.end();it++) {
				if((*it)->getPlayer() == Broodwar->self() && (*it)->getType() == UnitTypes::Terran_Bunker){
					curBunkers++;
				}
			}
			if(curBunkers == 0) {
				worstBaseSoFar = currentBase;
				break;
			}
			if(curBunkers < leastBunkersSoFar) {
				worstBaseSoFar = currentBase;
				leastBunkersSoFar = curBunkers;
			}
		}
		//////////agentPool->writeDebugMessage("wehee");
		return worstBaseSoFar;
	}
	return NULL;

}

void BaseDefenseManagerAgent::repairBrokenStuff() {
	if(Broodwar->getFrameCount()%128==0) {

		ConstructionAgent* c = (ConstructionAgent*)agentPool->getAgent("C");
		InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");

		std::vector<BaseModel*> bases = im->getBases();
		////////////////////////agentPool->writeDebugMessage("reassigning tanks");
		for(unsigned int i = 0; i < bases.size(); i++) {
			BaseModel* curBase = bases.at(i);

			std::set<Unit*> units = Broodwar->getUnitsInRadius(curBase->getPosition(), 1000);
			////////////////////////agentPool->writeDebugMessage("looking at a base...");
			// get all the marines that aren't currently in squads
			for(std::set<Unit*>::const_iterator i = units.begin(); i != units.end(); i++) {
				if((*i)->getPlayer() == Broodwar->self() && !(*i)->isBeingConstructed() && ((*i)->getType().isMechanical() || (*i)->getType().isRobotic() || (*i)->getType().isBuilding()) && (*i)->getHitPoints() < (*i)->getType().maxHitPoints() && !(*i)->isUnderAttack() && !(*i)->isBeingHealed()) {
					Unit* worker = c->findAvailableWorkerNear((*i)->getPosition(), 700);
					if(worker != NULL) {
						worker->repair(*i);
					}
				}
			}
		}
	}

}

void BaseDefenseManagerAgent::requisitionIdleTanks() {
	InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
	SquadManagerAgent* sq = (SquadManagerAgent*)agentPool->getAgent("SQ");

	// for each base, look to see if there are any marines hanging around that
	// aren't in squads
	std::vector<BaseModel*> bases = im->getBases();
	////////////agentPool->writeDebugMessage("reassigning tanks");
	for(unsigned int i = 0; i < bases.size(); i++){
		BaseModel* curBase = bases.at(i);

		std::vector<Unit*> tanks;
		std::vector<Unit*> bunkers;
		std::set<Unit*> units = Broodwar->getUnitsInRadius(curBase->getPosition(), 1500);
		////////////agentPool->writeDebugMessage("looking at a base...");
		// get all the marines that aren't currently in squads
		for(std::set<Unit*>::const_iterator i = units.begin(); i != units.end(); i++) {
			Unit* curUnit = *i;
			//////////////agentPool->writeDebugMessage("got a uit");
			if(curUnit->getPlayer() == Broodwar->self()) {
				if(curUnit->getType() == UnitTypes::Terran_Siege_Tank_Tank_Mode || curUnit->getType() == UnitTypes::Terran_Siege_Tank_Siege_Mode) {
					if(!sq->isUnitInSquads(curUnit) && curUnit->isCompleted()) {
						////////////agentPool->writeDebugMessage("got a tanks");
						tanks.push_back(curUnit);
					}
				}
				if(curUnit->getType() == UnitTypes::Terran_Bunker) {
					bunkers.push_back(curUnit);
				}
			}
		}

		if(tanks.empty() || bunkers.empty()) {
			return;
		}


		for(unsigned int j = 0; j < tanks.size(); j++) {
			random_shuffle(bunkers.begin(), bunkers.end());
			for (unsigned int i = bunkers.size(); i-- > 0; ) {
				if(tanks.at(j)->getDistance(tanks.at(j)->getTarget()) < 128) {
					if(!tanks.at(j)->isSieged()) {
						tanks.at(j)->siege();
						break;
					}
				} else {
					if(!tanks.at(j)->isMoving()) {
						Position t = bunkers.at(i)->getPosition();

						while(BWTA::getNearestChokepoint(t)->getCenter().getDistance(t) < 96) {
							int newX = rand()%128;
							int newY = rand()%128;
							if(rand()%100 >= 50) newX = -newX;
							if(rand()%100 >= 50) newY = -newY;
							t = Position(t.x()+newX,t.y()+newY);
						}

						tanks.at(j)->move(t);
						break;

					}
				}

			}

		}
	}
	/*
	for(unsigned int i = 0; i < bunkers.size(); i++) {
	for(unsigned int j = 0; j < tanks.size(); j++) {

	if(tanks.at(j)->getDistance(bunkers.at(i)) < 25) {
	tanks.at(j)->siege();
	} else {
	tanks.at(j)->move(bunkers.at(i)->getPosition());
	}
	}
	}
	}
	*/


}

void BaseDefenseManagerAgent::requisitionIdleMarines() {
	InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
	SquadManagerAgent* sq = (SquadManagerAgent*)agentPool->getAgent("SQ");

	std::vector<BaseModel*> bases = im->getBases();
	if(bases.empty()){
		return;
	}

	std::vector<Unit*> marines;
	std::vector<Unit*> bunkers;
	std::set<Unit*> units = Broodwar->self()->getUnits();

	for(std::set<Unit*>::const_iterator i = units.begin(); i != units.end(); i++) {
		Unit* curUnit = *i;

		if(curUnit->isCompleted() && curUnit->getPlayer() == Broodwar->self()) {

			if(curUnit->getType() == UnitTypes::Terran_Marine || curUnit->getType() == UnitTypes::Terran_Firebat || curUnit->getType() == UnitTypes::Terran_Medic) {
				if(!sq->isUnitInSquads(curUnit) && !curUnit->isMoving() && !curUnit->isLoaded()) {
					marines.push_back(curUnit);
				}
			}
			if(curUnit->getType() == UnitTypes::Terran_Bunker) {
				if(curUnit->getHitPoints() > 150 && curUnit->getLoadedUnits().size() < 4) {
					bunkers.push_back(curUnit);
				}
			}
		}
	}

	if(marines.empty() || bunkers.empty()) {
		return;
	}

	for(unsigned int j = 0; j < marines.size(); j++) {

		bool foundBunker = false;
		for(unsigned int m = 0; m < bunkers.size(); m++) {
			if(!marines.at(j)->isLoaded() && marines.at(j)->getType() != UnitTypes::Terran_Medic) {
				bunkers.at(m)->load(marines.at(j));
				foundBunker = true;
				break;
			}
		}
		if(!foundBunker && !marines.at(j)->isHoldingPosition() && !marines.at(j)->isMoving()) {
			random_shuffle(bunkers.begin(), bunkers.end());

			if(marines.at(j)->getDistance(bunkers.at(0)) > 25  && !marines.at(j)->isAttacking()) {
				marines.at(j)->move(bunkers.at(0)->getPosition());
			} else {
				if(!marines.at(j)->isHoldingPosition() && !marines.at(j)->isAttacking()) {
					marines.at(j)->holdPosition();
				}
			}
		}

	}

}

void BaseDefenseManagerAgent::monitorBunkers() {
	if(Broodwar->getFrameCount()%2==0) {
		InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
		SquadManagerAgent* sq = (SquadManagerAgent*)agentPool->getAgent("SQ");
		std::set<Unit*> units = Broodwar->self()->getUnits();

		std::vector<BaseModel*> bases = im->getBases();
		if(bases.empty()){
			return;
		}
		for(unsigned int i = 0; i < bases.size(); i++){
			BaseModel* curBase = bases.at(i);
			for(std::set<Unit*>::const_iterator it = units.begin(); it != units.end(); it++) {
				Unit* curUnit = *it;

				if(curUnit->getType() == UnitTypes::Terran_Bunker && curUnit->isCompleted()) {
					if(curUnit->getHitPoints() <= 100) {
						curUnit->unloadAll();
						/*
						std::set<Unit*> lu = curUnit->getLoadedUnits();
						for(std::set<Unit*>::const_iterator k = lu.begin(); k != lu.end(); k++) {
							Unit* em = *k;
							em->getTransport()->unload(em);
						}
						*/
					}
				}
			}
		}
	}

}

void BaseDefenseManagerAgent::requisitionIdleMechs()
{
	InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
	SquadManagerAgent* sq = (SquadManagerAgent*)agentPool->getAgent("SQ");

	std::vector<BaseModel*> bases = im->getBases();
	if(bases.empty()){
		return;
	}

	std::vector<Unit*> mechs;
	std::set<Unit*> units = Broodwar->self()->getUnits();

	for(std::set<Unit*>::const_iterator i = units.begin(); i != units.end(); i++) {
		Unit* curUnit = *i;

		if(curUnit->isCompleted() && curUnit->getPlayer() == Broodwar->self()) {

			if(curUnit->getType() == UnitTypes::Terran_Goliath || curUnit->getType() == UnitTypes::Terran_Vulture) {
				if(!sq->isUnitInSquads(curUnit) && !curUnit->isMoving() && !curUnit->isLoaded() && !curUnit->isAttacking()) {
					mechs.push_back(curUnit);
				}
			}
		}
	}

	if(mechs.empty()) {
		return;
	}

	for(unsigned int j = 0; j < mechs.size(); j++) {
		Position newPosition = mechs.at(j)->getPosition();
		int newX = rand()%16;
		int newY = rand()%16;
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;
		if(rubberBand[mechs.at((j))] != Position(0,0) && rubberBand[mechs.at((j))] != 0 && rubberBand[mechs.at((j))] != Positions::None && rubberBand[mechs.at((j))] != Positions::Invalid && rubberBand[mechs.at((j))] != Positions::Unknown) {
			if(mechs.at(j)->getDistance((Position)rubberBand[mechs.at(j)]) > 200) {
				mechs.at((j))->move((Position)rubberBand[mechs.at(j)]);
			} else {
				
			}
		}

	}

}

void BaseDefenseManagerAgent::monitorChokePoints() {
		InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
	std::vector<BaseModel*> b = im->getBases();
	for(int i = 0; i < b.size(); i++) {
		std::set<Chokepoint*> cp = BWTA::getNearestBaseLocation(b.at(i)->getPosition())->getRegion()->getChokepoints();
				for(std::set<Chokepoint*>::const_iterator i = cp.begin(); i != cp.end(); i++) {
					std::set<Unit*> nearByUnits = Broodwar->getUnitsInRadius((*i)->getCenter(), 96);
						for(std::set<Unit*>::const_iterator ip = nearByUnits.begin(); ip != nearByUnits.end(); ip++) {
							if((*ip)->getPlayer() == Broodwar->self() && (((*ip)->isUnderAttack() || (*ip)->isAttacking()) || ((*ip)->getType().isBuilding() || !(*ip)->getType().canMove() || (*ip)->isConstructing() || (*ip)->isRepairing() || (*ip)->isBeingHealed()))) {
								continue;
							}
							if(chokeMonitor[(*ip)] <= 0) {
								chokeMonitor[(*ip)] = 12;
							} 
							if(chokeMonitor[(*ip)] == 4) {
								Position newPosition = (*ip)->getPosition();
								int newX = rand()%256;
								int newY = rand()%256;
								if(rand()%100 >= 50) newX = -newX;
								if(rand()%100 >= 50) newY = -newY;
								(*ip)->move(Position((*ip)->getPosition().x()+newX, (*ip)->getPosition().y()+newY)); 
								chokeMonitor[(*ip)] = 0;
							//	Broodwar->sendText("move along there!");
							} else {
								chokeMonitor[(*ip)] = chokeMonitor[(*ip)] - 1;
							}
						}




				}


	}
}
