#ifndef BBSCVMICRO_H
#define BBSCVMICRO_H
#include "MicroTacticsModel.h"
#include "BWTA.h"
#include <stack>
using namespace BWTA;
class AgentPool;

class BaseBuildingSCVTactics : public MicroTacticsModel {

public:
	BaseBuildingSCVTactics::BaseBuildingSCVTactics(Unit* u, AgentPool* p);
		BaseBuildingSCVTactics::BaseBuildingSCVTactics(Unit* u, int movementLag);
	virtual bool MicroTacticsModel::executeTactics();
	virtual Unit* getUnit();
	virtual void setMovementLag(int l);
	virtual void move(Position p);
			virtual UnitType getKnownType();
	void move(BaseLocation* p);
private:
	Unit* element;
	Unit* closestEnemy;
	Position targetLoc;
	AgentPool* agentPool;
	int wait;
	int initialMovementLag;
	int movementLagTimer;
	Unit* followTarget;
	Chokepoint* cpTarget;
	BaseLocation* bTarget;
	bool inPosition;
	std::vector<Chokepoint*> blacklist;
	bool BaseBuildingSCVTactics::visited(Chokepoint* cp);
	UnitType knownType;
	bool done;
	int teleporterClickCount;
	Unit* firstClicked;
	std::list<Unit*> teleporters;
};


#endif