#include "BaseBuildingSCVTactics.h"
#include <cmath>
#include "AgentPool.h"
#include "ConstructionAgent.h"

BaseBuildingSCVTactics::BaseBuildingSCVTactics(Unit* u, AgentPool* p) {
	element = u;
	closestEnemy = NULL;
	wait = 0;
	movementLagTimer = 0;
	initialMovementLag = 0;
	cpTarget = NULL;
	bTarget = NULL;
	inPosition = false;
	agentPool = p;
	knownType = u->getType();
	done = false;
	teleporterClickCount = 0;
	firstClicked = NULL;
}

BaseBuildingSCVTactics::BaseBuildingSCVTactics(Unit* u, int movementLag) {
	element = u;
	closestEnemy = NULL;
	wait = 0;
	movementLagTimer = movementLag;
	initialMovementLag = movementLag;
	cpTarget = NULL;
	bTarget = NULL;
	inPosition = false;
	knownType = u->getType();
		done = false;
			firstClicked = NULL;
}
UnitType BaseBuildingSCVTactics::getKnownType() {
	return knownType;
}

void BaseBuildingSCVTactics::move(Position p) {
	/*
	// INSTEAD of moving to p, move to the best location you can see from here to p
	int initPopSize = 512;
	int initPopVariance = 32;
	std::vector<Position> population;
	std::vector<Position> solution;

	// generate population
	for(unsigned int i = 0; i < initPopSize; i++) {
		Position newPosition = p;
		int newX = rand()%initPopVariance;
		int newY = rand()%initPopVariance;
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;
		newPosition = Position(p.x()+newX, p.y()+newY);
		population.push_back(newPosition);
	}

	// find the best member
	Position bestPosition = population.at(0);
	for(unsigned int i = 0; i < initPopSize; i++) {
		Position n = population.at(i);
		if((n.getApproxDistance(p) < bestPosition.getApproxDistance(p)) && element->hasPath(n)) {
			bestPosition = n;
		}
	}
	*/
	element->rightClick(p);

}

void BaseBuildingSCVTactics::move(BaseLocation* p) {
	bTarget = p;
	element->stop();
	element->rightClick(p->getPosition());
}

void BaseBuildingSCVTactics::setMovementLag(int l) {
	initialMovementLag = l;
	movementLagTimer = l;
}
bool BaseBuildingSCVTactics::visited(Chokepoint* cp) {
	if(blacklist.empty()) {
		return false;
	}
	for(unsigned int i = 0; i < blacklist.size(); i++) {
		if(blacklist.at(i)->getCenter() == cp->getCenter()) {
			if(blacklist.at(i)->getWidth() == cp->getWidth()) {
				////////////////////////agentPool->writeDebugMessage("found a blacklisted cp");
				return true;
			}
		}
	}
	return false;
}
bool BaseBuildingSCVTactics::executeTactics() {
	if(firstClicked != NULL) {
		Broodwar->drawCircle(firstClicked->getPosition().x(), firstClicked->getPosition().y(), 8, Colors::Red, true);
	}

	if(done){ 
		return false;
	}
	if(inPosition) {
		std::set<Unit*> s = element->getUnitsInRadius(element->getType().sightRange());
		int enemies = 0;
		for(std::set<Unit*>::const_iterator i = s.begin(); i != s.end(); i++) {
			Unit* cur = *i;
			if(cur->getPlayer() != Broodwar->self() && !cur->getType().isFlyer() && cur->getType().canMove()) {
				enemies++;
				if(!element->isAttacking()) {
					element->stop();
					element->attack(cur);
					return true;
				}
			}
		}
		if(enemies > 0 || element->isAttacking()) {
			return true;
		}

			if(element->getDistance(bTarget->getPosition()) < 100) {
				//////////////////////agentPool->writeDebugMessage("building expansion");
				ConstructionAgent* c = (ConstructionAgent*)agentPool->getAgent("C");
				
				//bool canBuild = element->build(bTarget->getTilePosition(), BWAPI::UnitTypes::Terran_Command_Center);
				bool worker = element->build(bTarget->getTilePosition(), BWAPI::UnitTypes::Terran_Command_Center);;
			//	////Broodwar->sendText(Broodwar->getLastError().toString().c_str());
				if(worker){
					done = true;
				return false;
				} else {
					return true;
				}
			} else {
				move(bTarget->getPosition());
			}
	} else {
		if(bTarget != NULL) {

			Broodwar->drawCircle(CoordinateType::Map, bTarget->getPosition().x(), bTarget->getPosition().y(), 10, Colors::Red, true);
			Broodwar->drawCircle(CoordinateType::Map, element->getPosition().x(), element->getPosition().y(), 10, Colors::Green, true);
			/*
			// see if there are any teleporters to click
			std::set<Unit*> s = element->getUnitsInRadius(300);
			int enemies = 0;
			if(Broodwar->getFrameCount()%512==0) {
				for(std::set<Unit*>::const_iterator i = s.begin(); i != s.end(); i++) {
					Unit* cur = *i;
					if(cur->getType().isMineralField()) {
						if(cur->getResources() > 200 && cur->getResources() <= 250) {
							if(element->getDistance(bTarget->getPosition()) > cur->getDistance(bTarget->getPosition())) {
								teleporters.push_back(cur);
							}
						}

					}
				}
				if(!teleporters.empty()) {
					if(teleporters.back()->getDistance(element) < teleporters.front()->getDistance(element)) {
						std::swap(teleporters.back(), teleporters.front());
					}
				}
			} 
			if(Broodwar->getFrameCount()%128==0) {
				if(!teleporters.empty()) {
					if(!element->getDistance(bTarget->getPosition()) < teleporters.back()->getDistance(bTarget->getPosition())) {
						element->rightClick(teleporters.back());
						teleporters.pop_back();
					}
				}
			}
			*/




			if(!element->isMoving()) {
				element->rightClick(bTarget->getPosition());
			}




		if(bTarget->getPosition().getDistance(element->getPosition()) < 150) {
			inPosition = true;
		}




		}
		
	}
	return true;



	/*
	if(element->getDistance(targetLoc) < 500) {
	if(!element->isConstructing()) {
	element->build((TilePosition)targetLoc, UnitTypes::Terran_Command_Center);
	return true;
	} else {
	if(element->getBuildUnit() != NULL) {
	if(element->getBuildUnit()->getRemainingBuildTime() < 10) {
	return false;
	}
	}
	}
	} else {

	if(!element->isMoving()) {
	element->move(targetLoc);
	}
	return true;
	}

	*/

}

Unit* BaseBuildingSCVTactics::getUnit() {
	return element;
}

