#ifndef ARBITRATOR_H
#define ARBITRATOR_H
#include "GoalTypes.h"
#include "GoalDescriptor.h"
//#include "AgentPool.h"
#include "BidManager.h"
#include <map>
#include <vector>
#include <algorithm>
class AgentPool;

class Arbitrator {

public:

	Arbitrator(AgentPool* p);
	~Arbitrator();

	bool Arbitrator::declareIntention(GoalDescriptor* g);
		bool Arbitrator::canDeclareIntention(int g);
	void Arbitrator::performInitialArbitraton();
	void Arbitrator::appendSubSet(std::vector<GoalDescriptor*> goals);
	void Arbitrator::performArbitraton();
	void Arbitrator::cleanUp();
	std::pair<int,int> Arbitrator::estimateCost(std::vector<GoalDescriptor*> g);
	std::vector<GoalDescriptor*> Arbitrator::getExecutingGoals();
	
	GoalDescriptor* Arbitrator::getWinner();
	GoalDescriptor* winner;

	BidManager* Arbitrator::getBidManager();

	std::vector<GoalDescriptor*> Arbitrator::getActiveGoals();
	std::vector<GoalDescriptor*> Arbitrator::getAchievableGoals();
private:
	void Arbitrator::popGoal(GoalDescriptor* goal);
	void Arbitrator::pushGoal(GoalDescriptor* goal);
	bool isGoalActive(int goal);
	AgentPool* agentPool;
	BidManager* bidManager;
	std::vector<GoalDescriptor*> acceptedGoalSet;
	std::vector<GoalDescriptor*> activeGoalSet;
		std::vector<GoalDescriptor*> achievableGoalsSet;

};



#endif