#include "Arbitrator.h"
#include "AgentPool.h"


Arbitrator::Arbitrator(AgentPool* p) {
	agentPool = p;
	////////////////////////agentPool->writeDebugMessage("arbitrator created");
	winner = NULL;
	bidManager = new BidManager(p);
}
/*
Agent declares its intention to work towards a particular goal.
*/
bool Arbitrator::declareIntention(GoalDescriptor* g){ 
	if(isGoalActive(g->getGoalType())) {
		return false;
	}
	pushGoal(g);
	return true;
}
bool Arbitrator::canDeclareIntention(int g){ 
	if(isGoalActive(g)) {
		return false;
	}
	return true;
}
struct goalComp {
	bool operator()(GoalDescriptor* a, GoalDescriptor* b) const{
		return (a->getGoalPriority() > b->getGoalPriority());
	}

} goalComp_;

BidManager* Arbitrator::getBidManager() {
	return bidManager;
}



void Arbitrator::cleanUp() {
	////////////////////////agentPool->writeDebugMessage("doing cleanup");
	
	for(unsigned int m = 0; m < activeGoalSet.size(); m++) {
		if((activeGoalSet.at(m))->isFinished()) {
			////////////////////////agentPool->writeDebugMessage("\t\t\t\t**** removing goal...");
			////////////////////////agentPool->writeDebugMessage(activeGoalSet.at(m)->getNaturalName());
			activeGoalSet.at(m)->reboot();
				////agentPool->writeDebugMessage("goal");
			activeGoalSet.erase(activeGoalSet.begin()+m);
		}
	}

	if(activeGoalSet.size() > 1) {
		std::sort(activeGoalSet.begin(), activeGoalSet.end(), goalComp_);
	}


}

void Arbitrator::appendSubSet(std::vector<GoalDescriptor*> goals) {
	for(unsigned int i = 0; i < goals.size(); i++) {
		////////////////////////agentPool->writeDebugMessage("\t\t got goal: ");
		////////////////////////agentPool->writeDebugMessage(goals.at(i)->getNaturalName());
		////////////////////////agentPool->writeDebugMessage("\t\t which is: ");
		if(!isGoalActive(goals.at(i)->getGoalType())) {
			activeGoalSet.push_back(goals.at(i));
			////////////////////////agentPool->writeDebugMessage("\t\t not currently active: ");
		} else {
			////////////////////////agentPool->writeDebugMessage("\t\t currently active already ");
		}
	}
}

std::vector<GoalDescriptor*> Arbitrator::getActiveGoals() {
	std::vector<GoalDescriptor*> output;
	for(unsigned int i = 0; i < activeGoalSet.size(); i++) {
		//if(activeGoalSet.at(i)->isActive()) {
			output.push_back(activeGoalSet.at(i));
		//}
	}
	return output;
}

std::vector<GoalDescriptor*> Arbitrator::getExecutingGoals() {
	std::vector<GoalDescriptor*> output;
	for(unsigned int i = 0; i < activeGoalSet.size(); i++) {
		if(activeGoalSet.at(i)->isExecuting()) {
			output.push_back(activeGoalSet.at(i));
		}
	}
	return output;
}

void Arbitrator::performInitialArbitraton() {
	for(unsigned int i = 0; i < activeGoalSet.size(); i++) {
		if(activeGoalSet.at(i)->isFinished()) {
			activeGoalSet.at(i)->reboot();	
		}
	}
	activeGoalSet.clear();
}

void Arbitrator::performArbitraton() {
	////////////agentPool->writeDebugMessage("arbitrating...");
	//cleanUp();
		bidManager->updateDrives();
	int best = -1;
		////////////agentPool->writeDebugMessage("clearing");
	achievableGoalsSet.clear();
		////////////agentPool->writeDebugMessage("sorting");
	if(activeGoalSet.size() > 1) {
		std::sort(activeGoalSet.begin(), activeGoalSet.end(), goalComp_);
	}

	// might need to also sort the goal set by priority, but do that later
	////////////agentPool->writeDebugMessage("considering...");
	for(unsigned int i = 0; i < activeGoalSet.size(); i++) {
		////////////agentPool->writeDebugMessage(activeGoalSet.at(i)->getNaturalName());
		if(!activeGoalSet.at(i)->isExecuting() && activeGoalSet.at(i)->getInhibitionStatus() == false) {
			////////////////////////agentPool->writeDebugMessage("not executing");
			int curMinerals = BWAPI::Broodwar->self()->minerals();
			int curGas = BWAPI::Broodwar->self()->gas();
			
			//if(bidManager->canWithdraw(activeGoalSet.at(i)->getMineralCost(), 
			//	activeGoalSet.at(i)->getGasCost(), activeGoalSet.at(i)->getGoalPriority())) {

				achievableGoalsSet.push_back(activeGoalSet.at(i));

			//	activeGoalSet.at(i)->reserveResources();
				std::pair<int,int> costEstimate = estimateCost(achievableGoalsSet);
				if(costEstimate.first <= (curMinerals-bidManager->getReservedMinerals()) && costEstimate.second <= (curGas-bidManager->getReservedGas())) {
					
				} else {
					achievableGoalsSet.pop_back();
					//activeGoalSet.at(i)->reset();
						////agentPool->writeDebugMessage("gaol 2");
					activeGoalSet.erase(activeGoalSet.begin()+i);
				}
			//} else {
			//			////////////////////////agentPool->writeDebugMessage("couldn't afford");
			//			////////////////////////agentPool->writeDebugMessage(bidManager->getReservedMinerals());
			//			////////////////////////agentPool->writeDebugMessage(bidManager->getReservedGas());

			//}
			
			
			
			
			/*
			
			int curMinerals = BWAPI::Broodwar->self()->minerals();
			int curGas = BWAPI::Broodwar->self()->gas();

			if(activeGoalSet.at(i)->getGoalType() == OFFENSE_GASSTEAL) {
				////////////////////////agentPool->writeDebugMessage("considering gas steal");
			}
			std::pair<int,int> costEstimate = estimateCost(achievableGoalsSet);
			////////////////////////agentPool->writeDebugMessage("mineral estimate: ");
			////////////////////////agentPool->writeDebugMessage((int)costEstimate.first);
			////////////////////////agentPool->writeDebugMessage("cur mins: ");
			////////////////////////agentPool->writeDebugMessage((int)curMinerals);
			////////////////////////agentPool->writeDebugMessage("gas estimate: ");
			////////////////////////agentPool->writeDebugMessage((int)costEstimate.second);
			////////////////////////agentPool->writeDebugMessage("cur gas: ");
			////////////////////////agentPool->writeDebugMessage((int)curGas);
			//if(costEstimate.first <= curMinerals && (curMinerals-costEstimate.first) >= 0 && costEstimate.second <= curGas && (curGas-costEstimate.second) >= 0) {
		//	if(costEstimate.first <= curMinerals && costEstimate.second <= curGas) {

				if(!activeGoalSet.at(i)->isActive() && !activeGoalSet.at(i)->isExecuting()) {


				if(bidManager->canWithdraw(activeGoalSet.at(i)->getMineralCost(), 
					activeGoalSet.at(i)->getGasCost(), 
					activeGoalSet.at(i)->getGoalPriority())) {

					activeGoalSet.at(i)->activate();
					
					if(activeGoalSet.at(i)->getGoalType() == OFFENSE_GASSTEAL) {
							////////////////////////agentPool->writeDebugMessage("gas steal active and ready to be executeds");
					}

					} else {
						//	if(activeGoalSet.at(i)->getGoalType() == OFFENSE_GASSTEAL) {
								////////////////////////agentPool->writeDebugMessage("abandoning: ");
								////////////////////////agentPool->writeDebugMessage(activeGoalSet.at(i)->getNaturalName());
							//}
						// not sure about this
						activeGoalSet.at(i)->reboot();
							////////////////////////agentPool->writeDebugMessage("erasing: ");
							////////////////////////agentPool->writeDebugMessage((int)activeGoalSet.size());
						activeGoalSet.erase(activeGoalSet.begin()+i);
								////////////////////////agentPool->writeDebugMessage((int)activeGoalSet.size());
						//activeGoalSet.at(i)->retry();
						achievableGoalsSet.pop_back();
					}
				}


			//} else {
			//	achievableGoalsSet.pop_back();
				//activeGoalSet.at(i)->retry();
				
				
			//}
		}
		*/
	} else {
				////////////////////////agentPool->writeDebugMessage("is executing");
		}
	if(!achievableGoalsSet.empty()) {
		std::sort(achievableGoalsSet.begin(), achievableGoalsSet.end(), goalComp_);
	}
}
}
std::pair<int,int> Arbitrator::estimateCost(std::vector<GoalDescriptor*> g) {
	// just check mineral costs for now, do gas later
	std::pair<int,int> cost;
			cost.first = 0;
			cost.second = 0;
	for(unsigned int i = 0; i < g.size(); i++) {
		cost.first += g.at(i)->getMineralCost();
		cost.second += g.at(i)->getGasCost();
	}
	return cost;
}

	std::vector<GoalDescriptor*> Arbitrator::getAchievableGoals() {
		return achievableGoalsSet;
	}

bool Arbitrator::isGoalActive(int goalType) {
	for(unsigned int i = 0; i < activeGoalSet.size(); i++) {
		if(activeGoalSet.at(i)->getGoalType() == goalType) {
			return true;
		}
	}
	return false;
}

void Arbitrator::popGoal(GoalDescriptor* g) {
	for(unsigned int i = 0; i < activeGoalSet.size(); i++) {
		if(activeGoalSet.at(i)->getGoalType() == g->getGoalType()) {
				////agentPool->writeDebugMessage("deffffs");
			activeGoalSet.erase(activeGoalSet.begin()+i);
		}
	}
}

void Arbitrator::pushGoal(GoalDescriptor* g) {
	activeGoalSet.push_back(g);
}