#ifndef AGENTPOOL_H
#define AGENTPOOL_H
#include <map>
#include <iostream>
#include <fstream>
#include "AgentBase.h"
#include <BWAPI.h>
#include "SquadPool.h"
#include "Arbitrator.h"
#include "InformationManagerAgent.h"
#include "ScoutManagerAgent.h"

using namespace BWAPI;


class ExecutionCommanderAgent;
class SquadReccomender;

class AgentPool {
public:
	AgentPool();
	~AgentPool();
	void AgentPool::writeDebugMessage(char message[]);
	void AgentPool::writeDebugMessage(std::string message);
	void AgentPool::writeDebugMessage(int message);
	void AgentPool::writeDebugMessage(float message);
	void AgentPool::writeDebugMessage(std::string message, std::string target);
	void AgentPool::writeDebugMessage(std::vector<GoalDescriptor*> messages, std::string target);
	void AgentPool::writeDebugMessage(int message, std::string target);

	AgentBase* AgentPool::getAgent(std::string name);
	Unit* AgentPool::getCurrentPrimaryBase();
	void AgentPool::setCurrentPrimaryBase(Unit* mb);
	SquadReccomender* getSquadReccomender();
	SquadPool* AgentPool::getSquads();
	void AgentPool::updateAgentDrives();
	Arbitrator* AgentPool::getArbitrator();
	void AgentPool::registerGoal(GoalDescriptor* g);
	GoalDescriptor* AgentPool::getRegisteredGoal(int id);

	bool launched;
	std::ofstream output;

private:
	std::map<std::string, AgentBase*> pool;
	void AgentPool::setUpDebugFile();
	std::map<int, GoalDescriptor*> goalMonitor;
	

	SquadPool* squads;
	Unit* primaryBase;
	bool baseFound;
	bool alternatingFrame;
	bool barracks;
	Arbitrator* arbitrator;
	ExecutionCommanderAgent* executor;
	SquadReccomender* sqr;
};
#endif