#include "AgentPool.h"
#include "ConstructionAgent.h"
#include "ResourceManagerAgent.h"
#include "MilitaryStructureManagerAgent.h"
#include "MilitaryProductionManagerAgent.h"
#include "SquadPool.h"
#include "ExecutionCommanderAgent.h"
#include "BaseDefenseManagerAgent.h"
#include "TrainingManagerAgent.h"
#include "SquadManagerAgent.h"
#include "OffensiveTacticsManagerAgent.h"
#include "ResearchManagerAgent.h"
#include "SquadReccomender.h"
#include <ctime>
#include "ThreatAwarePathfinder.h"
bool logging = false;

std::vector<TilePosition> apath;
bool pathing = true;
ThreatAwarePathFinder* pf;
AgentPool::AgentPool() {
	srand(time(0));
	setUpDebugFile();
	launched = false;
	alternatingFrame = false;
	writeDebugMessage("--- Agent Pool Initializing ---");
	squads = new SquadPool();
	writeDebugMessage("--- made squads ---");
	arbitrator = new Arbitrator(this);
	writeDebugMessage("--- made arbitrator ---");
	barracks = false;
	baseFound = false;
	executor = new ExecutionCommanderAgent(this);
	sqr = new SquadReccomender(this);

	writeDebugMessage("\t\t*** looking for first base... ***");
	for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
	{
		if ((*i)->getType() == Broodwar->self()->getRace().getCenter() && (*i)->getPlayer()->getID() == Broodwar->self()->getID())
		{
			writeDebugMessage("\t\t*** found it! ***");

			primaryBase = *i;
			baseFound = true;

		}
	}

	pool["PI"] = new InformationManagerAgent(this);
	writeDebugMessage("\t\t*** player information agent built ***");
	pool["C"] = new ConstructionAgent(this);
	writeDebugMessage("\t\t*** construction agent built ***");
	pool["R"] = new ResourceManagerAgent(this);
	writeDebugMessage("\t\t*** resource agent built ***");
	pool["MS"] = new MilitaryStructureManagerAgent(this);
	writeDebugMessage("\t\t*** military structure agent built ***");
	pool["T"] = new TrainingManagerAgent(this);
	writeDebugMessage("\t\t*** training agent built ***");
	pool["EI"] = new InformationManagerAgent(this);
	writeDebugMessage("\t\t*** enemy information agent built ***");
	pool["S"] = new ScoutManagerAgent(this);
	writeDebugMessage("\t\t*** scouting agent built ***");
	pool["MP"] = new MilitaryProductionManagerAgent(this);
	writeDebugMessage("\t\t*** scouting agent built ***");
	pool["O"] = new OffensiveTacticsManagerAgent(this);
	writeDebugMessage("\t\t*** offensitve tactics manager agent built ***");
	pool["SQ"] = new SquadManagerAgent(this, squads);
	writeDebugMessage("\t\t*** squad manager agent built ***");
	pool["RE"] = new ResearchManagerAgent(this);
	writeDebugMessage("\t\t*** research manager agent built ***");
	pool["BD"] = new BaseDefenseManagerAgent(this);
	writeDebugMessage("\t\t*** research manager agent built ***");
	writeDebugMessage("--- setting up scout ---");
	Unit* initialScout = squads->getSquadByName("workers")->getUnitAt(0);
	initialScout->stop();
	((ScoutManagerAgent*)pool["S"])->recruitScout(initialScout, squads->getSquadByName("workers"));

	writeDebugMessage("--- setting up teleporter users tactics ---");
	((SquadManagerAgent*)pool["SQ"])->recruitSquad(getSquads()->getSquadByName("teleporterusers"), 5);

	writeDebugMessage("--- setting up air support squad tactics ---");
	((SquadManagerAgent*)pool["SQ"])->recruitSquad(getSquads()->getSquadByName("wraithsquadron"), 1);

	writeDebugMessage("--- setting up vulture support squad tactics ---");
	((SquadManagerAgent*)pool["SQ"])->recruitSquad(getSquads()->getSquadByName("vulturesquadron"), 4);

	writeDebugMessage("--- setting up marine support squad tactics ---");
	((SquadManagerAgent*)pool["SQ"])->recruitSquad(getSquads()->getSquadByName("marinesupport"), 4);

	writeDebugMessage("--- setting up air support squad tactics ---");
	((SquadManagerAgent*)pool["SQ"])->recruitSquad(getSquads()->getSquadByName("valkyriesquadron"), 2);

	writeDebugMessage("--- setting up dropship squad tactics ---");
	((SquadManagerAgent*)pool["SQ"])->recruitSquad(getSquads()->getSquadByName("dropshipsquadron"), 3);

	writeDebugMessage("--- setting up temporary working squad ---");
	((SquadManagerAgent*)pool["SQ"])->recruitSquad(getSquads()->getSquadByName("temp"), 9000);
	InformationManagerAgent* ei = (InformationManagerAgent*)pool["PI"];
	pf = new ThreatAwarePathFinder(ei, this);
	writeDebugMessage("found path of: ");
	writeDebugMessage((int)apath.size());
	writeDebugMessage("size");

	writeDebugMessage("--- Agent Pool Initialized ---");

}

void AgentPool::setUpDebugFile() {
	if(!logging) return;
	std::ofstream output;
	char message[] = "-- Debug File Begin -- \n";
	output.open("C:\\quorumdebugger\\QuorumDebugMessages.txt",std::ios::ate);
	output.write(message, strlen(message));
	output.close();
}

void AgentPool::writeDebugMessage(char message[]) {
	if(!logging) return;
	std::ofstream output;
	output.open("C:\\quorumdebugger\\QuorumDebugMessages.txt",std::ios::app);
	output.write(message, strlen(message));
	output.write("\n", strlen("\n"));
	output.close();

}

void AgentPool::setCurrentPrimaryBase(Unit* mb) {
	primaryBase = mb;
}

void AgentPool::registerGoal(GoalDescriptor* g) {
	goalMonitor[g->getGoalType()] = g;
}

GoalDescriptor* AgentPool::getRegisteredGoal(int id) {
	return goalMonitor[id];
}
void AgentPool::writeDebugMessage(std::string message, std::string target) {
	if(!logging) return;
	std::ofstream output;
	output.open(target.c_str(), std::ios::app);
	output << message;
	output.write("\n", strlen("\n"));
	output.write("\n", strlen("\n"));
	output.close();
}

void AgentPool::writeDebugMessage(std::vector<GoalDescriptor*> messages, std::string target) {
	if(!logging) return;
	std::ofstream output;
	output.open(target.c_str(), std::ios::trunc);
	for(unsigned int i = 0; i < messages.size(); i++) {
		output << messages.at(i)->getNaturalName();
		output.write("\n", strlen("\n"));
	}

	output.close();
}
void AgentPool::writeDebugMessage(std::string message) {
	if(!logging) return;
	std::ofstream output;
	output.open("C:\\quorumdebugger\\QuorumDebugMessages.txt",std::ios::app);
	output << message;
	output.write("\n", strlen("\n"));
	output.close();

}
void AgentPool::writeDebugMessage(int message, std::string target) {
	if(!logging) return;
	std::ofstream output;
	output.open(target.c_str(), std::ios::app);
	output << message;
	output.write("\n", strlen("\n"));
	output.write("\n", strlen("\n"));
	output.close();
}

void AgentPool::writeDebugMessage(int message) {
	if(!logging) return;
	std::ofstream output;
	output.open("C:\\quorumdebugger\\QuorumDebugMessages.txt",std::ios::app);
	output << message;
	output.write("\n", strlen("\n"));
	output.close();

}

void AgentPool::writeDebugMessage(float message) {
	if(!logging) return;
	std::ofstream output;
	output.open("C:\\quorumdebugger\\QuorumDebugMessages.txt",std::ios::app);
	output << message;
	output.write("\n", strlen("\n"));
	output.close();

}

Arbitrator* AgentPool::getArbitrator() {
	return arbitrator;
}

AgentBase* AgentPool::getAgent(std::string name) {
	return pool[name];
}

SquadPool* AgentPool::getSquads() {
	return squads;
}

Unit* AgentPool::getCurrentPrimaryBase() {
	return primaryBase;
}

void AgentPool::updateAgentDrives() {
	if(!launched || Broodwar->isPaused()) {
		return;
	} else {

	}
	InformationManagerAgent* ei = (InformationManagerAgent*)pool["EI"];

	//writeDebugMessage("***************** begin agents *****************");
	pool["PI"]->updateDrives();
	//writeDebugMessage(".0.");
	pool["R"]->updateDrives();
//	writeDebugMessage(".1.");
	pool["MS"]->updateDrives();
//	writeDebugMessage(".2.");
	pool["C"]->updateDrives();
	//writeDebugMessage(".3.");
	pool["S"]->updateDrives();
	//writeDebugMessage(".4.");
	pool["MP"]->updateDrives();
	//writeDebugMessage(".5.");
	pool["O"]->updateDrives();
	//writeDebugMessage(".6.");
	pool["SQ"]->updateDrives();
	//writeDebugMessage(".7.");
	pool["RE"]->updateDrives();
	//writeDebugMessage(".8.");
	pool["EI"]->updateDrives();
	//writeDebugMessage(".9.");
	pool["BD"]->updateDrives();
	//writeDebugMessage(".10.");

	arbitrator->cleanUp();
	//writeDebugMessage("appended");
	arbitrator->performArbitraton();
	//writeDebugMessage("arbitrated");
	if(!arbitrator->getAchievableGoals().empty()) {
		//writeDebugMessage("conveyed");
		executor->execute(arbitrator->getAchievableGoals());
	}
	//writeDebugMessage("***************** end agents *****************");


}

SquadReccomender* AgentPool::getSquadReccomender()
{
	return sqr;
}

