#pragma once
#include "Common.h"
#include "InformationManager.h"
#include "State.h"

class StrategyManager;

//------------------------------------------------------------------------
//  Execute 1 Factory ...
//------------------------------------------------------------------------
class OneFactory : public State<StrategyManager>
{
private:
	OneFactory() { _name = "1 Factory ..."; }
	OneFactory(const OneFactory&);
	OneFactory& operator=(const OneFactory&);
public:
	static OneFactory* Instance();
	virtual void Enter(StrategyManager* strategyManager);
	virtual void Execute(StrategyManager* strategyManager);
	virtual void Exit(StrategyManager* strategyManager);
};

//------------------------------------------------------------------------
//  Execute 2 Factories Rush Defense
//------------------------------------------------------------------------
class RushDefense : public State<StrategyManager>
{
private:
	RushDefense(){ _name = "2 Factories Rush Defense"; }
	RushDefense(const RushDefense&);
	RushDefense& operator=(const RushDefense&);
public:
	static RushDefense* Instance();
	virtual void Enter(StrategyManager* strategyManager);
	virtual void Execute(StrategyManager* strategyManager);
	virtual void Exit(StrategyManager* strategyManager);
};

//------------------------------------------------------------------------
//  Execute 1 Factory Fast Expand Opening
//------------------------------------------------------------------------
class OneFactoryFastExpand : public State<StrategyManager>
{
private:
	OneFactoryFastExpand(){ _name = "1 Factory Fast Expand Opening"; }
	OneFactoryFastExpand(const OneFactoryFastExpand&);
	OneFactoryFastExpand& operator=(const OneFactoryFastExpand&);
public:
	static OneFactoryFastExpand* Instance();
	virtual void Enter(StrategyManager* strategyManager);
	virtual void Execute(StrategyManager* strategyManager);
	virtual void Exit(StrategyManager* strategyManager);
};

//------------------------------------------------------------------------
//  Execute 3 Factories
//------------------------------------------------------------------------
class ThreeFactories : public State<StrategyManager>
{
private:
	ThreeFactories(){ _name = "3 Factories"; }
	ThreeFactories(const ThreeFactories&);
	ThreeFactories& operator=(const ThreeFactories&);
public:
	static ThreeFactories* Instance();
	virtual void Enter(StrategyManager* strategyManager);
	virtual void Execute(StrategyManager* strategyManager);
	virtual void Exit(StrategyManager* strategyManager);
};

//**************************
//     ZERG STRATEGIES
//**************************

//------------------------------------------------------------------------
//  Execute 2 Port Wraith
//------------------------------------------------------------------------
class TwoPortWraith : public State<StrategyManager>
{
private:
	TwoPortWraith() { _name = "2 Port Wraith"; }
	TwoPortWraith(const TwoPortWraith&);
	TwoPortWraith& operator=(const TwoPortWraith&);
public:
	static TwoPortWraith* Instance();
	virtual void Enter(StrategyManager* strategyManager);
	virtual void Execute(StrategyManager* strategyManager);
	virtual void Exit(StrategyManager* strategyManager);
};

//------------------------------------------------------------------------
//  Execute 1 Barracks Fast Expansion
//------------------------------------------------------------------------
class OneRaxFE : public State<StrategyManager>
{
private:
	OneRaxFE() { _name = "1 Barracks Fast Expansion"; }
	OneRaxFE(const OneRaxFE&);
	OneRaxFE& operator=(const OneRaxFE&);
public:
	static OneRaxFE* Instance();
	virtual void Enter(StrategyManager* strategyManager);
	virtual void Execute(StrategyManager* strategyManager);
	virtual void Exit(StrategyManager* strategyManager);
};

//**************************
//    PROTOSS STRATEGIES
//**************************

//------------------------------------------------------------------------
//  Execute 2 Fact Vult/Mines
//------------------------------------------------------------------------
class TwoFactMines : public State<StrategyManager>
{
private:
	TwoFactMines() { _name = "2 Fact Vult/Mines"; }
	TwoFactMines(const TwoFactMines&);
	TwoFactMines& operator=(const TwoFactMines&);
public:
	static TwoFactMines* Instance();
	virtual void Enter(StrategyManager* strategyManager);
	virtual void Execute(StrategyManager* strategyManager);
	virtual void Exit(StrategyManager* strategyManager);
};

//------------------------------------------------------------------------
//  Execute Tank transition
//------------------------------------------------------------------------
class TankTransition : public State<StrategyManager>
{
private:
	TankTransition() { _name = "Tank transition"; }
	TankTransition(const TankTransition&);
	TankTransition& operator=(const TankTransition&);
public:
	static TankTransition* Instance();
	virtual void Enter(StrategyManager* strategyManager);
	virtual void Execute(StrategyManager* strategyManager);
	virtual void Exit(StrategyManager* strategyManager);
};

//------------------------------------------------------------------------
//  Execute Full tank
//------------------------------------------------------------------------
class FullTank : public State<StrategyManager>
{
private:
	FullTank() { _name = "Full tank"; }
	FullTank(const FullTank&);
	FullTank& operator=(const FullTank&);
public:
	static FullTank* Instance();
	virtual void Enter(StrategyManager* strategyManager);
	virtual void Execute(StrategyManager* strategyManager);
	virtual void Exit(StrategyManager* strategyManager);
};