#include "StrategyVsTerran.h"
#include "StrategyManager.h"
#include "BuildManager.h"
#include "SquadManager.h"
#include "WorkerManager.h"

using namespace BWAPI;

//------------------------------------------------------------------------
// Methods for 1Factory
//------------------------------------------------------------------------

OneFactory* OneFactory::Instance()
{
	static OneFactory instance;
	return &instance;
}

void OneFactory::Enter(StrategyManager* strategyManager)
{  
	informationManager->buildRequest(UnitTypes::Terran_Supply_Depot);
	informationManager->buildRequest(UnitTypes::Terran_Barracks);
	informationManager->buildRequest(UnitTypes::Terran_Refinery);
	informationManager->buildRequest(UnitTypes::Terran_Supply_Depot);
	informationManager->buildRequest(UnitTypes::Terran_Factory);

	informationManager->_retreatDisabled = true;
}


void OneFactory::Execute(StrategyManager* strategyManager)
{
// 	if (workerManager->workersDefending() && Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Marine)==0) {
// 		informationManager->_trainOrder[UnitTypes::Terran_Barracks] = UnitTypes::Terran_Marine;
// 	} else {
// 		informationManager->_trainOrder[UnitTypes::Terran_Barracks] = UnitTypes::None;
// 	}

	// After place first factory, decide to prepare rush defenses or keep going
	if ( Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Factory) == 1) {
		int enemyBarracks = 0;
		for(UnitToTypeMap::const_iterator enemy=informationManager->_enemiesType.begin();enemy!=informationManager->_enemiesType.end();++enemy) {
			if (enemy->second == UnitTypes::Terran_Barracks) enemyBarracks++;
		}

		if (enemyBarracks == 1) { // All goes right
			strategyManager->GetFSM()->ChangeState(OneFactoryFastExpand::Instance());  
		} else { // prepare for coming rush
			strategyManager->GetFSM()->ChangeState(RushDefense::Instance()); 
		}
	}
}


void OneFactory::Exit(StrategyManager* strategyManager)
{
	//informationManager->_trainOrder[UnitTypes::Terran_Barracks] = UnitTypes::None;
}

//------------------------------------------------------------------------
// Methods for 2 Factories Rush Defense
//------------------------------------------------------------------------

RushDefense* RushDefense::Instance()
{
	static RushDefense instance;
	return &instance;
}

void RushDefense::Enter(StrategyManager* strategyManager)
{  
	informationManager->buildRequest(UnitTypes::Terran_Factory);
	informationManager->buildRequest(UnitTypes::Terran_Supply_Depot);
	informationManager->buildRequest(UnitTypes::Terran_Supply_Depot);
	informationManager->_percentList[UnitTypes::Terran_Vulture] = 100;
}


void RushDefense::Execute(StrategyManager* strategyManager)
{
	if (Broodwar->enemy()->getRace() == Races::Protoss && Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Vulture) == 4) {
		informationManager->researchRequest(TechTypes::Spider_Mines);
		//informationManager->upgradeRequest(UpgradeTypes::Ion_Thrusters);
	}

	if ( Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Vulture) == 8 || Broodwar->enemy()->visibleUnitCount(UnitTypes::Terran_Siege_Tank_Tank_Mode) > 0) {
		strategyManager->GetFSM()->ChangeState(ThreeFactories::Instance());      
	}
}


void RushDefense::Exit(StrategyManager* strategyManager)
{
	informationManager->researchRequest(TechTypes::Tank_Siege_Mode);
	informationManager->naturalExpandRequest();
	if (Broodwar->enemy()->getRace() == Races::Protoss) {
		informationManager->_percentList[UnitTypes::Terran_Vulture] = 25;
		informationManager->_percentList[UnitTypes::Terran_Siege_Tank_Tank_Mode] = 75;
	} else {
		informationManager->_percentList[UnitTypes::Terran_Siege_Tank_Tank_Mode] = 100;
	}
}

//------------------------------------------------------------------------
// Methods for 1FactoryFastExpand
//------------------------------------------------------------------------

OneFactoryFastExpand* OneFactoryFastExpand::Instance()
{
	static OneFactoryFastExpand instance;
	return &instance;
}

void OneFactoryFastExpand::Enter(StrategyManager* strategyManager)
{  
	informationManager->buildRequest(UnitTypes::Terran_Machine_Shop);
	informationManager->researchRequest(TechTypes::Tank_Siege_Mode);
	informationManager->buildRequest(UnitTypes::Terran_Supply_Depot);
	informationManager->naturalExpandRequest();
	informationManager->buildRequest(UnitTypes::Terran_Supply_Depot);
	informationManager->buildRequest(UnitTypes::Terran_Factory);
	informationManager->upgradeRequest(UpgradeTypes::Terran_Vehicle_Weapons, 1);
	informationManager->_percentList[UnitTypes::Terran_Siege_Tank_Tank_Mode] = 100;
	informationManager->_autoVehicleUpgrade = true;
}


void OneFactoryFastExpand::Execute(StrategyManager* strategyManager)
{
	if ( Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Siege_Tank_Tank_Mode)+Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Goliath) == 4 ) {
		strategyManager->GetFSM()->ChangeState(ThreeFactories::Instance());      
	}

	if (Broodwar->enemy()->visibleUnitCount(UnitTypes::Terran_Marine) > 2) {
		informationManager->_trainOrder[UnitTypes::Terran_Factory] = UnitTypes::Terran_Vulture;
	} else if (informationManager->_trainOrder[UnitTypes::Terran_Factory] == UnitTypes::Terran_Vulture) {
		informationManager->_trainOrder[UnitTypes::Terran_Starport] = UnitTypes::Terran_Siege_Tank_Tank_Mode;
	}
}


void OneFactoryFastExpand::Exit(StrategyManager* strategyManager)
{
	
}

//------------------------------------------------------------------------
// Methods for 3Factories
//------------------------------------------------------------------------

ThreeFactories* ThreeFactories::Instance()
{
	static ThreeFactories instance;
	return &instance;
}

void ThreeFactories::Enter(StrategyManager* strategyManager)
{  
	informationManager->_autoBuildSuplies = true;
	if (informationManager->getGasExpandPosition() != TilePositions::None) {
		informationManager->buildRequest(UnitTypes::Terran_Factory);
		informationManager->gasExpandRequest();
		informationManager->buildRequest(UnitTypes::Terran_Factory);
		informationManager->buildRequest(UnitTypes::Terran_Factory);

		informationManager->upgradeRequest(UpgradeTypes::Terran_Vehicle_Weapons, 3);
		informationManager->upgradeRequest(UpgradeTypes::Terran_Vehicle_Plating, 3);
		informationManager->_autoVehicleUpgrade = true;

		informationManager->buildRequest(UnitTypes::Terran_Armory); // second armory

// 		informationManager->buildRequest(UnitTypes::Terran_Starport, true);
// 		informationManager->researchRequest(TechTypes::Cloaking_Field);
// 		informationManager->_trainOrder[UnitTypes::Terran_Starport] = UnitTypes::Terran_Wraith;
	}
}


void ThreeFactories::Execute(StrategyManager* strategyManager)
{
	// auto expand
	if (!buildManager->alreadyBuilding(UnitTypes::Terran_Command_Center) && !workerManager->needWorkers()) {
		if ( ( informationManager->minerals() > 1000 || (informationManager->minerals() > 500 && informationManager->gas() < 100) ) &&
			informationManager->getGasExpandPosition() != TilePositions::None ) {
				informationManager->gasExpandRequest(true);
		}
		if (informationManager->minerals()*2 < informationManager->gas() &&
			informationManager->getNaturalExpandPosition() != TilePositions::None)  {
				informationManager->naturalExpandRequest(true);
		}
	}

	// check marine late rush
	if ( informationManager->_ourBases.size() == 2 && Broodwar->enemy()->visibleUnitCount(UnitTypes::Terran_Marine) > 2) {
		informationManager->_trainOrder[UnitTypes::Terran_Factory] = UnitTypes::Terran_Vulture;
	}
	
	// check air enemy force
	if (Broodwar->enemy()->getRace() == Races::Terran) {   // *************** TERRAN RULES ****************************************************
		if (informationManager->_enemyTurrets == 0 && (informationManager->_enemyScienceVessel == 0 || informationManager->_enemyAirDPS < 1) ) {
			informationManager->buildRequest(UnitTypes::Terran_Starport, true);
			informationManager->researchRequest(TechTypes::Cloaking_Field);
			informationManager->_trainOrder[UnitTypes::Terran_Starport] = UnitTypes::Terran_Wraith;
		} else {
			informationManager->_trainOrder[UnitTypes::Terran_Starport] = UnitTypes::None;
		}
	} else if (Broodwar->enemy()->getRace() == Races::Protoss) { // *************** PROTOSS RULES ****************************************************
		if (informationManager->_enemyPhotonCanon == 0 && (informationManager->_enemyObserver == 0 || informationManager->_enemyAirDPS < 1) ) {
			informationManager->buildRequest(UnitTypes::Terran_Starport, true);
			informationManager->researchRequest(TechTypes::Cloaking_Field);
			informationManager->_trainOrder[UnitTypes::Terran_Starport] = UnitTypes::Terran_Wraith;
		} else {
			informationManager->_trainOrder[UnitTypes::Terran_Starport] = UnitTypes::None;
		}
	}


	// Have 4 Dropship in total
	/*if (Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Factory) >= 5) {
		if (Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Dropship) < 4) {
			informationManager->checkRequirements(UnitTypes::Terran_Dropship);
			informationManager->_trainOrder[UnitTypes::Terran_Starport] = UnitTypes::Terran_Dropship;   
		} else if (informationManager->_trainOrder[UnitTypes::Terran_Starport] == UnitTypes::Terran_Dropship) {
			informationManager->_trainOrder[UnitTypes::Terran_Starport] = UnitTypes::None;  
		}
	}*/



	// if enemy all mecha, produce Ghosts
// 	if (informationManager->_enemyMarines < 4 && informationManager->_enemyFirebats < 4 &&
// 		informationManager->_ghosts < 4) {
// 		// Check needed buildings
// 		informationManager->buildRequest(UnitTypes::Terran_Starport, true);
// 		informationManager->buildRequest(UnitTypes::Terran_Science_Facility, true);
// 		informationManager->buildRequest(UnitTypes::Terran_Covert_Ops, true);
// 		// Research
// 		informationManager->researchRequest(TechTypes::Lockdown);
// 		informationManager->upgradeRequest(UpgradeTypes::Ocular_Implants);
// 		informationManager->researchRequest(TechTypes::Personnel_Cloaking);
// 		if (Broodwar->self()->hasResearched(TechTypes::Lockdown)) {
// 			informationManager->_trainOrder[UnitTypes::Terran_Barracks] = UnitTypes::Terran_Ghost;
// 		}
// 	} else {
// 		informationManager->_trainOrder[UnitTypes::Terran_Barracks] = UnitTypes::None;
// 	}

}


void ThreeFactories::Exit(StrategyManager* strategyManager)
{

}

//------------------------------------------------------------------------
// Methods for 2 Port Wraith
//------------------------------------------------------------------------

TwoPortWraith* TwoPortWraith::Instance()
{
	static TwoPortWraith instance;
	return &instance;
}

void TwoPortWraith::Enter(StrategyManager* strategyManager)
{  
	informationManager->buildRequest(UnitTypes::Terran_Supply_Depot);
	informationManager->buildRequest(UnitTypes::Terran_Barracks);
	informationManager->buildRequest(UnitTypes::Terran_Refinery);
	informationManager->buildRequest(UnitTypes::Terran_Supply_Depot);
	informationManager->buildRequest(UnitTypes::Terran_Factory);
	informationManager->buildRequest(UnitTypes::Terran_Starport);
	informationManager->buildRequest(UnitTypes::Terran_Starport);
	informationManager->buildRequest(UnitTypes::Terran_Supply_Depot);
	informationManager->buildRequest(UnitTypes::Terran_Supply_Depot);

	informationManager->_percentList[UnitTypes::Terran_Vulture] = 100;
	informationManager->_percentList[UnitTypes::Terran_Wraith] = 100;

	informationManager->upgradeRequest(UpgradeTypes::Ion_Thrusters);
	informationManager->upgradeRequest(UpgradeTypes::Terran_Ship_Plating, 3);
	informationManager->_autoShipUpgrade = true;
	informationManager->researchRequest(TechTypes::Cloaking_Field);
}


void TwoPortWraith::Execute(StrategyManager* strategyManager)
{
	// auto expand
	if (Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Supply_Depot) >= 4) {
		if (!buildManager->alreadyBuilding(UnitTypes::Terran_Command_Center) && 
			( informationManager->minerals() > 1000 || (informationManager->minerals() > 500 && informationManager->gas() < 100) ) &&
			informationManager->getGasExpandPosition() != TilePositions::None ) {
				informationManager->gasExpandRequest(true);
		}
		if (!buildManager->alreadyBuilding(UnitTypes::Terran_Command_Center) && informationManager->minerals()*2 < informationManager->gas() &&
			informationManager->getNaturalExpandPosition() != TilePositions::None)  {
				informationManager->naturalExpandRequest(true);
		}
	}
}


void TwoPortWraith::Exit(StrategyManager* strategyManager)
{

}


//------------------------------------------------------------------------
// Methods for 1 Barracks Fast Expansion
//------------------------------------------------------------------------

OneRaxFE* OneRaxFE::Instance()
{
	static OneRaxFE instance;
	return &instance;
}

void OneRaxFE::Enter(StrategyManager* strategyManager)
{  
	informationManager->buildRequest(UnitTypes::Terran_Supply_Depot);
	informationManager->buildRequest(UnitTypes::Terran_Barracks);
	informationManager->buildRequest(UnitTypes::Terran_Barracks);
	informationManager->buildRequest(UnitTypes::Terran_Refinery);
	informationManager->buildRequest(UnitTypes::Terran_Supply_Depot);
	informationManager->buildRequest(UnitTypes::Terran_Academy);

	
	informationManager->_percentList[UnitTypes::Terran_Medic] = 20;
	informationManager->_percentList[UnitTypes::Terran_Marine] = 80;
	informationManager->researchRequest(TechTypes::Stim_Packs);
	//informationManager->researchRequest(TechTypes::Optical_Flare);
	informationManager->upgradeRequest(UpgradeTypes::U_238_Shells);
	informationManager->upgradeRequest(UpgradeTypes::Terran_Infantry_Weapons);
	//informationManager->buildRequest(UnitTypes::Terran_Comsat_Station, true);

	informationManager->_priorCommandCenters = false;
	informationManager->_autoBuildSuplies = true;
	informationManager->_minSquadSize = 8;
	informationManager->_autoInfanteryUpgrade = true;
}


void OneRaxFE::Execute(StrategyManager* strategyManager)
{
	// auto expand
	if (Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Academy) >= 1) {
		if (!buildManager->alreadyBuilding(UnitTypes::Terran_Command_Center) && !workerManager->needWorkers()) {
			if ( (informationManager->minerals() > 1000 || (informationManager->minerals() > 500 && informationManager->gas() < 100) ) &&
				informationManager->getGasExpandPosition() != TilePositions::None ) {
					informationManager->gasExpandRequest(true);
			}
			if (informationManager->minerals()*2 < informationManager->gas() &&
				informationManager->getNaturalExpandPosition() != TilePositions::None)  {
					informationManager->naturalExpandRequest(true);
			}
		}
	}

	// check upgrades
	if (Broodwar->self()->getUpgradeLevel(UpgradeTypes::Terran_Infantry_Armor) == 1) {
		informationManager->buildRequest(UnitTypes::Terran_Science_Facility, true);
	}

	// Have 2 Science Vessel in total
	if (Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Engineering_Bay) > 0) {
		if (Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Science_Vessel) < 2) {
			if (Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Factory)==0 && !buildManager->alreadyBuilding(UnitTypes::Terran_Factory)) {
				informationManager->criticalBuildRequest(UnitTypes::Terran_Science_Facility, true);
				informationManager->criticalBuildRequest(UnitTypes::Terran_Starport, true);
				informationManager->criticalBuildRequest(UnitTypes::Terran_Factory, true);
			}
			informationManager->_trainOrder[UnitTypes::Terran_Starport] = UnitTypes::Terran_Science_Vessel;   
		} else if (informationManager->_trainOrder[UnitTypes::Terran_Starport] == UnitTypes::Terran_Science_Vessel) {
			informationManager->_trainOrder[UnitTypes::Terran_Starport] = UnitTypes::None;  
		}
	}
}


void OneRaxFE::Exit(StrategyManager* strategyManager)
{

}

//------------------------------------------------------------------------
// Methods for 2 Fact Vult/Mines
//------------------------------------------------------------------------

TwoFactMines* TwoFactMines::Instance()
{
	static TwoFactMines instance;
	return &instance;
}

void TwoFactMines::Enter(StrategyManager* strategyManager)
{  
	informationManager->buildRequest(UnitTypes::Terran_Supply_Depot);
	informationManager->buildRequest(UnitTypes::Terran_Barracks);
	informationManager->buildRequest(UnitTypes::Terran_Refinery);
	informationManager->buildRequest(UnitTypes::Terran_Factory);
	informationManager->buildRequest(UnitTypes::Terran_Machine_Shop);
	informationManager->buildRequest(UnitTypes::Terran_Supply_Depot);
	informationManager->buildRequest(UnitTypes::Terran_Factory);
	informationManager->buildRequest(UnitTypes::Terran_Machine_Shop);
	informationManager->buildRequest(UnitTypes::Terran_Supply_Depot);

	informationManager->researchRequest(TechTypes::Spider_Mines);
	informationManager->upgradeRequest(UpgradeTypes::Ion_Thrusters);

	informationManager->_percentList[UnitTypes::Terran_Vulture] = 100;
	
	informationManager->_retreatDisabled = true;
	informationManager->_minSquadSize = 6;
}


void TwoFactMines::Execute(StrategyManager* strategyManager)
{
	if (workerManager->workersDefending() && Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Marine)==0) {
		informationManager->_trainOrder[UnitTypes::Terran_Barracks] = UnitTypes::Terran_Marine;
	} else {
		informationManager->_trainOrder[UnitTypes::Terran_Barracks] = UnitTypes::None;
	}

// 	if ( Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Vulture) == 8 || Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Factory) > 3) {
// 		strategyManager->GetFSM()->ChangeState(ThreeFactories::Instance());
// 	}

	if ( Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Factory) > 2) {
		strategyManager->GetFSM()->ChangeState(TankTransition::Instance());
	}
}


void TwoFactMines::Exit(StrategyManager* strategyManager)
{
// 	informationManager->researchRequest(TechTypes::Tank_Siege_Mode);
// 	informationManager->naturalExpandRequest();
// 	if (Broodwar->enemy()->getRace() == Races::Protoss) {
// 		informationManager->_percentList[UnitTypes::Terran_Vulture] = 25;
// 		informationManager->_percentList[UnitTypes::Terran_Siege_Tank_Tank_Mode] = 75;
// 	} else {
// 		informationManager->_percentList[UnitTypes::Terran_Siege_Tank_Tank_Mode] = 100;
// 	}
 	informationManager->_trainOrder[UnitTypes::Terran_Barracks] = UnitTypes::None;
}


//------------------------------------------------------------------------
// Methods for Tank transition
//------------------------------------------------------------------------

TankTransition* TankTransition::Instance()
{
	static TankTransition instance;
	return &instance;
}

void TankTransition::Enter(StrategyManager* strategyManager)
{  
	informationManager->_autoBuildSuplies = true;
	informationManager->researchRequest(TechTypes::Tank_Siege_Mode);
	informationManager->naturalExpandRequest();

	informationManager->upgradeRequest(UpgradeTypes::Terran_Vehicle_Weapons, 1);
	informationManager->_autoVehicleUpgrade = true;

	informationManager->_percentList[UnitTypes::Terran_Vulture] = 90;
	informationManager->_percentList[UnitTypes::Terran_Siege_Tank_Tank_Mode] = 10;
}


void TankTransition::Execute(StrategyManager* strategyManager)
{
// 	if ( Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Vulture)+Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Siege_Tank_Tank_Mode) == 8 || 
// 		Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Factory) > 3) {
	if ( Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Factory) > 3) {
		strategyManager->GetFSM()->ChangeState(FullTank::Instance());      
	}
}


void TankTransition::Exit(StrategyManager* strategyManager)
{

}

//------------------------------------------------------------------------
// Methods for Full Tank
//------------------------------------------------------------------------

FullTank* FullTank::Instance()
{
	static FullTank instance;
	return &instance;
}

void FullTank::Enter(StrategyManager* strategyManager)
{  
	//informationManager->_autoBuildSuplies = true;
	informationManager->buildRequest(UnitTypes::Terran_Armory); // second armory

	informationManager->upgradeRequest(UpgradeTypes::Terran_Vehicle_Weapons, 3);
	informationManager->upgradeRequest(UpgradeTypes::Terran_Vehicle_Plating, 3);
	informationManager->_autoVehicleUpgrade = true;

	informationManager->_percentList[UnitTypes::Terran_Vulture] = 25;
	informationManager->_percentList[UnitTypes::Terran_Siege_Tank_Tank_Mode] = 75;
}


void FullTank::Execute(StrategyManager* strategyManager)
{
	// auto expand
	if (!buildManager->alreadyBuilding(UnitTypes::Terran_Command_Center) && !workerManager->needWorkers()) {
		if ( ( informationManager->minerals() > 1000 || (informationManager->minerals() > 500 && informationManager->gas() < 100) ) &&
			informationManager->getGasExpandPosition() != TilePositions::None ) {
				informationManager->gasExpandRequest(true);
		}
		if (informationManager->minerals()*2 < informationManager->gas() &&
			informationManager->getNaturalExpandPosition() != TilePositions::None)  {
				informationManager->naturalExpandRequest(true);
		}
	}

	// check air enemy force
	// *************** PROTOSS RULES ****************************************************
	if (informationManager->_enemyPhotonCanon == 0 && (informationManager->_enemyObserver == 0 || informationManager->_enemyAirDPS < 1) ) {
		informationManager->buildRequest(UnitTypes::Terran_Starport, true);
		informationManager->researchRequest(TechTypes::Cloaking_Field);
		informationManager->_trainOrder[UnitTypes::Terran_Starport] = UnitTypes::Terran_Wraith;
	} else {
		informationManager->_trainOrder[UnitTypes::Terran_Starport] = UnitTypes::None;
	}

	// Have 2 Science Vessel in total
// 	if (Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Engineering_Bay) > 0) {
// 		if (Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Science_Vessel) < 2) {
// 			if (Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Factory)==0 && !buildManager->alreadyBuilding(UnitTypes::Terran_Factory)) {
// 				informationManager->criticalBuildRequest(UnitTypes::Terran_Science_Facility, true);
// 				informationManager->criticalBuildRequest(UnitTypes::Terran_Starport, true);
// 				informationManager->criticalBuildRequest(UnitTypes::Terran_Factory, true);
// 			}
// 			informationManager->_trainOrder[UnitTypes::Terran_Starport] = UnitTypes::Terran_Science_Vessel;   
// 		} else if (informationManager->_trainOrder[UnitTypes::Terran_Starport] == UnitTypes::Terran_Science_Vessel) {
// 			informationManager->_trainOrder[UnitTypes::Terran_Starport] = UnitTypes::None;  
// 		}
// 	}
}


void FullTank::Exit(StrategyManager* strategyManager)
{

}