#pragma once
#include <BWAPI.h>

class ProductionType
{
public:
	enum Type
	{
		Unknown = -1,
		Unit = 0,
		Tech = 1,
		Upgrade = 2
	};
	ProductionType(BWAPI::UnitType unitType, int prio);
	ProductionType(BWAPI::TechType techType, int prio);
	ProductionType(BWAPI::UpgradeType upgradeType, int prio);
	bool operator<(const ProductionType &a) const; // to auto-sort on insert

	Type _type;
	BWAPI::UnitType _unit;
	BWAPI::TechType _tech;
	BWAPI::UpgradeType _upgrade;
	int _priority;

private:
	ProductionType(); // to prevent bad initialization	
};

/* EL SQUAD MERGE PETA EN ESTE CASO
.\Source\SquadManager.cpp:173: Merge 073841A8 <-> 074288E0
.\Source\SquadManager.cpp:173: Merge 074288E0 <-> 073841A8
.\Source\SquadManager.cpp:232: CHECK MERGING END (END)
.\Source\SquadManager.cpp:237: UPDATE SQUADS (START)
.\Source\SquadManager.cpp:246: UPDATE SQUADS (END)
.\Source\NovaAIModule.cpp:83: workerManager
.\Source\NovaAIModule.cpp:85: productionManager
.\Source\ProductionManager.cpp:122: [WARNING] We can increase barracks production
.\Source\NovaAIModule.cpp:87: buildManager
.\Source\NovaAIModule.cpp:89: ON FRAME (END)
.\Source\NovaAIModule.cpp:80: ON FRAME (START)
.\Source\NovaAIModule.cpp:81: squadManager
.\Source\SquadManager.cpp:169: CHECK MERGING (START)
.\Source\SquadManager.cpp:173: Merge 073841A8 <-> 074288E0
.\Source\SquadManager.cpp:208: Delete squad 074288E0
.\Source\SquadManager.cpp:173: Merge 074288E0 <-> 073841A8*/