#include "ProductionType.h"
using namespace BWAPI;

ProductionType::ProductionType() 
	: _unit(UpgradeTypes::Unknown),
	_tech(TechTypes::Unknown),
	_upgrade(UpgradeTypes::Unknown),
	_type(ProductionType::Unknown),
	_priority(0)
{

}

ProductionType::ProductionType(BWAPI::UnitType unitType, int prio)
	: _unit(unitType),
	_tech(TechTypes::Unknown),
	_upgrade(UpgradeTypes::Unknown),
	_type(ProductionType::Unit),
	_priority(prio)
{

}

ProductionType::ProductionType(BWAPI::TechType techType, int prio)
	: _unit(UpgradeTypes::Unknown),
	_tech(techType),
	_upgrade(UpgradeTypes::Unknown),
	_type(ProductionType::Tech),
	_priority(prio)
{

}

ProductionType::ProductionType(BWAPI::UpgradeType upgradeType, int prio)
	: _unit(UpgradeTypes::Unknown),
	_tech(TechTypes::Unknown),
	_upgrade(upgradeType),
	_type(ProductionType::Upgrade),
	_priority(prio)
{

}

bool ProductionType::operator<(const ProductionType &a) const
{
	return a._priority < _priority;
}