#include "NovaAIModule.h"
using namespace BWAPI;

void NovaAIModule::onStart()
{
	enhancedUI = new EnhancedUI();
	informationManager = new InformationManager();

	if (Broodwar->isReplay()) return;

	// Open log file.
	//fileLog.open("bwapi-data\\logs\\NovaAIModule.log");

	{
		SYSTEMTIME time;
		GetLocalTime(&time);
		//DEBUG(time.wYear << "/" << time.wMonth << "/" << time.wDay << " " << time.wHour << ":" << time.wMinute << ":" << time.wSecond);
		//DEBUG("--");
	}

	//Broodwar->enableFlag(Flag::UserInput);
	//Broodwar->enableFlag(Flag::CompleteMapInformation);
	// check MICRO map
//	char first = Broodwar->mapFileName()[0];
	ONLY_MICRO = false;
// 	if ( first != '(' ) {
// 		ONLY_MICRO = true;
// 	}

	// Initialize managers
	squadManager = new SquadManager();
	workerManager = new WorkerManager();
	plannerManager = new PlannerManager();
	productionManager = new ProductionManager();
	buildManager = new BuildManager();
	strategyManager = new StrategyManager(productionManager);
	
	if (ONLY_MICRO) {
		// Set enemy start position
		std::set<TilePosition> enemyPosition = Broodwar->getStartLocations();
		for (std::set<TilePosition>::const_iterator it = enemyPosition.begin(); it != enemyPosition.end(); ++it) {
			if ( (*it).x() != Broodwar->self()->getStartLocation().x() || (*it).y() != Broodwar->self()->getStartLocation().y())
				informationManager->_enemyStartPosition = Position((*it).x()*TILE_SIZE, (*it).y()*TILE_SIZE);
		}
		// Add units to squad
		squadManager->newSquad(Broodwar->self()->getUnits());

		//testing merge squads
// 		SquadAgent* squad1;SquadAgent*  squad2;SquadAgent*  squad3;
// 		squad1 = squadManager->testSquad(Broodwar->getUnitsInRadius(Position(28*TILE_SIZE,25*TILE_SIZE),40));
// 		squad2 = squadManager->testSquad(Broodwar->getUnitsInRadius(Position(28*TILE_SIZE,29*TILE_SIZE),40));
// 		squad3 = squadManager->testSquad(Broodwar->getUnitsInRadius(Position(28*TILE_SIZE,39*TILE_SIZE),40));
// 
// 		squad2->inMerge(squad3);
// 		squad3->inMerge(squad2);
// 		squadManager->_squadsToMerge.insert(std::make_pair(squad2, squad3));
// 		squad3->inMerge(squad1);
// 		squad1->inMerge(squad3);
// 		squadManager->_squadsToMerge.insert(std::make_pair(squad3, squad1));

	} else {
		informationManager->analyzeMap();
		// DISABLE GUI and speed for TOURNAMENT
		//Broodwar->setLocalSpeed(10);
		Broodwar->setGUI(false);
	}
}

NovaAIModule::~NovaAIModule()
{
	//TODO delete mangers
}

void NovaAIModule::onFrame()
{
	enhancedUI->onFrame();

	if (Broodwar->isReplay()) return;

	if (ONLY_MICRO) {
		squadManager->onFrame();
	} else {
		informationManager->_frameMineralSpend = 0;
		informationManager->_frameGasSpend = 0;
		//DEBUG("squadManager"); 
		squadManager->onFrame();
		//DEBUG("workerManager"); 
		workerManager->onFrame();
		//DEBUG("buildManager"); 
		buildManager->onFrame();
		//DEBUG("plannerManager");
		plannerManager->onFrame();
		//DEBUG("productionManager"); 
		productionManager->onFrame();
		//DEBUG("strategyManager"); 
		strategyManager->onFrame();
		//DEBUG("ON FRAME (END)"); 
	}
}

void NovaAIModule::onSendText(std::string text)
{
	if (Broodwar->isReplay()) return;

// 	if (text=="/show visibility") {
// 		show_visibility_data=!show_visibility_data;
// 	} else {
// 		Broodwar->printf("You typed '%s'!",text.c_str());
// 		Broodwar->sendText("%s",text.c_str());
// 	}
}

void NovaAIModule::onReceiveText(BWAPI::Player* player, std::string text)
{
  //Broodwar->printf("%s said '%s'", player->getName().c_str(), text.c_str());
}

void NovaAIModule::onNukeDetect(BWAPI::Position target)
{
//   if (target!=Positions::Unknown)
//     Broodwar->printf("Nuclear Launch Detected at (%d,%d)",target.x(),target.y());
//   else
//     Broodwar->printf("Nuclear Launch Detected");
}

void NovaAIModule::onUnitDiscover(BWAPI::Unit* unit)
{
	if (Broodwar->isReplay()) return;

	if (Broodwar->self()->isEnemy(unit->getPlayer())) {
		squadManager->newEnemy(unit);
		if ( unit->getType().isResourceDepot() ) {
			informationManager->onEnemyResourceDepotShow(unit);
		}
		if (Broodwar->enemy()->getRace() != Races::Zerg) {
			if (unit->getType().isFlyer()) informationManager->_turretDefenses = true;
		}
		if ( unit->getType() == UnitTypes::Terran_Vulture_Spider_Mine && !informationManager->_scienceVesselDetector) {
			informationManager->_scienceVesselDetector = true;
			if (Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Starport)==0 && !buildManager->alreadyBuilding(UnitTypes::Terran_Starport)) {
				informationManager->criticalBuildRequest(UnitTypes::Terran_Science_Facility, true);
				informationManager->criticalBuildRequest(UnitTypes::Terran_Starport, true);
				informationManager->criticalBuildRequest(UnitTypes::Terran_Factory, true);
			}
		}
	}
}

void NovaAIModule::onUnitEvade(BWAPI::Unit* unit)
{
	if (Broodwar->isReplay()) return;
	//DEBUG("EVADE UNIT (START) " << unit->getType().getName() << " [" << unit->getPlayer()->getName() << "]"); 

	if ( Broodwar->self()->isEnemy(unit->getPlayer())||
		(unit->getPlayer()->isNeutral() && unit->getType().isAddon()) ) {
		// remove from squad target
		squadManager->onEnemyEvade(unit);
	}
	//DEBUG("EVADE UNIT (END)"); 
}

void NovaAIModule::onUnitShow(BWAPI::Unit* unit)
{
	if (Broodwar->isReplay()) return;
	//DEBUG("SHOW UNIT (START) " << unit->getType().getName() << " [" << unit->getPlayer()->getName() << "]"); 
	if (!ONLY_MICRO) {
		if ( Broodwar->self() == unit->getPlayer() ) {
			if ( unit->getType() == UnitTypes::Terran_Vulture_Spider_Mine ) return; // skip spider mines
			if (unit->getType().isBuilding()) {
				productionManager->onBuildingShow(unit);
				buildManager->constructionPlaced(unit);
				if (!unit->getType().isAddon()) {
					informationManager->removeReservedMinerals(unit->getType().mineralPrice());
					informationManager->removeReservedGas(unit->getType().gasPrice());
				}
				if ( unit->getType() == UnitTypes::Terran_Command_Center ) informationManager->onCommandCenterShow(unit);
				if ( unit->getType() == UnitTypes::Terran_Missile_Turret ) informationManager->onMissileTurretShow(unit);
			} else if ( unit->getType() == UnitTypes::Terran_SCV )
				workerManager->addUnit(unit);
			else {
				plannerManager->rebalanceProduction();
				squadManager->unitTraining(unit);
			}
		}
	}
	//DEBUG("SHOW UNIT (END)"); 
}

void NovaAIModule::onUnitHide(BWAPI::Unit* unit)
{
	if (Broodwar->isReplay()) return;
	//Broodwar->printf("Unit hide");
}

void NovaAIModule::onUnitCreate(BWAPI::Unit* unit)
{
	if (Broodwar->isReplay()) return;
//	Broodwar->printf("Unit create");
}

void NovaAIModule::onUnitDestroy(BWAPI::Unit* unit)
{
	if (Broodwar->isReplay()) return;

	//DEBUG("DESTROY UNIT (START) " << unit->getType().getName() << " [" << unit->getPlayer()->getName() << "]"); 
	if (Broodwar->self() == unit->getPlayer()) { // self unit
		if (unit->getType().isBuilding()) {
			productionManager->onBuildingDestroy(unit);
			buildManager->onBuildingDestroy(unit);
			if ( unit->getType() == UnitTypes::Terran_Command_Center ) informationManager->onCommandCenterDestroy(unit);
			if ( unit->getType() == UnitTypes::Terran_Missile_Turret ) informationManager->onMissileTurretDestroy(unit);
		} else if ( unit->getType() == UnitTypes::Terran_SCV )
			workerManager->onUnitDestroy(unit);
		else {
			plannerManager->rebalanceProduction();
			squadManager->onUnitDestroy(unit);
		}
	} else if (Broodwar->self()->isEnemy(unit->getPlayer())) { // enemy unit
		squadManager->onEnemyDestroy(unit);
		if ( unit->getType().isResourceDepot() ) {
			informationManager->onEnemyResourceDepotDestroy(unit);
		}
	} else if (unit->getType().isMineralField()) {
		workerManager->onMineralDestroy(unit);
		// TODO free space on buildMap (buildManager)
	} else if (unit->getType().isAddon()) { // Neutral addon, could be self or enemy addon
		productionManager->onBuildingDestroy(unit);
		squadManager->onEnemyDestroy(unit);
	}
	//DEBUG("DESTROY UNIT (END)"); 
}

void NovaAIModule::onUnitMorph(BWAPI::Unit* unit)
{
	if (Broodwar->isReplay()) return;
	//Broodwar->printf("Unit morph");

	if ( Broodwar->self() == unit->getPlayer() ) {
		if (unit->getType() == UnitTypes::Terran_Refinery) {
			buildManager->refineryPlaced(unit);
			informationManager->removeReservedMinerals(unit->getType().mineralPrice());
			informationManager->removeReservedGas(unit->getType().gasPrice());
		}
	} else if (unit->getType().isRefinery()) {
		strategyManager->checkGasSteal(unit);
		squadManager->newEnemy(unit);
	} else if (unit->getType() == UnitTypes::Resource_Vespene_Geyser) {
		//Broodwar->printf("Enemy refinery destroyed");
		squadManager->onEnemyDestroy(unit);
	}

}

void NovaAIModule::onUnitRenegade(BWAPI::Unit* unit)
{
	if (Broodwar->isReplay()) return;
	//Broodwar->printf("Unit renegade");
}

void NovaAIModule::onEnd(bool isWinner)
{
	if (isWinner) {
		//log win to file
	}
	//fileLog.close();
}
