#include "EnhancedUI.h"
#include "WorkerManager.h"
using namespace BWAPI;

typedef std::set<BWTA::Region*> RegionSet;

void EnhancedUI::onFrame()
{
	if (informationManager->_scoutedAnEnemyBase) {
		Broodwar->drawCircleMap(informationManager->_enemyStartPosition.x(),informationManager->_enemyStartPosition.y(),20,Colors::Red,true);
	}

	// draw BWTA info
	if (informationManager->mapAnalyzed) {
		drawBases();
		drawTerrain();
	}

	// draw units health
	for(UnitSet::iterator i=Broodwar->getAllUnits().begin();i!=Broodwar->getAllUnits().end();i++) {
		// FIXME: only combat units (not buildings)
		drawUnitHealth(*i);
	}
	//drawVisibilityData();

	// Army stats
	Broodwar->drawTextScreen(290,13,"Marines: %d", Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Marine) );
	Broodwar->drawTextScreen(290,26,"Medics: %d", Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Medic) );

	// APM
	//Broodwar->drawTextScreen(575,15,"APM: %d", Broodwar->getAPM());

	// DPS Map
	informationManager->drawAirDPSMap();
	//informationManager->drawGroundDPSMap();

	// Debug box
	if (informationManager->_topLeft.x() != 0) {
		Broodwar->drawBoxMap(informationManager->_topLeft.x(), informationManager->_topLeft.y(),
							 informationManager->_bottomRight.x(), informationManager->_bottomRight.y(), Colors::Red);
	}
	// Debug circle
	if (informationManager->_center.x() != 0) {
		Broodwar->drawCircleMap(informationManager->_center.x(),informationManager->_center.y(),informationManager->_radius,Colors::Red,false);
		Broodwar->drawDotMap(informationManager->_center.x(),informationManager->_center.y(),Colors::Yellow);
	}
}

void EnhancedUI::drawUnitHealth(Unit* unit)
{
	// Hit points
	if (!unit->isVisible())
		return;
	double maxHealth = unit->getType().maxHitPoints() + unit->getType().maxShields();
	double health = unit->getHitPoints() + unit->getShields();

	Color barColor = Colors::Green;
	if (unit->isUnderAttack())
		barColor = Colors::Yellow;

	Broodwar->drawBox(CoordinateType::Map, unit->getPosition().x() - 7 + (int) (20 * health / maxHealth), unit->getPosition().y() + 7,
		unit->getPosition().x() - 7 + 20,
		unit->getPosition().y() + 10,
		Colors::Orange, true);

	Broodwar->drawBox(CoordinateType::Map, unit->getPosition().x() - 7, unit->getPosition().y() + 7,
		unit->getPosition().x() - 7 + (int) (20 * health / maxHealth),
		unit->getPosition().y() + 10,
		barColor, true);
}

void EnhancedUI::drawVisibilityData()
{
  for(int x=0;x<Broodwar->mapWidth();++x)
  {
    for(int y=0;y<Broodwar->mapHeight();++y)
    {
      if (Broodwar->isExplored(x,y))
      {
        if (Broodwar->isVisible(x,y))
          Broodwar->drawDotMap(x*TILE_SIZE+16,y*TILE_SIZE+16,Colors::Green);
        else
          Broodwar->drawDotMap(x*TILE_SIZE+16,y*TILE_SIZE+16,Colors::Blue);
      }
      else
        Broodwar->drawDotMap(x*TILE_SIZE+16,y*TILE_SIZE+16,Colors::Red);
    }
  }
}

void EnhancedUI::drawBases() const
{
	//we will iterate through all the base locations, and draw their outlines.
	// Our bases
	for(std::map<BWTA::BaseLocation*, BWAPI::TilePosition>::const_iterator i=informationManager->_ourBases.begin();i!=informationManager->_ourBases.end();++i) {
		TilePosition p = i->first->getTilePosition();
		Broodwar->drawBox(CoordinateType::Map,p.x()*TILE_SIZE,p.y()*TILE_SIZE,p.x()*TILE_SIZE+4*TILE_SIZE,p.y()*TILE_SIZE+3*TILE_SIZE,Colors::Green,false);
	}
	// Mineral patch
	workerManager->_mineralsExploitation;
	for(ResourceToWorkerMap::const_iterator j = workerManager->_mineralsExploitation.begin(); j != workerManager->_mineralsExploitation.end(); ++j) {
		Position q=j->first->getPosition();
		Broodwar->drawCircleMap(q.x(),q.y(),30,Colors::Cyan,false);
		Broodwar->drawTextMap(q.x(),q.y()-5,"%d", j->second);
	}

	// Empty bases
	for(std::set<BWTA::BaseLocation*>::const_iterator i=informationManager->_emptyBases.begin();i!=informationManager->_emptyBases.end();++i) {
		TilePosition p=(*i)->getTilePosition();
		Broodwar->drawBox(CoordinateType::Map,p.x()*TILE_SIZE,p.y()*TILE_SIZE,p.x()*TILE_SIZE+4*TILE_SIZE,p.y()*TILE_SIZE+3*TILE_SIZE,Colors::Yellow,false);
	}

	// Ignore bases
	for(std::set<TilePosition>::const_iterator i=informationManager->_ignoreBases.begin();i!=informationManager->_ignoreBases.end();++i) {
		TilePosition p=(*i);
		Broodwar->drawBox(CoordinateType::Map,p.x()*TILE_SIZE,p.y()*TILE_SIZE,p.x()*TILE_SIZE+4*TILE_SIZE,p.y()*TILE_SIZE+3*TILE_SIZE,Colors::Orange,false);
	}

	// Enemy bases
	for(std::set<BWTA::BaseLocation*>::const_iterator i=informationManager->_enemyBases.begin();i!=informationManager->_enemyBases.end();++i) {
		TilePosition p=(*i)->getTilePosition();
		Broodwar->drawBox(CoordinateType::Map,p.x()*TILE_SIZE,p.y()*TILE_SIZE,p.x()*TILE_SIZE+4*TILE_SIZE,p.y()*TILE_SIZE+3*TILE_SIZE,Colors::Red,false);
	}
}

void EnhancedUI::drawTerrain() const
{
	//we will iterate through all the regions and ...
	const RegionSet &regions = BWTA::getRegions();
	for(RegionSet::const_iterator r = regions.begin(); r != regions.end(); ++r)
	{
		// Draw the polygon outline of it in green
		const BWTA::Polygon &p=(*r)->getPolygon();
		for(int j=0;j<(int)p.size();j++)
		{
			Position point1=p[j];
			Position point2=p[(j+1) % p.size()];
			Broodwar->drawLine(CoordinateType::Map,point1.x(),point1.y(),point2.x(),point2.y(),Colors::Green);
		}

		// Draw the chokepoints with yellow lines
		const std::set<BWTA::Chokepoint*> &chokepoints = (*r)->getChokepoints();
		for(std::set<BWTA::Chokepoint*>::const_iterator c = chokepoints.begin(); c != chokepoints.end(); ++c)
		{
			const Position &point1=(*c)->getSides().first;
			const Position &point2=(*c)->getSides().second;
			Broodwar->drawLine(CoordinateType::Map,point1.x(),point1.y(),point2.x(),point2.y(),Colors::Yellow);
		}
	}
}

