#pragma once
#include <BWAPI.h>

typedef std::set<BWAPI::Unit*> UnitSet;
typedef std::set<BWAPI::TilePosition> TilePositionSet;
typedef std::map<BWAPI::UnitType, int> UnitToPercent;

// Display debug info on screen
#define DEBUG_DISPLAY 1

// FILE LOG
#define DEBUG(Message) fileLog << __FILE__ ":" << __LINE__ << ": " << Message << std::endl
#include <fstream>
extern std::ofstream fileLog;

// Managers:
class InformationManager;
class WorkerManager;
class SquadManager;
class BuildManager;

// Initialized in NovaAIModule::onStart();
extern InformationManager* informationManager;
extern WorkerManager* workerManager;
extern SquadManager* squadManager;
extern BuildManager* buildManager;

extern bool ONLY_MICRO;

BWAPI::Position rotatePosition(int degree, BWAPI::Position position, BWAPI::Position origen);
BWAPI::Position getPositionInDirection(BWAPI::Position origen, BWAPI::Position direction, int distance);