// Superclass for all working memory errors.

package wm;

import java.io.*;

public class WorkingMemoryError extends Error {
    private Throwable t = null;

    public WorkingMemoryError() { super(); }
    public WorkingMemoryError(String s) { super(s); }
    public WorkingMemoryError(String s, Throwable t) { 
	super(s);
	this.t = t; 
    }
    
    public void printStackTrace()
    {
	if (t != null) {
	    System.err.println(getMessage());
	    t.printStackTrace();
	}
	else 
	    super.printStackTrace();
    }

    public void printStackTrace(PrintStream s)
    {
	if (t != null) {
	    s.println(getMessage());
	    t.printStackTrace(s);
	}
	else
	    super.printStackTrace(s);
    }

    public void printStackTrace(PrintWriter w)
    {
	if (t != null) {
	    w.println(getMessage());
	    t.printStackTrace(w);
	}
	else
	    super.printStackTrace(w);
    }
}
