package wm;

import java.lang.reflect.*;
import java.util.*;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;

public abstract class WME implements Cloneable {

    // TODO: Will need to enforce the definition of equals if working memory modification routines are written which
    // allow a user to modify memory with WME descriptions rather than WME references. Currently working memory
    // can only be modified by WME references.
    /* Overrides equals(Object o) on class Object. The default
       equality test returns true if the two objects are precisely the
       same object (to references pointing to the same object in
       memory. Each concrete WME should redefine equals such that two
       WMEs are equal if they are the same class and their fields are
       equal. WME field equality should recursively depend only on
       value, not on reference identity. */
    // public abstract boolean equals(Object Obj);

    protected PropertyChangeSupport __support = new PropertyChangeSupport(this);

    protected final static String BOLD_TAG = "<B>";
    protected final static String UNBOLD_TAG = "</B>";

    public static String lowercaseFirstCharacter(String s) {
        StringBuffer tempStringBuffer = new StringBuffer(s);
        tempStringBuffer.setCharAt(0, Character.toLowerCase(tempStringBuffer.charAt(0)));
        return tempStringBuffer.toString();
    }

    public static String uppercaseFirstCharacter(String s) {
        StringBuffer tempStringBuffer = new StringBuffer(s);
        tempStringBuffer.setCharAt(0, Character.toUpperCase(tempStringBuffer.charAt(0)));
        return tempStringBuffer.toString();
    }

    public Method[] _getSetMethods()
    {
        try {
            Class thisClass = this.getClass();
            Method[] wmeMethods = thisClass.getMethods();
            List wmeSetMethods = new Vector(wmeMethods.length);

            for(int i = 0; i < wmeMethods.length; i++) {
                String methodName = wmeMethods[i].getName();
                if (methodName.substring(0,3).equals("set") &&
                        wmeMethods[i].getParameterTypes().length == 1) {
                    // The public method begins with the substring "get", and takes one parameter,
                    // hence it is a set accessor.

                    wmeSetMethods.add(wmeMethods[i]);
                }
            }
            Method[] wmeSetMethodArray = new Method[wmeSetMethods.size()];
            return (Method[])wmeSetMethods.toArray(wmeSetMethodArray);
        } catch (Exception e) {throw new WmeReflectionError(e);}
    }

    public Method[] _getGetMethods()
    {
        try {
            Class thisClass = this.getClass();
            Method[] wmeMethods = thisClass.getMethods();
            List wmeGetMethods = new Vector(wmeMethods.length);

            for(int i = 0; i < wmeMethods.length; i++) {
                String methodName = wmeMethods[i].getName();
                if (methodName.substring(0,3).equals("get") &&
                        !methodName.equals("getClass") &&
                        wmeMethods[i].getParameterTypes().length == 0) {
                    // The public method begins with the substring "get", takes no parameters and is not "getClass";
                    // hence it is a get accessor.

                    wmeGetMethods.add(wmeMethods[i]);
                }
            }
            Method[] wmeGetMethodArray = new Method[wmeGetMethods.size()];
            return (Method[])wmeGetMethods.toArray(wmeGetMethodArray);
        } catch (Exception e) {throw new WmeReflectionError(e);}
    }

    public String[] _getFieldNames()
    {
        Method[] getMethods = _getGetMethods();
        String[] fieldNames = new String[getMethods.length];
        for(int i = 0; i < getMethods.length; i++)
            fieldNames[i] = lowercaseFirstCharacter(getMethods[i].getName().substring(3));
        return fieldNames;
    }

    public Class[] _getFieldTypes()
    {
        Method[] getMethods = _getGetMethods();
        Class[] fieldTypes = new Class[getMethods.length];
        for(int i = 0; i < getMethods.length; i++)
            fieldTypes[i] = getMethods[i].getReturnType();
        return fieldTypes;
    }

    public Method _getGetMethod(String fieldName) throws NoSuchFieldException
    {
        String getMethodName = "get" + uppercaseFirstCharacter(fieldName);
        try {
            return this.getClass().getMethod(getMethodName, (Class[])null);
        } catch (NoSuchMethodException e) { throw new NoSuchFieldException(fieldName); }
    }

    public Method _getSetMethod(String fieldName, Class fieldType) throws NoSuchFieldException
    {
        String setMethodName = "set" + uppercaseFirstCharacter(fieldName);
        try {
            Class[] setArgs = { fieldType };
            return this.getClass().getMethod(setMethodName, setArgs);
        } catch (NoSuchMethodException e) { throw new NoSuchFieldException(fieldName); }
    }

    // Returns a string representation of the WME field values. 
    public String toString()
    {
        String[] fieldNames = _getFieldNames();
        Method[] getMethods = _getGetMethods();
        StringBuffer wmeString = new StringBuffer();
        wmeString.append("(");
        try {
            for(int i = 0; i < fieldNames.length; i++) {
                wmeString.append(fieldNames[i] + ": ");

                String formatFieldMethodName = "format" + uppercaseFirstCharacter(fieldNames[i]);

                // fixme: quick and dirty fix for avoiding cycles when creating string representation of a wme;
                // don't recursively call WME.toString() on WMEs. Eventually fix with something that really avoids
                // cycles.
                if (!Class.forName("wm.WME").isAssignableFrom(getMethods[i].getReturnType())) {
                    // The return type of the get accessor is not a WME; safe to implicitly evoke toString()
                    // on the return type.

                    // If there is a special formatter for the field use it, otherwise do a default toString()
                    try {
                        Method formatFieldMethod = this.getClass().getMethod(formatFieldMethodName, (Class[])null);
                        wmeString.append(formatFieldMethod.invoke(this, (Object[])null));
                    } catch (NoSuchMethodException e) {
                        wmeString.append(getMethods[i].invoke(this, (Object[])null));
                    }
                }
                else {
                    // The return type of the get accessor *is* assignable to a WME

                    // If there is a special formatter for the field use it, otherwise use the super (default)
                    // string represetation for the WME or "null" if the return value is null.
                    try {
                        Method formatFieldMethod = this.getClass().getMethod(formatFieldMethodName, (Class[])null);
                        wmeString.append(formatFieldMethod.invoke(this, (Object[])null));
                    } catch (NoSuchMethodException e) {
                        WME tempWME = (WME)getMethods[i].invoke(this, (Object[])null);
                        if (tempWME == null)
                            wmeString.append(tempWME);
                        else
                            wmeString.append(tempWME.objectToString());
                    }
                }
                if ((i + 1) != fieldNames.length)
                    wmeString.append(", ");
            }
            wmeString.append(")");
            return wmeString.toString();
        }
        catch (Exception e) {throw new WmeReflectionError(e);}
    }

    // Returns a formatted (html) string representation of the WME field values. 
    public String toString_HTML()
    {
        String[] fieldNames = _getFieldNames();
        Method[] getMethods = _getGetMethods();
        StringBuffer wmeString = new StringBuffer();

        wmeString.append("<font size = \"-1\" face=\"Helvetica, Arial, sans-serif\">");
        wmeString.append("(");
        try {
            for(int i = 0; i < fieldNames.length; i++) {
                wmeString.append(fieldNames[i] + ": ");

                String formatFieldMethodName = "format" + uppercaseFirstCharacter(fieldNames[i]);

                // fixme: quick and dirty fix for avoiding cycles when creating string representation of a wme;
                // don't recursively call WME.toString() on WMEs. Eventually fix with something that really avoids
                // cycles.
                if (!Class.forName("wm.WME").isAssignableFrom(getMethods[i].getReturnType())) {
                    // The return type of the get accessor is not a WME; safe to implicitly evoke toString()
                    // on the return type.

                    // If there is a special formatter for the field use it, otherwise do a default toString()
                    try {
                        Method formatFieldMethod = this.getClass().getMethod(formatFieldMethodName, (Class[])null);
                        wmeString.append(BOLD_TAG + formatFieldMethod.invoke(this, (Object[])null) + UNBOLD_TAG);
                    } catch (NoSuchMethodException e) {
                        wmeString.append(BOLD_TAG + getMethods[i].invoke(this, (Object[])null) + UNBOLD_TAG);
                    }
                }
                else {
                    // The return type of the get accessor *is* assignable to a WME;

                    // If there is a special formatter for the field use it, otherwise use the super (default)
                    // string represetation for the WME or "null" if the return value is null.
                    try {
                        Method formatFieldMethod = this.getClass().getMethod(formatFieldMethodName, (Class[])null);
                        wmeString.append(BOLD_TAG + formatFieldMethod.invoke(this, (Object[])null) + UNBOLD_TAG);
                    } catch (NoSuchMethodException e) {
                        WME tempWME = (WME)getMethods[i].invoke(this, (Object[])null);
                        if (tempWME == null)
                            wmeString.append(BOLD_TAG + tempWME + UNBOLD_TAG );
                        else
                            wmeString.append(BOLD_TAG + tempWME.objectToString() + UNBOLD_TAG);
                    }

                }

                if ((i + 1) != fieldNames.length)
                    wmeString.append(", ");
            }
            wmeString.append(")");
            return wmeString.toString();
        }
        catch (Exception e) {throw new WmeReflectionError(e);}
    }

    // Returns the default (Object.toString()) string representation of the WME
    protected String objectToString() { return super.toString(); }

    public WME cloneWME() {
        try {
            return (WME)clone();
        }
        catch (CloneNotSupportedException e) { throw new WorkingMemoryError(e.getMessage()); }
    }

    // Support for property change listeners
    public void addPropertyChangeListener(PropertyChangeListener lis) { __support.addPropertyChangeListener(lis); }
    public void removePropertyChangeListener(PropertyChangeListener lis) { __support.removePropertyChangeListener(lis); }
    public void addPropertyChangeListener(String propName, PropertyChangeListener lis)
    {
        __support.addPropertyChangeListener(lis);
    }
    public void removePropertyChangeListener(String propName, PropertyChangeListener lis)
    {
        __support.removePropertyChangeListener(propName, lis);
    }

    // Transient wmes should override this and return true. 
    public boolean isTransient() { return false; }

    // Assign the values of the argument WME to this one
    public void assign(WME wmeToAssign)
    {
        Method[] getMethods = wmeToAssign._getGetMethods();
        Class[] fieldTypes = wmeToAssign._getFieldTypes();
        for(int i = 0; i < getMethods.length; i++) {
            try {
                String fieldName = lowercaseFirstCharacter(getMethods[i].getName().substring(3));
                Class argType = getMethods[i].getReturnType();
                try {
                    Method setMethod = this._getSetMethod(fieldName, argType);
                    Object[] setArgs = { getMethods[i].invoke(wmeToAssign, (Object[])null) };
                    setMethod.invoke(this, setArgs);
                } catch (NoSuchFieldException e) { } // If the attempt to grab setMethod generates a NoSuchFieldException (thrown by _getSetMethod), just move on. The newly created WME will have the default value for this field, rather than the edited value.
            } catch (Exception e) { throw new WmeReflectionError(e); }
        }
    }

    /*
     * Added by Gillian Smith, 06-08-10. Returns the short name of the WME.
     */
    public String getClassname()
    {
        return WorkingMemory.wmeShortName(this);    
    }
}

