// All episodic WMEs inherit from TimeStampedWME

package wm;

import java.text.SimpleDateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JComboBox;
import java.awt.event.*;

public abstract class TimeStampedWME extends WME implements Comparable {
    private long timestamp;

    private static final SimpleDateFormat formatter;

    static { 
	formatter = new SimpleDateFormat("MM.dd.yyyy hh:mm:ss:S a");
    }

    public TimeStampedWME(long timestamp) { this.timestamp = timestamp; }
    public TimeStampedWME() { timestamp = 0; }

    public synchronized long getTimestamp() { return timestamp; }
    public synchronized void setTimestamp(long timestamp) { this.timestamp = timestamp; }

    public synchronized String formatTimestamp() 
    {
	return formatter.format(new Date(getTimestamp()));
    }

    private final static String[] menuItems = { "Set current time" };
    private class TimestampEditor extends JComboBox implements WMEFieldEditor {

	TimestampEditor() 
	{
	    super(menuItems);
	    setEditable(true);
	    if (getTimestamp() != 0)
		setSelectedItem(formatTimestamp());
	    else
		setSelectedItem("");
	    addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent e) {
			// Only one menu item, so if an action fires we know it is this item
			setFieldValue(Long.toString(System.currentTimeMillis()));
		    } });
	}
       
	public String getFieldValue() 
	{ 
	    try {
		return Long.toString(formatter.parse(getSelectedItem().toString()).getTime());
	    } catch (ParseException e) {
		System.err.println("Parse error: " + e.getMessage() + " in TimestampEditor.getTimeValue(). Returning null.");
		return null;
	    }
	}

	// s is a string representation of a long
	public void setFieldValue(String s) 
	{ 
	    setSelectedItem(formatter.format(new Date(Long.parseLong(s)))); 
	}

    }

    public WMEFieldEditor _getTimestampEditor() { return new TimestampEditor(); }

    // Comparable implementation
    public int compareTo(Object o)
    {
	TimeStampedWME wmeToCompare = (TimeStampedWME)o;
	if (getTimestamp() < wmeToCompare.getTimestamp()) return -1;
	else if (getTimestamp() > wmeToCompare.getTimestamp()) return 1;
	else return 0;
    }
}


