package eisbot.proxy;

import java.awt.Robot;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Date;

public class ICCupRobot {

	private Robot robot;	    			
	private boolean running = true;
	private boolean usePassword = false; 
	
	public static void main(String[] args) {
		ICCupRobot iccupRobot = new ICCupRobot();
		iccupRobot.start();
	} 
	
	public ICCupRobot() {
		try {
			robot = new Robot();	
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	} 

	public void start() { 
		setStatus(null, false, false);
		String password = launchGame();		
		setStatus(password, true, false);
		startMatch();
		setStatus(null, false, true);
	}

	public void stop() {
		running = false;
	}
	 
	public String launchGame() {
		
		int p1 = (int)(26.0*Math.random());
		int p2 = (int)(26.0*Math.random());
		int p3 = (int)(26.0*Math.random()); 
		
		String password = "" 
			+ (char)('a' + p1)
			+ (char)('a' + p2)
			+ (char)('a' + p3);
		System.out.println("Game password: " + password);
		  
		try {

        	Thread.sleep(5000);		        	
        	System.out.println("Starting SC");
        	// lap top 760 705
        	// eistool 450, 680
			robot.mouseMove(450, 680);
        	Thread.sleep(100);
			robot.mousePress(InputEvent.BUTTON1_MASK);
        	Thread.sleep(100);
			robot.mouseRelease(InputEvent.BUTTON1_MASK);
 
        	// get onto ICCup 
        	Thread.sleep(10000);
        	robot.keyPress(KeyEvent.VK_M);
        	Thread.sleep(100);
        	robot.keyRelease(KeyEvent.VK_M);

        	Thread.sleep(2000);
        	robot.keyPress(KeyEvent.VK_E);
        	Thread.sleep(100);
        	robot.keyRelease(KeyEvent.VK_E);
 
        	Thread.sleep(2000);
        	robot.keyPress(KeyEvent.VK_ENTER);
        	Thread.sleep(100);
        	robot.keyRelease(KeyEvent.VK_ENTER);

        	// password == "transway"
        	// TODO: change to your specific password
        	Thread.sleep(15000);
        	Thread.sleep(100);
        	robot.keyPress(KeyEvent.VK_T);
        	Thread.sleep(100);
        	robot.keyRelease(KeyEvent.VK_T);
        	Thread.sleep(100);
        	robot.keyPress(KeyEvent.VK_R);
        	Thread.sleep(100);
        	robot.keyRelease(KeyEvent.VK_R);
        	Thread.sleep(100);
        	robot.keyPress(KeyEvent.VK_A);
        	Thread.sleep(100);
        	robot.keyRelease(KeyEvent.VK_A);
        	Thread.sleep(100);
        	robot.keyPress(KeyEvent.VK_N);
        	Thread.sleep(100);
        	robot.keyRelease(KeyEvent.VK_N);
        	Thread.sleep(100);
        	robot.keyPress(KeyEvent.VK_S);
        	Thread.sleep(100);
        	robot.keyRelease(KeyEvent.VK_S);
        	Thread.sleep(100);
        	robot.keyPress(KeyEvent.VK_W);
        	Thread.sleep(100);
        	robot.keyRelease(KeyEvent.VK_W);
        	Thread.sleep(100);
        	robot.keyPress(KeyEvent.VK_A);
        	Thread.sleep(100);
        	robot.keyRelease(KeyEvent.VK_A);
        	Thread.sleep(100);
        	robot.keyPress(KeyEvent.VK_Y);
        	Thread.sleep(100);
        	robot.keyRelease(KeyEvent.VK_Y);
        	Thread.sleep(100);
        	robot.keyPress(KeyEvent.VK_ENTER);
        	Thread.sleep(100); 
        	robot.keyRelease(KeyEvent.VK_ENTER);

        	Thread.sleep(5000);
			robot.mouseMove(50, 280);	
			robot.mousePress(InputEvent.BUTTON1_MASK);
        	Thread.sleep(100);
			robot.mouseRelease(InputEvent.BUTTON1_MASK);
			
        	// password 325, 230
        	Thread.sleep(5000);
        	if (usePassword) {
				robot.mouseMove(325, 230);	 
				robot.mousePress(InputEvent.BUTTON1_MASK);
	        	Thread.sleep(100);
				robot.mouseRelease(InputEvent.BUTTON1_MASK);
	        	
	        	Thread.sleep(2000);
	        	robot.keyPress(KeyEvent.VK_A + p1);
	        	Thread.sleep(100);
	        	robot.keyRelease(KeyEvent.VK_A + p1);
	        	Thread.sleep(500);
	        	robot.keyPress(KeyEvent.VK_A + p2);
	        	Thread.sleep(100);
	        	robot.keyRelease(KeyEvent.VK_A + p2);
	        	Thread.sleep(500);
	        	robot.keyPress(KeyEvent.VK_A + p3);
	        	Thread.sleep(100);
	        	robot.keyRelease(KeyEvent.VK_A + 3);        	
        	}

        	Thread.sleep(2000);
        	robot.keyPress(KeyEvent.VK_ENTER);
        	Thread.sleep(100);
        	robot.keyRelease(KeyEvent.VK_ENTER);
        	
		} 
		catch (Exception e) {
			e.printStackTrace();
		}
		
		return password;
	}	
	
	// 320, 300
	public void clickLagging() {
		try {
			robot.mouseMove(320, 300);
			robot.mousePress(InputEvent.BUTTON1_MASK);
			robot.mouseRelease(InputEvent.BUTTON1_MASK);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void exitGame() {
		try {
	    	Thread.sleep(2000);
	    	robot.keyPress(KeyEvent.VK_ENTER);
	    	Thread.sleep(100);
	    	robot.keyRelease(KeyEvent.VK_ENTER);
	    	Thread.sleep(2000);
	    	
	    	robot.keyPress(KeyEvent.VK_ENTER);
	    	Thread.sleep(100);
	    	robot.keyRelease(KeyEvent.VK_ENTER);
	    	Thread.sleep(2000);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void startMatch() {
		try {
			
        	// select protoss
        	Thread.sleep(5000);
			robot.mouseMove(250, 45);
        	Thread.sleep(1000);
			robot.mousePress(InputEvent.BUTTON1_MASK);
        	Thread.sleep(1000);
			robot.mouseMove(250, 90);	// for Protoss
        	Thread.sleep(1000);
			robot.mouseRelease(InputEvent.BUTTON1_MASK);
			Thread.sleep(1000);

			// wait for opponent 
        	while (true) {
        		if (!running) {
        			System.out.println("Opponent timeout expired");
        			return;
        		}
        		
            	Thread.sleep(1000);
        		int pixel53 = robot.getPixelColor(275, 53).getRGB();
        		int pixel54 = robot.getPixelColor(275, 54).getRGB();

        		if (pixel53 == -9699328 || pixel54 == -9699328) {        			
                	Thread.sleep(5000);
            		pixel53 = robot.getPixelColor(275, 53).getRGB();
            		pixel54 = robot.getPixelColor(275, 54).getRGB();

            		if (pixel53 == -9699328 || pixel54 == -9699328) {        			
            			break;
            		}
        		}
        	} 
        	
        	// start match 
        	Thread.sleep(500);
        	robot.keyPress(KeyEvent.VK_ALT);
        	Thread.sleep(500);
        	robot.keyPress(KeyEvent.VK_O);
        	Thread.sleep(100);
        	robot.keyRelease(KeyEvent.VK_O);
        	Thread.sleep(500);
        	robot.keyRelease(KeyEvent.VK_ALT);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	 
	public void setStatus(String password, boolean matchmaking, boolean inGame) {
		String message = "<html><head><title>EISBot</title></head><body><a href=\"http://eis.ucsc.edu/EISBot\">EISBot</a> is now available for playtesting on Battle.net<p>Server: ICCup";
 
		if (matchmaking) {
			message += "<br>Status: <img src=\"active.png\"> In Matchmaking<br>Game Name: EISBot<br>Password: " + password + "</body></html>";
		} 
		else if (inGame) { 
			message += "<br>Status: <img src=\"active.png\"> In Game</body></html>";		 
		}
		else {
			message += "<br>Status: <img src=\"inactive.png\"> Offline (Setting Up Match)";		
		}
		
		// ICCup Stats
		Stats stats = getStats();
		message += "<br>Last Update: " + new Date(System.currentTimeMillis()).toLocaleString(); 
		message += "<p>Points: " + stats.points + " <br>Record: " + stats.record + " <br>Ratio: " + stats.ratio;		
		message += "</body></html>";
		message = message.replaceAll(" ", "%20");

		try {
			URL url = new URL("http://users.soe.ucsc.edu/~bweber/EISBot/status.php?message=" + message);
			URLConnection con = url.openConnection();
			BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
			while (in.readLine() != null) {}
			in.close();
		}
		catch (Exception e) {
			System.err.println("Unable to update web status");
		}
	}
	
	class Stats {
		String points = "";
		String record = "";
		String ratio = "";
	}
	
	public Stats getStats() {
		Stats stats = new Stats();
		
		try {
			URL url = new URL("http://www.iccup.com/starcraft/gamingprofile/scgda.html");
			URLConnection con = url.openConnection();
			BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
			
			String line = in.readLine().trim();
			while (line != null) {
				line = line.trim();
				
				if (line.startsWith("<div class=\"field1 width160\">Points")){
					line = in.readLine();
					stats.points = line.split(">")[1].split("<")[0];
				}
				else if (line.startsWith("<div class=\"field1 width160\">Statistics")){
					line = in.readLine();
					stats.record= line.split(">")[1].split("<")[0];
				}
				else if (line.startsWith("<div class=\"field1 width160\">Win Ratio")){
					line = in.readLine();
					stats.ratio = line.split(">")[1].split("<")[0];
					return stats;
				}

				line = in.readLine();
			}

			in.close();		
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		
		return stats;
	}

}
