package eisbot.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.util.TreeMap;
import java.util.Map.Entry;

import javax.swing.JPanel;

import eisbot.abl.ABLStarCraftBot;
import eisbot.abl.Game;
import eisbot.abl.wmes.ReconWME;

public class ReconPanel extends JPanel {
	
	boolean repaintQueued = false;
	
	public void paint(Graphics g) {

		super.paint(g);
		g.setColor(Color.WHITE);
		g.fillRect(0, 0, getWidth(), getHeight());
		
		Game game = ABLStarCraftBot.getGame();
		ReconWME recon = game.getRecon();
		if (recon == null) {
			return;
		} 
		
		synchronized(recon) {

			// player units
			g.setColor(Color.BLACK);
			int x = 15;
			int y = 25;
			g.drawString("Player Units", x, y);
			y += 18;
			g.drawString("-----------------------------", x, y);
			
			TreeMap<String, Integer> types = new TreeMap<String, Integer>();
			for (Entry<Integer, Integer> entry : recon.getPlayerCounts().entrySet()) {
				types.put(game.getUnitTypes().get(entry.getKey()).getName(), entry.getValue());
			}
			
			for (String type : types.keySet()) {
				y += 18;
				g.drawString(type + ": " + types.get(type), x, y);
			}
	
			// enemy units
			types.clear();
			for (Integer type : recon.getEnemyTypes()) {
				types.put(game.getUnitTypes().get(type).getName(), 0);
			}
			
			y = 25;
			x += 200;
			g.drawString("Enemy Units", x, y);
			y += 18;
			g.drawString("-----------------------------", x, y);
			for (String type : types.keySet()) {
				y += 18;
				g.drawString(type, x, y);
			}
		}
		
		// set up a repaint event
		if (!repaintQueued) {
			repaintQueued = true;
			
			new Thread() {
				public void run() {
					try {
						sleep(1000);
						repaintQueued = false;
						ReconPanel.this.repaint();
					}
					catch (Exception e) {}
				}
			}.start();
		}
	}
}
