package eisbot.abl.wmes;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import wm.WME;
import eisbot.abl.Game;
import eisbot.abl.StarCraftConstants;
import eisbot.proxy.wmes.UnitTypeWME;
import eisbot.proxy.wmes.unit.AllyUnitWME;
import eisbot.proxy.wmes.unit.EnemyUnitWME;
import eisbot.proxy.wmes.unit.PlayerUnitWME;

public class ReconWME extends WME {

	Map<Integer, Integer> playerCounts;
	Map<Integer, Integer> allyCounts;
	Set<Integer> enemyTypes;
	HashSet<Integer> currentEnemyTypes = new HashSet<Integer>();
	
	public ReconWME() {
		playerCounts = Collections.synchronizedMap(new HashMap<Integer, Integer>());
		allyCounts = Collections.synchronizedMap(new HashMap<Integer, Integer>());
		enemyTypes = Collections.synchronizedSet(new HashSet<Integer>());
	}
	
	public void update(Game game) {
		synchronized(this) {
		
			playerCounts.clear();
			for (PlayerUnitWME unit : game.getPlayerUnits()) {
				if (unit.getActive()) {
					Integer count = playerCounts.get(unit.getTypeID());
					playerCounts.put(unit.getTypeID(), 1 + (count != null ? count : 0));
				}
			}
			
			allyCounts.clear();
			for (AllyUnitWME unit : game.getAllyUnits()) {
				Integer count = allyCounts.get(unit.getTypeID());
				allyCounts.put(unit.getTypeID(), 1 + (count != null ? count : 0));
			}
			
			
			HashSet<Integer> currentTypes = new HashSet<Integer>();
			for (EnemyUnitWME unit : game.getEnemyUnits()) {
				if (!unit.getActive()) {
					continue;
				}
				
				enemyTypes.add(unit.getTypeID());
				currentTypes.add(unit.getTypeID());
				
				// also add pre-req types
				UnitTypeWME type = game.getUnitTypes().get(unit.getTypeID());
				if (type != null) {
					if (type.getWhatBuilds() != -1) {
						enemyTypes.add(type.getWhatBuilds());
					}
					
					if (type.getFirstUnitReq() != -1) {
						enemyTypes.add(type.getFirstUnitReq());
					}
					
					if (type.getSecondUnitReq() != -1) {
						enemyTypes.add(type.getSecondUnitReq());
					}
				}
			}
			
			currentEnemyTypes = currentTypes;
		} 
	}

	public boolean getEnemyCannons() {
		return currentEnemyTypes.contains(StarCraftConstants.Protoss_Photon_Cannon);
	}

	public boolean getEnemySunkens() {
		return currentEnemyTypes.contains(StarCraftConstants.Zerg_Sunken_Colony);
	}

	public boolean getEnemyBunkers() {
		return currentEnemyTypes.contains(StarCraftConstants.Terran_Bunker);
	}
	
	public boolean getEnemyTanks() {
		return currentEnemyTypes.contains(StarCraftConstants.Terran_Siege_Tank_Siege_Mode) ||
		 	   currentEnemyTypes.contains(StarCraftConstants.Terran_Siege_Tank_Tank_Mode);
	}

	public int getNumType(int type) {
		Integer count = playerCounts.get(type);
		if (count != null) {
			return count;
		}
		else {
			return 0;
		}
	}
	
	public int getNumForces() {
		return getNumZealots() + getNumDragoons() + 3*getNumCarriers();
	}

	public int getNumCarriers() {
		return getNumType(StarCraftConstants.Protoss_Carrier);
	}

	public int getNumObs() {
		return getNumType(StarCraftConstants.Protoss_Observer);
	}

	public int getNumZealots() {
		return getNumType(StarCraftConstants.Protoss_Zealot);
	}

	public int getNumDragoons() {
		return getNumType(StarCraftConstants.Protoss_Dragoon);
	}
 	
 	public int getNumProbes() {
		return getNumType(StarCraftConstants.Protoss_Probe);
	}
	
	public int getNumAssimilators() {
		return getNumType(StarCraftConstants.Protoss_Assimilator);
	}
		
	public int getMyNexusCount() {
		return getNumType(StarCraftConstants.Protoss_Nexus);
	}
	
	public Set<Integer> getEnemyTypes() {
		return enemyTypes;
	}
	
	public Map<Integer, Integer> getPlayerCounts() {
		return playerCounts;
	}
	
	public boolean getEnemyCloakingTech() {
		return 
			enemyTypes.contains(StarCraftConstants.Protoss_Dragoon) ||
			enemyTypes.contains(StarCraftConstants.Protoss_Cybernetics_Core) ||
			enemyTypes.contains(StarCraftConstants.Zerg_Lurker_Egg) ||
			enemyTypes.contains(StarCraftConstants.Zerg_Lurker) ||
			enemyTypes.contains(StarCraftConstants.Zerg_Hydralisk) ||
			enemyTypes.contains(StarCraftConstants.Zerg_Hydralisk_Den) ||
			enemyTypes.contains(StarCraftConstants.Terran_Starport) ||
			enemyTypes.contains(StarCraftConstants.Terran_Wraith);
	}
}
