package eisbot.abl.sensors;

import java.util.HashSet;

import abl.runtime.BehavingEntity;
import eisbot.abl.ABLStarCraftBot;
import eisbot.proxy.wmes.unit.NewUnitWME;
import eisbot.proxy.wmes.unit.PlayerUnitWME;


public class NewUnitSensor extends StarCraftSensor {

	/** last timestamp that the sensor was sensed */
	private long lastUpdate = -1;
	
	private HashSet<Integer> units = new HashSet<Integer>();
	
	protected void sense() {

		// check if the game has changed
		if (ABLStarCraftBot.getGame().getGameFrame() > lastUpdate) {
			lastUpdate = ABLStarCraftBot.getGame().getGameFrame();
		}
		else {
			return;
		}

		// load the list when the game is first loaded
		if (units.size() == 0) {
			for (PlayerUnitWME unit : ABLStarCraftBot.getGame().getPlayerUnits()) {
				units.add(unit.getID());
			}
		}
		//
		else {			
			for (PlayerUnitWME unit : ABLStarCraftBot.getGame().getPlayerUnits()) {
				if (!units.contains(unit.getID())) {
		            BehavingEntity.getBehavingEntity().addWME(new NewUnitWME(unit.getTypeID()));
				}
				
				units.add(unit.getID());
			}			
		}
            
	}
}
