package eisbot.abl;
/**
 * 
 * 
 * 
 * System Properties
 * -DFogOfWar=true
 * -DParticleFilter=true
 * -DDefaultParticles=false
 */
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import abl.runtime.BehavingEntity;
import eisbot.abl.wmes.KeyPressWME;
import eisbot.gui.ABLPanel;
import eisbot.gui.ABTViewer;
import eisbot.gui.CommandLogPanel;
import eisbot.gui.LoggingPanel;
import eisbot.gui.ReconPanel;
import eisbot.gui.SpeedPanel;
import eisbot.gui.StarCraftFrame;
import eisbot.gui.WMEPanel;
import eisbot.proxy.BWAPIEventListener;
import eisbot.proxy.ICCupRobot;
import eisbot.proxy.JNIBWAPI;
import eisbot.proxy.command.CommandQueue;
import eisbot.proxy.filter.ParticleFilter.ParticleFilterMode;
import eisbot.proxy.model.Unit;

public class ABLStarCraftBot implements BWAPIEventListener {

	private static ABLStarCraftBot thisInstance;	
	
	private CommandQueue commandQueue = new CommandQueue();;

	public static boolean IgnoreBases = false;	// for micro scenarios
	
	/** reference to JNI-BWAPI */ 
	private JNIBWAPI bwapi;
	
	private BehavingEntity ablBot; 
	
	private Game game;

	private boolean autoCamera = false;
	private long lastCameraUpdate = 0;  
	 
	private int drawBuildLocations = 0;
	private boolean drawParticles = false;

	private ICCupRobot robot;	   
	boolean iccup = false;	 
	      
//	private boolean showGUI = !iccup; 
	private boolean showGUI = false;
	private boolean autoRestart = false;
	private boolean useManners = false; 
	private boolean fastest = false;  
//	private boolean userInput = !iccup;
	private boolean userInput = false;
	private boolean fogOfWar = false; 
 	 
	private StarCraftFrame gameFrame;
	private SpeedPanel speedPanel = null;
	private WMEPanel wmePanel = null;
	private ABTViewer abtViewer;	
	private JFrame mainFrame;
 
	private int delay = 0;
	private int quitFrame = 0;

	public static void main(String[] args) {
		
		if (System.getProperty("ABLBotName") == null) {
			System.setProperty("ABLBotName", "ProtossBot");
		}
		  
		new ABLStarCraftBot(); 
	}
 
	public ABLStarCraftBot() {
		thisInstance = this;
		initParticleFilterSettings();

		while (true) {			
			if (iccup) startRobot();

			bwapi = new JNIBWAPI(ABLStarCraftBot.this);
			bwapi.start();

			if (iccup) killStarCraft();
		}
	}
		
	private void initParticleFilterSettings() { 
				  
		// get the particle filter mode
		ParticleFilterMode mode = ParticleFilterMode.PerfectInformation;
		try { 
			mode = ParticleFilterMode.valueOf(System.getProperty("ParticleFilterMode"));
		}
		catch (NullPointerException e) {
			e.printStackTrace();
		} 
		
		switch (mode) {
		case PerfectInformation:
			fogOfWar = false;
			System.setProperty("ParticleFilter", "" + false);
			System.setProperty("IdentifyParticles", "" + false); 
			System.setProperty("DefaultParticles", "" + false);
			System.setProperty("UseTargetVector", "" + false);			
			break;
		case NoMemoryParticles: 
			fogOfWar = true;
			System.setProperty("ParticleFilter", "" + false);
			System.setProperty("IdentifyParticles", "" + false); 
			System.setProperty("DefaultParticles", "" + false);
			System.setProperty("UseTargetVector", "" + false);			
			break;
		case DefaultParticles: 
			fogOfWar = true;
			System.setProperty("ParticleFilter", "" + true);
			System.setProperty("IdentifyParticles", "" + false); 
			System.setProperty("DefaultParticles", "" + true);
			System.setProperty("UseTargetVector", "" + false);			
			break;
		case OptimizedParticles:  
			fogOfWar = true;
			System.setProperty("ParticleFilter", "" + true);
			System.setProperty("IdentifyParticles", "" + false); 
			System.setProperty("DefaultParticles", "" + false);
			System.setProperty("UseTargetVector", "" + false);			
			break;
		case DefaultIdentifyParticles: 
			fogOfWar = true;
			System.setProperty("ParticleFilter", "" + true);
			System.setProperty("IdentifyParticles", "" + true); 
			System.setProperty("DefaultParticles", "" + true);
			System.setProperty("UseTargetVector", "" + false);			
			break;
		case OptimizedIdentifyParticles: 
			fogOfWar = true;
			System.setProperty("ParticleFilter", "" + true);
			System.setProperty("IdentifyParticles", "" + true); 
			System.setProperty("DefaultParticles", "" + false);
			System.setProperty("UseTargetVector", "" + false);			
			break;
		}

		System.out.println("Particle Filter Mode: " + mode);  
	}

	public static BehavingEntity getBehavingEntity() {
		return thisInstance.ablBot;
	}
		
	public static CommandQueue getQueue() {
		return thisInstance.commandQueue;
	}
	
	public static Game getGame() {
		return thisInstance.game;
	}
	
	public void connected() {
		System.out.println("Connected to StarCraft");
		bwapi.loadTypeData();
	}	

	public void gameStarted() { 
		quitFrame = 0;
		
		if (IgnoreBases == false) {
			bwapi.loadMapData(true);			
		} 
		 
		if (userInput) bwapi.enableUserInput();
		if (!fogOfWar) bwapi.enablePerfectInformation();
		if (fastest) bwapi.setGameSpeed(0);

		try {
			game = new Game(bwapi);
			commandQueue.clear();
			
			// Start the ABL agent
			ablBot = (BehavingEntity)Class.forName("eisbot.abl.java." + System.getProperty("ABLBotName")).newInstance();			
			ablBot.setUseSynchrousSensors();
			
			new Thread() {
				public void run() {
					ablBot.startBehaving();			
				}
			}.start();			
		
			// set up the GUI components
			if (showGUI) {
				
				mainFrame = new JFrame("EISBot");
	    		JPanel flowPanel = new JPanel();
	    		JPanel panel = new JPanel();	    		
	    		
	    		panel.setLayout(new BorderLayout());
	    		speedPanel = new SpeedPanel(game);
	    		panel.add(speedPanel, BorderLayout.NORTH);
	    			    		
	    		ABLPanel ablPanel = new ABLPanel();
	    		ABLStarCraftBot.getBehavingEntity().addBehavingListener(ablPanel);
	    		
	    		wmePanel = new WMEPanel();
	    		panel.add(wmePanel, BorderLayout.WEST);
	    		panel.add(ablPanel, BorderLayout.SOUTH);
	    		panel.setBorder(BorderFactory.createTitledBorder("ABL"));
	    		
	    		CommandLogPanel logPanel = new CommandLogPanel();
	    		commandQueue.addCommandListener(logPanel);
	    		logPanel.setBorder(BorderFactory.createTitledBorder("Commands Issued"));
	    		
	    		flowPanel.setLayout(new BorderLayout());
	    		flowPanel.add(panel, BorderLayout.WEST);
	    		flowPanel.add(logPanel, BorderLayout.CENTER);
	    	    		
	    		JTabbedPane mainPanel = new JTabbedPane();
	    		mainPanel.setPreferredSize(new Dimension(600, 500));
	    		mainFrame.add(mainPanel);
	    		
	    		mainPanel.addTab("Controls", flowPanel);	    		
	    		mainFrame.pack(); 
	    		mainFrame.setVisible(true);
	    		
	    		// logging panel
	    		LoggingPanel loggingPanel = new LoggingPanel();
	    		Logger.addListener(loggingPanel);
	    		mainPanel.addTab("Logging", loggingPanel);	    			    				
	    		
	    		abtViewer = new ABTViewer();
	    		ablBot.addBehavingListener(abtViewer);
				mainPanel.addTab("ABL Tree", abtViewer);
				
				gameFrame = new StarCraftFrame(game);
				commandQueue.addCommandListener(gameFrame);
				
				panel = new JPanel();
				panel.setLayout(new BorderLayout());
				panel.add(gameFrame, BorderLayout.CENTER);
				panel.add(gameFrame.getLayerPanel(), BorderLayout.SOUTH);		    				
	    		mainPanel.addTab("Game View", panel);	    		
	    		
	    		mainPanel.addTab("Recon", new ReconPanel());	    		
			}			
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	} 
	
	public void gameUpdate() {
		try {
			if (delay > 0) {
				Thread.sleep(delay);
			}
		}
		catch (Exception e) {}
				
		game.update(bwapi); 
		commandQueue.processCommands(bwapi);
 
		// say gg, etc
		if (useManners) {
			useManners();
		}
		
		// draw build locations
		if (drawBuildLocations > 0) {
			game.getMap().drawLocations(bwapi, game, drawBuildLocations, drawPylons);
		}
		
		if (drawParticles) { 
			game.getParticleFilter().draw(bwapi);
		}  

		bwapi.drawText(8, 16, "FPS: " + bwapi.getFPS(), true);		
 
//		for (UnitWME unit : game.getPlayerUnits()) { 
//			bwapi.drawText(unit.getRealX(), unit.getRealY(), "" + unit.getSpawnFrame(), false);		 
//		}


	}	 
	
	public void menuUpdate(int menuFrame) {
		if (iccup) {   
			if (menuFrame>2500000) {
				robot.stop();
				bwapi.disconnect();
			}
		}   
	} 
	 
	public void useManners() {
		if (game.getGameFrame() == 60) {
			bwapi.sendText("This is EISBot");
		}
		else if (game.getGameFrame() == 120) {
			bwapi.sendText("A project at UC Santa Cruz");
		}
		else if (game.getGameFrame() == 180) {
			bwapi.sendText("Thanks for playing!");
		}
		 
		// check for gg 
		if (quitFrame == 0) {
			int probeCount = 0;
			int nexusHealth = 0;
			
			for (Unit unit : bwapi.getMyUnits()) {
				if (unit.getTypeID() == StarCraftConstants.Protoss_Probe) {
					probeCount++;
				}
				else if (unit.getTypeID() == StarCraftConstants.Protoss_Nexus) {
					nexusHealth = Math.max(nexusHealth, unit.getHitPoints());
				}
			}
			
			if (probeCount < 3 || nexusHealth < 200) {
				quitFrame = bwapi.getFrameCount() + 120;
				bwapi.sendText("GG");
			}
		}
		 
		// leave the match
		if (quitFrame > 0 && bwapi.getFrameCount() >= quitFrame) {
			quitFrame = 0;
			bwapi.leaveGame(); 
		}
	} 
	
	public void killStarCraft() {
		
		// rest of this is for ICCup mode
		try {	    		
    		Process kill = Runtime.getRuntime().exec(new String[] {"TASKKILL", "/IM", "StarCraft.exe"});
    		kill.waitFor();
    		System.out.println("StarCraft exit code: " + kill.exitValue());
    		Thread.sleep(5000);
		}
		catch (Exception e) {
			e.printStackTrace();
		}			
	}
	
	public void startRobot() {
		new Thread() {
			public void run() {
				robot = new ICCupRobot();
				robot.start();
			}
		}.start();
	}
	
	public void gameEnded() { 
		System.out.println("Game ended");

		if (showGUI) {
			gameFrame.stop();
			wmePanel.stop();
			abtViewer.stop();
			mainFrame.setVisible(false);	    		
		}

		ablBot.stopBehaving();
		System.exit(0);
	}
	
	boolean shiftPressed = false;
	boolean drawHealth = false;
	boolean drawIDs = false;
	boolean drawTargets = false;
	boolean drawPylons = false;
	  
	public void keyPressed(int keyCode) {

		// change speed? 
		if (keyCode == 189) {
			delay+=10;
			System.out.println("Delay: " + delay);
		}
		else if (keyCode == 187) {
			if (delay > 0) delay-=10;
			System.out.println("Delay: " + delay); 
		}
 
		// make WMEs
		if (shiftPressed) {
			ABLStarCraftBot.getBehavingEntity().getWorkingMemory().addWME(new KeyPressWME(keyCode));
		}
		
		if (shiftPressed && keyCode == KeyEvent.VK_B) {	
			drawBuildLocations++;
			if (drawBuildLocations == 4) drawBuildLocations = 0;
		}
		 
		if (shiftPressed && keyCode == KeyEvent.VK_A) {	
			drawHealth = !drawHealth;
			bwapi.drawHealth(drawHealth);
		}
		if (shiftPressed && keyCode == KeyEvent.VK_I) {	
			drawIDs = !drawIDs;
			bwapi.drawIDs(drawIDs);
		}
		if (shiftPressed && keyCode == KeyEvent.VK_T) {	
			drawTargets = !drawTargets;
			bwapi.drawTargets(drawTargets);
		}
		if (shiftPressed && keyCode == KeyEvent.VK_Y) {	
			drawPylons = !drawPylons;
		}
		if (shiftPressed && keyCode == KeyEvent.VK_P) {	 
			drawParticles = !drawParticles;
		}
		if (shiftPressed && keyCode == KeyEvent.VK_S) {	 
			autoCamera = !autoCamera;
		}

		shiftPressed = (keyCode == 160);
	}
	
	public void matchEnded(boolean winner) { 
		System.out.println("Match ended: " + winner);

		
//		JOptionPane.showMessageDialog(null, "Match ended: " + winner + "   :" + bwapi.getFrameCount());	
		
//		for (PlayerScore score : bwapi.playerScores()) {
//			System.out.println("Player: " + score.getID());
//			System.out.println("  " + score.getBuildingScore());
//			System.out.println("  " + score.getCompletedUnits()); 
//			System.out.println("  " + score.getCumulativeMinerals());
//			System.out.println("  " + score.getCumulativeGas());
//			System.out.println("  " + score.getCustomScore());
//			System.out.println("  " + score.getDeadUnits());
//			System.out.println("  " + score.getKilledUnits());
//			System.out.println("  " + score.getKillScore());
//			System.out.println("  " + score.getRazingScore());
//			System.out.println("  " + score.getUnitScore());
//		}  
		
		if (autoRestart) {
			bwapi.restartGame();
		} 

		// shuts down all c++ side code
		if (iccup) {
			bwapi.disconnect();
		}
	}
	
	public void unitCreate(int unitID) { 
		if (autoCamera) {
			Unit unit = bwapi.getUnit(unitID);
			if (unit != null) {
				if (System.currentTimeMillis() - lastCameraUpdate > 8000) {				
					lastCameraUpdate = System.currentTimeMillis();
					bwapi.setCameraLocation(unit.getX() - 320, unit.getY() - 240);
				}
			}
		}
	}
  
	public void unitDestroy(int unitID) { 
		if (autoCamera) {
			Unit unit = bwapi.getUnit(unitID);
			if (unit != null) {
				if (System.currentTimeMillis() - lastCameraUpdate > 3000) {				
					lastCameraUpdate = System.currentTimeMillis();
					bwapi.setCameraLocation(unit.getX() - 320, unit.getY() - 240);
				}
			}
		}
	} 

	public void unitDiscover(int unitID) {   
		if (autoCamera) {
			Unit unit = bwapi.getUnit(unitID);
			if (unit != null && unit.getPlayerID() != 11) { 
				if (System.currentTimeMillis() - lastCameraUpdate > 4000) {				
					lastCameraUpdate = System.currentTimeMillis(); 
					bwapi.setCameraLocation(unit.getX() - 320, unit.getY() - 240);
				}
			}
		}		 
	} 
	
//	public void unitDestroy(int unitID) { }
	public void nukeDetect(int x, int y) { } 
	public void nukeDetect() { }
	public void playerLeft(int id) { }
	public void unitEvade(int unitID) { }
	public void unitHide(int unitID) { }
	public void unitMorph(int unitID) { }
	public void unitShow(int unitID) { }	
} 
