// Simple trace facility

package debug;

import abl.runtime.BehavingEntity;

public class Trace {
    static final boolean traceAll = false; // set to true to turn on all trace statements
    static final boolean traceFreeze = false; // set to true to turn on trace statements related to freezing subtrees
    static final boolean traceTrip = false; // set to true to turn on trace statements for Trip
    static final boolean traceGrace = true; // set to true to trun on trace statements for Grace

    static final int eTraceType_traceFreeze = 0;

    public static void ablTrace(String s)
    {
	String shortName = BehavingEntity.getBehavingEntity().getBehavingEntityShortName();
	if ((shortName.equals("Trip") && traceTrip) ||
	    (shortName.equals("Grace") && traceGrace))
	    if (traceAll)
		System.out.println(shortName + ": " + s);
    }

    /*
    public static void trace(BehavingEntity entity, String s)
    {
	if (entity.getBehavingEntityShortName().equals("Trip") && traceTrip)
	    trace("Trip: " + s);
	else if (entity.getBehavingEntityShortName().equals("Grace") && traceGrace)
	    trace("Grace: " + s);
    }
    */
}
