package abl.runtime;

import java.lang.reflect.*;
import java.util.ArrayList;
import java.util.List;

// BehaviorDescriptor - used to store information about behaviors in a behaving entities behavior registration table.

public class __BehaviorDesc {
    final int behaviorID; // unique behavior id
    final Method factory; // the behavior factory method to call for this behavior
    final Method precondition; // the precondition method to call for this behavior - null if no precondition
    final Method preconditionSensorFactory; // the precondition sensor factory method to call for this behavior
    // fixme: since __BehaviorDescs are indexed by signature in the entity, consider not storing it explicitly
    final String signature; // behavior signature -- associated with the most general version of the behavior
    String uniqueName; // unique behavior name (<name>_<num>) - set when behavior is registered
    final String[] teamMembers; // array of team member descriptors - currently class names
    final short specificity; // behavior specificity

    //behaviors now have more than one signature associated with them, due to inheritance
    final String[] signatures;


    public __BehaviorDesc(int arg_behaviorID, Method arg_factory, Method arg_precondition,
                          Method arg_preconditionSensorFactory, String arg_signature, String[] arg_signatures,
                          String[] arg_teamMembers, short arg_specificity)
    {
        behaviorID = arg_behaviorID;
        factory = arg_factory;
        precondition = arg_precondition;
        preconditionSensorFactory = arg_preconditionSensorFactory;
        signature = arg_signature;
        uniqueName = null;
        teamMembers = arg_teamMembers;
        specificity = arg_specificity;

        //add all the signatures associated with this behavior
        signatures = arg_signatures;
    }
}
