// Class for debug wait steps. 
package abl.runtime;

import java.lang.reflect.Method;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.DefaultMutableTreeNode;

public class WaitStepDebug extends WaitStep implements DebuggableStep {

    public WaitStepDebug(int stepID, Behavior arg_parent, boolean arg_persistent, boolean arg_persistentWhenSucceeds, 
		    boolean arg_persistentWhenFails, boolean arg_ignoreFailure, boolean arg_effectOnly, 
		    boolean arg_teamEffectOnly, short arg_priority, short arg_priorityModifier, boolean arg_post, 
		    String arg_postMemory, Method arg_execute, Method arg_successTest, Method arg_successTestSensorFactory, 
		    AblNamedPropertySupport arg_propertyTable)
    {
	super(stepID, arg_parent, arg_persistent, arg_persistentWhenSucceeds, arg_persistentWhenFails, arg_ignoreFailure, 
	      arg_effectOnly, arg_teamEffectOnly, arg_priority, arg_priorityModifier, arg_post, arg_postMemory, 
	      arg_execute, arg_successTest, arg_successTestSensorFactory, arg_propertyTable);
    }

    // fixme: add trace support for suspend.

    // execute() is not valid on WaitSteps - inherit the execute() error method on WaitStep

    final void succeedStep() 
    {
	((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.WAIT_STEP_COMPLETION, this, new Boolean(true), getNestLevel());
	super.succeedStep();
    }

    final void failStep() 
    {
	((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.WAIT_STEP_COMPLETION, this, new Boolean(false), getNestLevel());
	super.failStep();
    }

    final boolean successTest()
    {
	final boolean ret = super.successTest();
	if (ret == true)
	    ((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.SUCCESS_TEST_SUCCESS, this, null, getNestLevel());
	
	return ret;
    }

    // Returns a tree node which wraps the subtree rooted at this node in the ABT. 
    public final MutableTreeNode getTree() {
	return new DefaultMutableTreeNode(this);
    }

    // fixme: change this from a recursive call to an accessor for the nest level (see Behavior).
    // to do this, will need to reset the nest level when a goal spawns.
    public final int getNestLevel() {
	return ((DebuggableBehavior)parent).getNestLevel() + 1;
    }

}




