// Class for wait steps. 
package abl.runtime;

import java.lang.reflect.Method;

public class WaitStep extends Step {

	public WaitStep(int stepID, Behavior arg_parent, boolean arg_persistent,
			boolean arg_persistentWhenSucceeds,
			boolean arg_persistentWhenFails, boolean arg_ignoreFailure,
			boolean arg_effectOnly, boolean arg_teamEffectOnly,
			short arg_priority, short arg_priorityModifier, boolean arg_post,
			String arg_postMemory, Method arg_execute, Method arg_successTest,
			Method arg_successTestSensorFactory,
			AblNamedPropertySupport arg_propertyTable) {
		super(stepID, arg_parent, arg_persistent, arg_persistentWhenSucceeds,
				arg_persistentWhenFails, arg_ignoreFailure, arg_effectOnly,
				arg_teamEffectOnly, arg_priority, arg_priorityModifier,
				arg_post, arg_postMemory, arg_execute, arg_successTest,
				arg_successTestSensorFactory, arg_propertyTable, WAIT);
	}

	// Reseting a wait step does nothing. It should never be called.
	void resetStep() {
		throw new RuntimeError("Attempt to reset a wait step.");
	}

	// Executing a wait step does nothing. It should never be called.
	void execute() {
		throw new RuntimeError("Attempt to execute a wait step.");
	}

	/**
	 * To suspend a wait step, just call suspendStep(WaitStep s) on
	 * BehavingEntity (deactivates the success test)
	 */
	private final void suspendWait() {
		BehavingEntity.getBehavingEntity().suspendStep(this);
	}

	void jointSuspend() {
		super.jointSuspend();
		suspendWait();
	}

	void metaSuspend() {
		super.metaSuspend();
		suspendWait();
	}

	
	/**
	 * To unsuspend a wait step, check if the wait is still suspended and call BehavingEntity.unsuspend(WaitStep s), 
	 * which reactives the success test. 
	 */
	private final void unsuspendWait() {
		if (!isSuspended()) {
			BehavingEntity.getBehavingEntity().unsuspendStep(this);
		}
	}
	
	public void metaUnsuspend() {
		super.metaUnsuspend();
		unsuspendWait();
	}

	void jointUnsuspend() {
		super.jointUnsuspend();
		unsuspendWait();
	}
}
