// Joint behavior negotiation ended up in an unexpected state

package abl.runtime;

public class UnexpectedStateError extends JointGoalNegotiationError {
    private JointGoalStep s = null;

    public UnexpectedStateError(int state) { super("Unexpected state " + stateName(state)); }
    public UnexpectedStateError(int state, BehavingEntity entity) { super(entity + ": Unexpected state " + stateName(state)); }
    public UnexpectedStateError(int state, JointGoalStep s) 
    { 
	super("Unexpected state " + stateName(state) + "in goal " + s); 
	this.s = s;
    }

    public UnexpectedStateError(int state, BehavingEntity entity, JointGoalStep s) 
    { 
	super(entity + ": Unexpected state " + stateName(state) + "in goal " + s); 
	this.s = s;
    }

    public String getMessage() {
	if (s != null && s.negotiator.getClass().getName().equals("abl.runtime.JointGoalNegotiatorDebug")) {
	    System.err.println("UnexpectedStateError");
	    s.negotiator.printNegotiationHistory(); 
	    return super.getMessage();
	}
	else
	    return super.getMessage();
    }
}
