// Class for debug succeed steps. 

package abl.runtime;

import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.DefaultMutableTreeNode;

public class SucceedStepDebug extends SucceedStep implements DebuggableStep {

    // Constructor for SucceedStep calls the super constructor. 
    // It is not legal to associate persistence properties, ignore failure, or success tests with a succeed step.
    public SucceedStepDebug(int stepID, Behavior arg_parent, boolean arg_effectOnly, 
		       boolean arg_teamEffectOnly, short arg_priority, short arg_priorityModifier, boolean arg_post, 
		       String arg_postMemory, AblNamedPropertySupport arg_propertyTable)
    {
	super(stepID, arg_parent, arg_effectOnly, arg_teamEffectOnly, arg_priority, arg_priorityModifier, arg_post, 
	      arg_postMemory, arg_propertyTable);
    }

    // fixme: add trace support for suspend.

    final void execute() 
    {
	((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.SUCCEEDSTEP_EXECUTION, this, null, getNestLevel());
	super.execute();
    }

    final void succeedStep() 
    {
	((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.SUCCEEDSTEP_COMPLETION, this, new Boolean(true), getNestLevel());
	super.succeedStep();
    }

    final void failStep() 
    {
	((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.SUCCEEDSTEP_COMPLETION, this, new Boolean(false), getNestLevel());
	super.failStep();
    }

    final boolean successTest()
    {
	final boolean ret = super.successTest();
	if (ret == true)
	    ((DebuggableBehavior)parent).traceAblExecutionEvent(AblEvent.SUCCESS_TEST_SUCCESS, this, null, getNestLevel());
	
	return ret;
    }

    // Returns a tree node which wraps the subtree rooted at this node in the ABT. 
    public final MutableTreeNode getTree() {
	return new DefaultMutableTreeNode(this);
    }

    // fixme: change this from a recursive call to an accessor for the nest level (see Behavior).
    // to do this, will need to reset the nest level when a goal spawns.
    public final int getNestLevel() {
	return ((DebuggableBehavior)parent).getNestLevel() + 1;
    }

}
