// Class for succeed steps. 

package abl.runtime;

public class SucceedStep extends Step {

    // Constructor for SucceedStep calls the super constructor. 
    // It is not legal to associate persistence properties, ignore failure, or success tests with a succeed step.
    public SucceedStep(int stepID, Behavior arg_parent, boolean arg_effectOnly, 
		       boolean arg_teamEffectOnly, short arg_priority, short arg_priorityModifier, boolean arg_post, 
		       String arg_postMemory, AblNamedPropertySupport arg_propertyTable)
    {
	super(stepID, arg_parent, false, false, false, false, 
	      arg_effectOnly, arg_teamEffectOnly, arg_priority, arg_priorityModifier, arg_post, arg_postMemory, null, null, 
	      null, arg_propertyTable, SUCCEED);
    }

    // Execute succeeds the step. Overrides execute on Step.
    void execute() { succeedStep(); }

    void resetStep() { BehavingEntity.getBehavingEntity().resetStep(this); }

}
