// WME wrapper for steps.

package abl.runtime;

import java.util.*;
import wm.WME;

public class StepWME extends WME 
{
    protected Step s; // The step wrapped by this WME
    protected BehaviorWME parent; // The parent behavior WME wrapping the parent behavior
    protected boolean valid = true;

    // Eventually support property changes for the working memory debugger
    // protected changes = new PropertyChangeSupport(this);

    public StepWME(Step sToSet, BehaviorWME parentToSet)
    {
	assert parentToSet != null; // Parent must not be null
	s = sToSet;
	parent = parentToSet;
	sToSet.setReflectionWME(this);
    }
    
    // ### Get Accessors ###

    public synchronized boolean getPersistent() { return s.getPersistent(); }
    public synchronized boolean getPersistentWhenSucceeds() { return s.getPersistentWhenSucceeds(); }
    public synchronized boolean getPersistentWhenFails() { return s.getPersistentWhenFails(); }
    public synchronized boolean getIgnoreFailure() { return s.getIgnoreFailure(); }
    public synchronized boolean getHasSuccessTest() { return s.getHasSuccessTest(); }
    public synchronized boolean getEffectOnly() { return s.getEffectOnly(); }
    public synchronized boolean getIsAtomic() { return s.getIsAtomic(); }
    public synchronized short getPriority() { return s.getPriority(); }
    public synchronized boolean getIsSuspended() { return s.isSuspended(); }
    public synchronized BehaviorWME getParent() { return parent; } 
    public synchronized short getStepType() { return s.getStepType(); }

	// APS 9.11.02
    public synchronized boolean getValid() { return valid; } 

    public final synchronized int getStepID() { return s.getStepID(); }
    
    // ### Set Accessors ###
    public synchronized void setPersistent(boolean b) { s.setPersistent(b); }
    public synchronized void setPersistentWhenSucceeds(boolean b) { s.setPersistentWhenSucceeds(b); }
    public synchronized void setPersistentWhenFails(boolean b) { s.setPersistentWhenFails(b); }
    public synchronized void setIgnoreFailure(boolean b) { s.setIgnoreFailure(b); }
    public synchronized void setEffectOnly(boolean b) { s.setEffectOnly(b); }
    public synchronized void setPriority(short i) { s.setPriority(i); }

    // accessors for named properties
    public synchronized Object getProperty(String name) { return s.propertyTable.getProperty(name); }
    public synchronized void setProperty(String name, Object value) { ((GoalStep)s).propertyTable.setProperty(name, value); }
    public synchronized void deleteProperty(String name) { ((GoalStep)s).propertyTable.deleteProperty(name); }
    public synchronized List getAllDefinedProperties() { return s.propertyTable.getAllDefinedProperties(); }
    
    
    // fixme: need to return an array of WMEs that are properly linked into the tree.
    /* public synchronized StepWME[] getStepsSuspendingMe()
    {
	LinkedList stepsSuspendingMe = s.getStepsSuspendingMe();
	if (stepsSuspendingMe.size() == 0)
	    // no suspending steps
	    return new StepWME[0];
	else {
	    // there are suspending steps
	    LinkedList stepWMEsSuspendingMe = new LinkedList();
	    Iterator stepIterator = stepsSuspendingMe.iterator();
	    while(stepIterator.hasNext()) {
		Step s = (Step)stepIterator.next();
		stepWMEsSuspendingMe.add(new StepWME(s, s.getParent()));
	    }
	    return (StepWME[])stepWMEsSuspendingMe.toArray(new StepWME[stepWMEsSuspendingMe.size()]);
	}
	} */

    // fixme: need to return an array of WMEs that are properly linked into the tree. 
    /* public synchronized StepWME[] getStepsIHaveSuspended()
    {
	LinkedList stepsIHaveSuspended = s.getStepsIHaveSuspended();
	if (stepsIHaveSuspended.size() == 0)
	    // no suspending steps
	    return new StepWME[0];
	else {
	    // there are suspending steps
	    LinkedList stepWMEsIHaveSuspended = new LinkedList();
	    Iterator stepIterator = stepsIHaveSuspended.iterator();
	    while(stepIterator.hasNext()) {
		Step s = (Step)stepIterator.next();
		stepWMEsIHaveSuspended.add(new StepWME(s, s.getParent()));
	    }
	    return (StepWME[])stepWMEsIHaveSuspended.toArray(new StepWME[stepWMEsIHaveSuspended.size()]);
	}
	} */

    public boolean isValid() { return valid; }

    // ### Meta controls ###

    // Fail the step
    public synchronized void fail()
    {
	if (isValid() && s != null)
	    s.failStep();
    }

    // Succeed the step
    public synchronized void succeed()
    {
	if (isValid() && s != null)
	    s.succeedStep();
    }

    // returns true if the goal is recursively a parent of this step.
    public synchronized boolean isParent(GoalStepWME parentGoal) { return parent.isParent(parentGoal); }

    // returns true if the behavior is recursively a parent of this step.
    public synchronized boolean isParent(BehaviorWME parentBehavior) 
    {
	if (parent == parentBehavior)
	    return true;
	else 
	    return parent.isParent(parentBehavior); 
    }
    
    // update StepWME state so that it knows it no longer wraps a valid ABT node
    // package access - can only be called from within abl.runtime
    void delete() { valid = false; }

    public String toString() { return objectToString() + super.toString(); }
}
