// Comparator used to compare step priorities on instantiated steps.

package abl.runtime;

import java.util.Comparator;

class StepPriorityComparator implements Comparator {
    
    /* Compares the priority of two instantiated steps.
       Returns value > 0 if o1.getPriority() > o2.getPriority().
       Returns value = 0 if o1.getPriority() = o2.getPriority().
       Returns value < 0 if o1.getPriority() < o2.getPriority().
       Note: this comparator imposes orderings that are inconsistent with equals() because 
       it inherits equals from Object which tests for *reference* equality. */
    public int compare(Object o1, Object o2) {
	Integer i1 = new Integer(((Step)o1).getPriority());
	Integer i2 = new Integer(((Step)o2).getPriority());
	return i2.compareTo(i1);
    }
}
